/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.server.service.impl;

import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.DataSources;
import org.apache.linkis.datasourcemanager.common.auth.AuthContext;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.protocol.DsInfoQueryRequest;
import org.apache.linkis.datasourcemanager.common.protocol.DsInfoResponse;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.MdmConfiguration;
import org.apache.linkis.metadata.query.common.cache.CacheConfiguration;
import org.apache.linkis.metadata.query.common.domain.DataSourceTypeEnum;
import org.apache.linkis.metadata.query.common.domain.GenerateSqlInfo;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.domain.MetaPartitionInfo;
import org.apache.linkis.metadata.query.common.errorcode.LinkisMetadataQueryErrorCodeSummary;
import org.apache.linkis.metadata.query.common.exception.MetaMethodInvokeException;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.GenerateSqlTemplate;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.server.loader.MetaClassLoaderManager;
import org.apache.linkis.metadata.query.server.service.MetadataQueryService;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MetadataQueryServiceImpl
implements MetadataQueryService {
    private Sender dataSourceRpcSender;
    private MetaClassLoaderManager metaClassLoaderManager;
    private static final Logger logger = LoggerFactory.getLogger(MetadataQueryServiceImpl.class);

    @PostConstruct
    public void init() {
        this.dataSourceRpcSender = Sender.getSender((String)((String)MdmConfiguration.DATA_SOURCE_SERVICE_APPLICATION.getValue()));
        this.metaClassLoaderManager = new MetaClassLoaderManager();
    }

    @Override
    public void getConnection(String dataSourceType, String operator, Map<String, Object> params) throws Exception {
        MetadataConnection metadataConnection = (MetadataConnection)this.invokeMetaMethod(dataSourceType, "getConnection", new Object[]{operator, params}, Map.class);
        if (Objects.nonNull(metadataConnection)) {
            Closeable connection = (Closeable)metadataConnection.getConnection();
            try {
                connection.close();
            }
            catch (IOException e) {
                logger.warn("Fail to close connection[\u5173\u95ed\u8fde\u63a5\u5931\u8d25], [" + e.getMessage() + "]", (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public List<String> getDatabasesByDsId(String dataSourceId, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.reqToGetDataSourceInfo(dataSourceId, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getDatabases", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams()}, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    @Deprecated
    public List<String> getTablesByDsId(String dataSourceId, String database, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.reqToGetDataSourceInfo(dataSourceId, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getTables", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database}, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    @Deprecated
    public Map<String, String> getPartitionPropsByDsId(String dataSourceId, String database, String table, String partition, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.reqToGetDataSourceInfo(dataSourceId, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (Map)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getPartitionProps", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table, partition}, Map.class);
        }
        return new HashMap<String, String>();
    }

    @Override
    @Deprecated
    public Map<String, String> getTablePropsByDsId(String dataSourceId, String database, String table, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.reqToGetDataSourceInfo(dataSourceId, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (Map)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getTableProps", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table}, Map.class);
        }
        return new HashMap<String, String>();
    }

    @Override
    @Deprecated
    public MetaPartitionInfo getPartitionsByDsId(String dataSourceId, String database, String table, String system, Boolean traverse, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.reqToGetDataSourceInfo(dataSourceId, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (MetaPartitionInfo)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getPartitions", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table, traverse}, MetaPartitionInfo.class);
        }
        return new MetaPartitionInfo();
    }

    @Override
    @Deprecated
    public List<MetaColumnInfo> getColumnsByDsId(String dataSourceId, String database, String table, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.reqToGetDataSourceInfo(dataSourceId, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getColumns", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table}, List.class);
        }
        return new ArrayList<MetaColumnInfo>();
    }

    @Override
    public List<String> getDatabasesByDsName(String dataSourceName, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getDatabases", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams()}, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getDatabasesByDsNameAndEnvId(String dataSourceName, String system, String userName, String envId) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByNameAndEnvId(dataSourceName, system, userName, envId);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getDatabases", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams()}, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, String> getConnectionInfoByDsName(String dataSourceName, Map<String, String> queryParams, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (Map)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getConnectionInfo", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), queryParams}, Map.class);
        }
        return new HashMap<String, String>();
    }

    @Override
    public List<String> getTablesByDsName(String dataSourceName, String database, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getTables", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database}, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getTablesByDsNameAndEnvId(String dataSourceName, String database, String system, String userName, String envId) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByNameAndEnvId(dataSourceName, system, userName, envId);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getTables", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database}, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, String> getPartitionPropsByDsName(String dataSourceName, String database, String table, String partition, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (Map)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getPartitionProps", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table, partition}, Map.class);
        }
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getTablePropsByDsName(String dataSourceName, String database, String table, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (Map)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getTableProps", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table}, Map.class);
        }
        return new HashMap<String, String>();
    }

    @Override
    public MetaPartitionInfo getPartitionsByDsName(String dataSourceName, String database, String table, String system, Boolean traverse, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (MetaPartitionInfo)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getPartitions", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table, traverse}, MetaPartitionInfo.class);
        }
        return new MetaPartitionInfo();
    }

    @Override
    public List<MetaColumnInfo> getColumnsByDsName(String dataSourceName, String database, String table, String system, String userName) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByName(dataSourceName, system, userName);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getColumns", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table}, List.class);
        }
        return new ArrayList<MetaColumnInfo>();
    }

    @Override
    public List<MetaColumnInfo> getColumnsByDsNameAndEnvId(String dataSourceName, String database, String table, String system, String userName, String envId) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByNameAndEnvId(dataSourceName, system, userName, envId);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getColumns", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table}, List.class);
        }
        return new ArrayList<MetaColumnInfo>();
    }

    @Override
    public GenerateSqlInfo getSparkSqlByDsNameAndEnvId(String dataSourceName, String database, String table, String system, String userName, String envId) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByNameAndEnvId(dataSourceName, system, userName, envId);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            List<Object> columns = new ArrayList<MetaColumnInfo>();
            try {
                columns = (List)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getColumns", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, dsInfoResponse.getDsType().equalsIgnoreCase(DataSourceTypeEnum.ELASTICSEARCH.getValue()) ? "_doc" : table}, List.class);
            }
            catch (Exception e) {
                logger.warn("Fail to get Sql columns(\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25)");
            }
            if (((String)CacheConfiguration.MYSQL_RELATIONSHIP_LIST.getValue()).contains(dsInfoResponse.getDsType())) {
                String sqlConnectUrl = (String)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getSqlConnectUrl", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams()}, String.class);
                return this.getSparkSqlByJdbc(database, table, dsInfoResponse.getParams(), columns, sqlConnectUrl);
            }
            if (dsInfoResponse.getDsType().equalsIgnoreCase(DataSourceTypeEnum.KAFKA.getValue())) {
                return this.getSparkSqlByKafka(table, dsInfoResponse.getParams());
            }
            if (dsInfoResponse.getDsType().equalsIgnoreCase(DataSourceTypeEnum.MONGODB.getValue())) {
                return this.getSparkSqlByMongo(database, table, dsInfoResponse.getParams(), columns);
            }
            if (dsInfoResponse.getDsType().equalsIgnoreCase(DataSourceTypeEnum.ELASTICSEARCH.getValue())) {
                return this.getSparkSqlByElasticsearch(table, dsInfoResponse.getParams(), columns);
            }
        }
        return new GenerateSqlInfo();
    }

    public GenerateSqlInfo getSparkSqlByElasticsearch(String table, Map<String, Object> params, List<MetaColumnInfo> columns) {
        GenerateSqlInfo generateSqlInfo = new GenerateSqlInfo();
        String[] endPoints = new String[]{};
        Object urls = params.getOrDefault("elasticUrls", "[\"localhost:9200\"]");
        try {
            if (!(urls instanceof List)) {
                List urlList = (List)Json.fromJson((String)String.valueOf(urls), List.class, (Class[])new Class[]{String.class});
                assert (urlList != null);
                endPoints = urlList.toArray(endPoints);
            } else {
                endPoints = ((List)urls).toArray(endPoints);
            }
        }
        catch (Exception e) {
            logger.warn("Fail to get ElasticSearch urls", (Throwable)e);
        }
        HttpHost httpHost = HttpHost.create((String)endPoints[0]);
        String ddl = String.format("CREATE TEMPORARY TABLE %s USING org.elasticsearch.spark.sql  OPTIONS (  'es.nodes' '%s',  'es.port' '%s',  'es.resource' '%s/_doc')", table, httpHost.getHostName(), httpHost.getPort(), table);
        generateSqlInfo.setDdl(ddl);
        generateSqlInfo.setDml(GenerateSqlTemplate.generateDmlSql((String)table));
        String columnStr = "*";
        if (CollectionUtils.isNotEmpty(columns)) {
            columnStr = columns.stream().map(column -> column.getName()).collect(Collectors.joining(","));
        }
        generateSqlInfo.setDql(GenerateSqlTemplate.generateDqlSql((String)columnStr, (String)table));
        return generateSqlInfo;
    }

    public GenerateSqlInfo getSparkSqlByMongo(String database, String table, Map<String, Object> params, List<MetaColumnInfo> columns) {
        GenerateSqlInfo generateSqlInfo = new GenerateSqlInfo();
        String url = String.format("mongodb://%s:%s/%s", params.getOrDefault("host", ""), params.getOrDefault("port", ""), database);
        String ddl = String.format("CREATE TEMPORARY TABLE %s USING mongo OPTIONS (  'spark.mongodb.input.uri' '%s',  'spark.mongodb.input.database' '%s',  'spark.mongodb.input.collection' '%s')", table, url, database, table);
        generateSqlInfo.setDdl(ddl);
        generateSqlInfo.setDml(GenerateSqlTemplate.generateDmlSql((String)table));
        String columnStr = "*";
        if (CollectionUtils.isNotEmpty(columns)) {
            columnStr = columns.stream().filter(column -> !column.getName().equals("_id")).map(MetaColumnInfo::getName).collect(Collectors.joining(","));
        }
        generateSqlInfo.setDql(GenerateSqlTemplate.generateDqlSql((String)columnStr, (String)table));
        return generateSqlInfo;
    }

    public GenerateSqlInfo getSparkSqlByKafka(String table, Map<String, Object> params) {
        GenerateSqlInfo generateSqlInfo = new GenerateSqlInfo();
        String kafkaServers = String.valueOf(params.getOrDefault("uris", "localhost:9092"));
        String ddl = String.format("CREATE TEMPORARY TABLE %s USING kafka OPTIONS (  'kafka.bootstrap.servers' '%s',  'subscribe' '%s')", table, kafkaServers, table);
        generateSqlInfo.setDdl(ddl);
        generateSqlInfo.setDml(GenerateSqlTemplate.generateDmlSql((String)table));
        generateSqlInfo.setDql(GenerateSqlTemplate.generateDqlSql((String)"CAST(value AS STRING)", (String)table));
        return generateSqlInfo;
    }

    public GenerateSqlInfo getSparkSqlByJdbc(String database, String table, Map<String, Object> params, List<MetaColumnInfo> columns, String sqlConnectUrl) {
        GenerateSqlInfo generateSqlInfo = new GenerateSqlInfo();
        String sparkTableName = table.contains(".") ? table.substring(table.indexOf(".") + 1) : table;
        String url = String.format(sqlConnectUrl, params.getOrDefault("host", ""), params.getOrDefault("port", ""), database);
        String ddl = String.format("CREATE TEMPORARY TABLE %s USING org.apache.spark.sql.jdbc OPTIONS (  url '%s',  dbtable '%s',  user '%s',  password '%s')", sparkTableName, url, table, params.getOrDefault("username", ""), params.getOrDefault("password", ""));
        generateSqlInfo.setDdl(ddl);
        generateSqlInfo.setDml(GenerateSqlTemplate.generateDmlSql((String)table));
        String columnStr = "*";
        if (CollectionUtils.isNotEmpty(columns)) {
            columnStr = columns.stream().map(column -> column.getName()).collect(Collectors.joining(","));
        }
        generateSqlInfo.setDql(GenerateSqlTemplate.generateDqlSql((String)columnStr, (String)table));
        return generateSqlInfo;
    }

    @Override
    public GenerateSqlInfo getJdbcSqlByDsNameAndEnvId(String dataSourceName, String database, String table, String system, String userName, String envId) throws ErrorException {
        DsInfoResponse dsInfoResponse = this.queryDataSourceInfoByNameAndEnvId(dataSourceName, system, userName, envId);
        if (StringUtils.isNotBlank((CharSequence)dsInfoResponse.getDsType())) {
            return (GenerateSqlInfo)this.invokeMetaMethod(dsInfoResponse.getDsType(), "getJdbcSql", new Object[]{dsInfoResponse.getCreator(), dsInfoResponse.getParams(), database, table}, GenerateSqlInfo.class);
        }
        return new GenerateSqlInfo();
    }

    @Deprecated
    public DsInfoResponse reqToGetDataSourceInfo(String dataSourceId, String system, String userName) throws ErrorException {
        Object rpcResult = null;
        try {
            rpcResult = this.dataSourceRpcSender.ask((Object)new DsInfoQueryRequest(dataSourceId, null, system));
        }
        catch (Exception e) {
            throw new ErrorException(-1, "Remote Service Error[\u8fdc\u7aef\u670d\u52a1\u51fa\u9519, \u8054\u7cfb\u8fd0\u7ef4\u5904\u7406]");
        }
        if (rpcResult instanceof DsInfoResponse) {
            boolean hasPermission;
            DsInfoResponse response = (DsInfoResponse)rpcResult;
            if (!response.getStatus().booleanValue()) {
                throw new ErrorException(-1, "Error in Data Source Manager Server[\u6570\u636e\u6e90\u670d\u52a1\u51fa\u9519]: " + response.getErrorMsg());
            }
            boolean bl = hasPermission = AuthContext.isAdministrator((String)userName) || StringUtils.isNotBlank((CharSequence)response.getCreator()) && userName.equals(response.getCreator());
            if (!hasPermission) {
                throw new ErrorException(-1, "Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            if (response.getParams().isEmpty()) {
                throw new ErrorException(-1, "Have you published the data source? [\u6570\u636e\u6e90\u672a\u53d1\u5e03\u6216\u8005\u53c2\u6570\u4e3a\u7a7a]");
            }
            return response;
        }
        throw new ErrorException(-1, "Remote Service Error[\u8fdc\u7aef\u670d\u52a1\u51fa\u9519, \u8054\u7cfb\u8fd0\u7ef4\u5904\u7406]");
    }

    public DsInfoResponse queryDataSourceInfoByName(String dataSourceName, String system, String userName) throws ErrorException {
        return this.queryDataSourceInfoByNameAndEnvId(dataSourceName, system, userName, null);
    }

    public DsInfoResponse queryDataSourceInfoByNameAndEnvId(String dataSourceName, String system, String userName, String envId) throws ErrorException {
        Object rpcResult = null;
        boolean useDefault = false;
        try {
            rpcResult = this.reqGetDefaultDataSource(dataSourceName);
            if (Objects.isNull(rpcResult)) {
                rpcResult = this.dataSourceRpcSender.ask((Object)new DsInfoQueryRequest(null, dataSourceName, system, envId));
            } else {
                useDefault = true;
            }
        }
        catch (Exception e) {
            throw new ErrorException(-1, "Remote Service Error[\u8fdc\u7aef\u670d\u52a1\u51fa\u9519, \u8054\u7cfb\u8fd0\u7ef4\u5904\u7406]");
        }
        if (rpcResult instanceof DsInfoResponse) {
            boolean hasPermission;
            DsInfoResponse response = rpcResult;
            if (!response.getStatus().booleanValue()) {
                throw new ErrorException(-1, "Error in Data Source Manager Server[\u6570\u636e\u6e90\u670d\u52a1\u51fa\u9519]: " + response.getErrorMsg());
            }
            boolean bl = hasPermission = AuthContext.isAdministrator((String)userName) || StringUtils.isNotBlank((CharSequence)response.getCreator()) && userName.equals(response.getCreator());
            if (!hasPermission) {
                throw new ErrorException(-1, "Don't have query permission for data source [\u6ca1\u6709\u6570\u636e\u6e90\u7684\u67e5\u8be2\u6743\u9650]");
            }
            if (!useDefault && response.getParams().isEmpty()) {
                throw new ErrorException(-1, "Have you published the data source? [\u6570\u636e\u6e90\u672a\u53d1\u5e03\u6216\u8005\u53c2\u6570\u4e3a\u7a7a]");
            }
            return response;
        }
        throw new ErrorException(-1, "Remote Service Error[\u8fdc\u7aef\u670d\u52a1\u51fa\u9519, \u8054\u7cfb\u8fd0\u7ef4\u5904\u7406]");
    }

    private DsInfoResponse reqGetDefaultDataSource(String dataSourceName) {
        DataSource dataSource = DataSources.getDefault((String)dataSourceName);
        return Objects.nonNull(dataSource) ? new DsInfoResponse(Boolean.valueOf(true), dataSource.getDataSourceType().getName(), dataSource.getConnectParams(), dataSource.getCreateUser(), "") : null;
    }

    private <T> T invokeMetaMethod(String dsType, String method, Object[] methodArgs, Class<?> returnType) throws MetaMethodInvokeException {
        BiFunction<String, Object[], Object> invoker;
        try {
            invoker = this.metaClassLoaderManager.getInvoker(dsType);
        }
        catch (Exception e) {
            throw new MetaMethodInvokeException(LinkisMetadataQueryErrorCodeSummary.FAILED_METADATA_SERVICE.getErrorCode(), "Load meta service for " + dsType + " fail \u52a0\u8f7d [" + dsType + "] \u5143\u6570\u636e\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
        if (Objects.nonNull(invoker)) {
            try {
                Object returnObj = invoker.apply(method, methodArgs);
                if (Objects.nonNull(returnType)) {
                    return (T)returnObj;
                }
            }
            catch (Exception e) {
                if (e instanceof MetaRuntimeException) {
                    throw new MetaMethodInvokeException(method, methodArgs, -1, e.getMessage(), (Throwable)e);
                }
                throw new MetaMethodInvokeException(method, methodArgs, LinkisMetadataQueryErrorCodeSummary.INVOKE_METHOD_FAIL.getErrorCode(), MessageFormat.format(LinkisMetadataQueryErrorCodeSummary.INVOKE_METHOD_FAIL.getErrorDesc(), method, e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }
}

