/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.server.loader;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.cache.CacheConfiguration;
import org.apache.linkis.metadata.query.common.errorcode.LinkisMetadataQueryErrorCodeSummary;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.AbstractCacheMetaService;
import org.apache.linkis.metadata.query.common.service.BaseMetadataService;
import org.apache.linkis.metadata.query.server.utils.MetadataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClassLoaderManager {
    private final Map<String, ClassLoader> classLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private final Map<String, MetaServiceInstance> metaServiceInstances = new ConcurrentHashMap<String, MetaServiceInstance>();
    private static Map<String, String> databaseRelationship = MetaClassLoaderManager.getDatabaseRelationship();
    public static CommonVars<String> LIB_DIR = CommonVars.apply((String)"wds.linkis.server.mdm.service.lib.dir", (Object)(Configuration.getLinkisHome() + "/lib/linkis-public-enhancements/linkis-ps-publicservice/metadataquery-service"));
    public static CommonVars<Integer> INSTANCE_EXPIRE_TIME = CommonVars.apply((String)"wds.linkis.server.mdm.service.instance.expire-in-seconds", (Object)60);
    private static final String META_CLASS_NAME = "org.apache.linkis.metadata.query.service.%sMetaService";
    private static final String MYSQL_BASE_DIR = "jdbc";
    private static final Logger LOG = LoggerFactory.getLogger(MetaClassLoaderManager.class);

    private static Map<String, String> getDatabaseRelationship() {
        try {
            return (Map)Json.fromJson((String)((String)CacheConfiguration.QUERY_DATABASE_RELATIONSHIP.getValue()), HashMap.class, (Class[])new Class[0]);
        }
        catch (JsonErrorException e) {
            LOG.warn("databaseRelationship parse exception,please check [linkis.server.mdq.query.database.relationship] parameter");
            return new HashMap<String, String>();
        }
    }

    public BiFunction<String, Object[], Object> getInvoker(String dsType) throws ErrorException {
        boolean needToLoad = true;
        MetaServiceInstance serviceInstance = this.metaServiceInstances.get(dsType);
        if (Objects.nonNull(serviceInstance)) {
            Integer expireTimeInSec = (Integer)INSTANCE_EXPIRE_TIME.getValue();
            boolean bl = needToLoad = Objects.nonNull(expireTimeInSec) && expireTimeInSec > 0 && serviceInstance.initTimeStamp + TimeUnit.MILLISECONDS.convert(expireTimeInSec.intValue(), TimeUnit.SECONDS) < System.currentTimeMillis();
        }
        if (needToLoad) {
            MetaServiceInstance finalServiceInstance1 = serviceInstance;
            boolean isContains = ((String)CacheConfiguration.MYSQL_RELATIONSHIP_LIST.getValue()).contains(dsType);
            String finalBaseType = isContains ? MYSQL_BASE_DIR : dsType;
            serviceInstance = this.metaServiceInstances.compute(dsType, (key, instance) -> {
                Class<? extends BaseMetadataService> metaServiceClass;
                if (null != instance && !Objects.equals(finalServiceInstance1, instance)) {
                    return instance;
                }
                String lib = (String)LIB_DIR.getValue();
                String stdLib = lib.endsWith("/") ? lib.replaceAll(".$", "") : lib;
                String componentLib = stdLib + "/" + finalBaseType;
                LOG.info("Start to load/reload meta instance of data source type: [" + dsType + "] from library dir:" + componentLib);
                ClassLoader parentClassLoader = MetaClassLoaderManager.class.getClassLoader();
                ClassLoader metaClassLoader = this.classLoaders.computeIfAbsent(dsType, type -> {
                    try {
                        return new URLClassLoader(this.getJarsUrlsOfPath(componentLib).toArray(new URL[0]), parentClassLoader);
                    }
                    catch (Exception e) {
                        LOG.error("Cannot init the classloader of type: [" + dsType + "] in library path: [" + componentLib + "]", (Throwable)e);
                        return null;
                    }
                });
                if (Objects.isNull(metaClassLoader)) {
                    throw new MetaRuntimeException(MessageFormat.format(LinkisMetadataQueryErrorCodeSummary.ERROR_IN_CREATING.getErrorDesc(), dsType), null);
                }
                String expectClassName = null;
                if (dsType.length() > 0) {
                    String converDsType = dsType;
                    try {
                        String value;
                        if (MapUtils.isNotEmpty(databaseRelationship) && databaseRelationship.containsKey(dsType) && StringUtils.isNotBlank((CharSequence)(value = MapUtils.getString(databaseRelationship, (Object)dsType))) && ((String)CacheConfiguration.MYSQL_RELATIONSHIP_LIST.getValue()).contains(value)) {
                            converDsType = value;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("dsType conver failed: {}", (Object)dsType);
                    }
                    String prefix = converDsType.substring(0, 1).toUpperCase() + converDsType.substring(1);
                    expectClassName = String.format(META_CLASS_NAME, prefix);
                }
                if (Objects.isNull(metaServiceClass = this.searchForLoadMetaServiceClass(metaClassLoader, expectClassName, true))) {
                    throw new MetaRuntimeException(MessageFormat.format(LinkisMetadataQueryErrorCodeSummary.INIT_META_SERVICE.getErrorDesc(), dsType), null);
                }
                BaseMetadataService metadataService = MetadataUtils.loadMetaService(metaServiceClass, metaClassLoader);
                if (metadataService instanceof AbstractCacheMetaService) {
                    LOG.info("Invoke the init() method in meta service for type: [" + dsType + "]");
                    ((AbstractCacheMetaService)metadataService).init();
                }
                return new MetaServiceInstance(metadataService, metaClassLoader);
            });
        }
        Method[] childMethods = serviceInstance.methods;
        MetaServiceInstance finalServiceInstance = serviceInstance;
        return (m, args) -> {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(finalServiceInstance.metaClassLoader);
                List methodsMatched = Arrays.stream(childMethods).filter(eachMethod -> {
                    Class<?>[] parameterType;
                    if (eachMethod.getName().equals(m) && (parameterType = eachMethod.getParameterTypes()).length == ((Object[])args).length) {
                        for (int i = 0; i < parameterType.length; ++i) {
                            boolean matches;
                            if (!Objects.nonNull(args[i])) continue;
                            boolean bl = matches = parameterType[i].isAssignableFrom(args[i].getClass()) || (args[i].getClass().isPrimitive() || parameterType[i].isPrimitive()) && MetadataUtils.getPrimitive(args[i].getClass()) == MetadataUtils.getPrimitive(parameterType[i]);
                            if (matches) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                if (methodsMatched.isEmpty()) {
                    String type = null;
                    if (Objects.nonNull(args)) {
                        type = Arrays.stream(args).map(arg -> Objects.nonNull(arg) ? arg.getClass().toString() : "null").collect(Collectors.joining(","));
                    }
                    String message = "Unknown method: [ name: " + m + ", type: [" + type + "]] for meta service instance: [" + finalServiceInstance.getServiceInstance().toString() + "]";
                    LOG.warn(message);
                    throw new MetaRuntimeException(message, null);
                }
                if (methodsMatched.size() > 1) {
                    LOG.warn("Find multiple matched methods with name: [" + m + "] such as: \n" + methodsMatched.stream().map(method -> method.getName() + ":" + Arrays.toString(method.getParameterTypes())).collect(Collectors.joining("\n")) + "\n in meta service instance: [" + finalServiceInstance.getServiceInstance().toString() + "], will choose the first one");
                }
                Object type = ((Method)methodsMatched.get(0)).invoke((Object)finalServiceInstance.serviceInstance, args);
                return type;
            }
            catch (Exception e) {
                Throwable t = e;
                while (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                String message = "Fail to invoke method: [" + m + "] in meta service instance: [" + finalServiceInstance.serviceInstance.toString() + "]";
                LOG.warn(message, t);
                throw new MetaRuntimeException(message, t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends BaseMetadataService> searchForLoadMetaServiceClass(ClassLoader classLoader, String expectClassName, boolean initialize) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            String[] metaServiceClassNames;
            Class<? extends BaseMetadataService> metaClass = null;
            if (StringUtils.isNotBlank((CharSequence)expectClassName)) {
                metaClass = MetadataUtils.loadMetaServiceClass(classLoader, expectClassName, initialize, "Cannot find class in using expect class name: [" + expectClassName + "]");
            }
            if (Objects.isNull(metaClass) && classLoader instanceof URLClassLoader && (metaServiceClassNames = MetadataUtils.searchMetaServiceClassInLoader((URLClassLoader)classLoader)).length > 0) {
                String metaServiceClassName = metaServiceClassNames[0];
                metaClass = MetadataUtils.loadMetaServiceClass(classLoader, metaServiceClassName, initialize, "Cannot load class in canonical name: [" + metaServiceClassName + "], please check the compiled jar/file");
            }
            Class<? extends BaseMetadataService> clazz = metaClass;
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private List<URL> getJarsUrlsOfPath(String path) throws MalformedURLException {
        File file = new File(path);
        ArrayList<URL> jars = new ArrayList<URL>();
        if (file.listFiles() != null) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                if (!f.isDirectory() && f.getName().endsWith(".jar")) {
                    jars.add(f.toURI().toURL());
                    continue;
                }
                if (!f.isDirectory()) continue;
                jars.addAll(this.getJarsUrlsOfPath(f.getPath()));
            }
        }
        return jars;
    }

    public static class MetaServiceInstance {
        private BaseMetadataService serviceInstance;
        private Method[] methods;
        private ClassLoader metaClassLoader;
        private long initTimeStamp = 0L;

        public MetaServiceInstance(BaseMetadataService serviceInstance, ClassLoader metaClassLoader) {
            this.serviceInstance = serviceInstance;
            this.metaClassLoader = metaClassLoader;
            this.methods = serviceInstance.getClass().getMethods();
            this.initTimeStamp = System.currentTimeMillis();
        }

        public BaseMetadataService getServiceInstance() {
            return this.serviceInstance;
        }
    }
}

