/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.receivers;

import java.text.MessageFormat;
import java.util.Objects;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.protocol.DsInfoQueryRequest;
import org.apache.linkis.datasourcemanager.common.protocol.DsInfoResponse;
import org.apache.linkis.datasourcemanager.core.restful.RestfulApiHelper;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DsmReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(DsmReceiver.class);
    @Autowired
    private DataSourceInfoService dataSourceInfoService;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;

    @Receiver
    public DsInfoResponse dealDsInfoQueryRequest(DsInfoQueryRequest dsInfoQueryRequest) {
        if (dsInfoQueryRequest.isValid()) {
            try {
                DataSource dataSource = null;
                if (!Objects.isNull(dsInfoQueryRequest.getName()) && !Objects.isNull(dsInfoQueryRequest.getEnvId())) {
                    LOG.info("Try to get dataSource by dataSourceName: {}, envId: {}", (Object)dsInfoQueryRequest.getName(), (Object)dsInfoQueryRequest.getEnvId());
                    dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dsInfoQueryRequest.getName(), dsInfoQueryRequest.getEnvId());
                } else if (!Objects.isNull(dsInfoQueryRequest.getName())) {
                    LOG.info("Try to get dataSource by dataSourceName: {}", (Object)dsInfoQueryRequest.getName());
                    dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(dsInfoQueryRequest.getName());
                } else if (Long.valueOf(dsInfoQueryRequest.getId()) > 0L) {
                    LOG.info("Try to get dataSource by dataSourceId: {}", (Object)dsInfoQueryRequest.getId());
                    dataSource = this.dataSourceInfoService.getDataSourceInfoForConnect(Long.valueOf(dsInfoQueryRequest.getId()));
                }
                if (null != dataSource) {
                    Long publishedVersionId = dataSource.getPublishedVersionId();
                    if (Objects.isNull(publishedVersionId)) {
                        LOG.warn("Datasource name:{} is not published.", (Object)dataSource.getDataSourceName());
                        return new DsInfoResponse(Boolean.valueOf(false), MessageFormat.format("Datasource name:{0} is not published.", dataSource.getDataSourceName()));
                    }
                    RestfulApiHelper.decryptPasswordKey(this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId()), dataSource.getConnectParams());
                    return new DsInfoResponse(Boolean.valueOf(true), dataSource.getDataSourceType().getName(), dataSource.getConnectParams(), dataSource.getCreateUser(), "");
                }
                LOG.warn("Can not get any dataSource");
                return new DsInfoResponse(Boolean.valueOf(true), "Can not get any dataSource");
            }
            catch (Exception e) {
                LOG.error("Fail to get data source information, id: {} system: {}", new Object[]{dsInfoQueryRequest.getId(), dsInfoQueryRequest.getSystem(), e});
                return new DsInfoResponse(Boolean.valueOf(false), String.format("Fail to get data source information, id: %s system: %s", dsInfoQueryRequest.getId(), dsInfoQueryRequest.getSystem()));
            }
            catch (Throwable t) {
                LOG.error("Fail to get data source information, id: {} system: {}", new Object[]{dsInfoQueryRequest.getId(), dsInfoQueryRequest.getSystem(), t});
                return new DsInfoResponse(Boolean.valueOf(false), String.format("Fail to get data source information, id: %s system: %s", dsInfoQueryRequest.getId(), dsInfoQueryRequest.getSystem()));
            }
        }
        return new DsInfoResponse(Boolean.valueOf(true));
    }
}

