/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.udf.service.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.linkis.udf.dao.UDFTreeDao;
import org.apache.linkis.udf.entity.UDFTree;
import org.apache.linkis.udf.excepiton.UDFException;
import org.apache.linkis.udf.service.UDFService;
import org.apache.linkis.udf.service.UDFTreeService;
import org.apache.linkis.udf.utils.ConstantVar;
import org.apache.linkis.udf.vo.UDFInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class UDFTreeServiceImpl
implements UDFTreeService {
    private static final Logger logger = LoggerFactory.getLogger(UDFTreeServiceImpl.class);
    @Autowired
    private UDFTreeDao udfTreeDao;
    @Autowired
    private UDFService udfService;
    Map<String, List<UDFTree>> firstFloor = new HashMap<String, List<UDFTree>>();
    Map<String, String> firstFloorName = new HashedMap();

    public UDFTreeServiceImpl() {
        this.firstFloorName.put("sys", "\u7cfb\u7edf\u51fd\u6570");
        this.firstFloorName.put("bdp", "BDAP\u51fd\u6570");
        this.firstFloorName.put("share", "\u5171\u4eab\u51fd\u6570");
        this.firstFloorName.put("expire", "\u8fc7\u671f\u51fd\u6570");
    }

    @Override
    public UDFTree initTree(String userName, String category) throws UDFException {
        ArrayList<UDFTree> childrens = new ArrayList<UDFTree>();
        if (this.firstFloor.get(category) == null || this.firstFloor.get(category).size() != 4) {
            ArrayList<UDFTree> root = new ArrayList<UDFTree>();
            root.add(0, this.getFirstFloor("sys", category));
            root.add(1, this.getFirstFloor("bdp", category));
            root.add(2, this.getFirstFloor("share", category));
            root.add(3, this.getFirstFloor("expire", category));
            this.firstFloor.put(category, root);
        }
        for (int i = 0; i < 4; ++i) {
            childrens.add(this.firstFloor.get(category).get(i));
        }
        childrens.add(this.getFirstFloor(userName, category));
        UDFTree udfTree = new UDFTree();
        udfTree.setChildrens(childrens);
        return udfTree;
    }

    public UDFTree getFirstFloor(String userName, String category) throws UDFException {
        logger.info(userName + " to get first Floor directory");
        HashedMap params = new HashedMap();
        params.put("parent", -1L);
        params.put("userName", userName);
        params.put("category", category);
        List<UDFTree> first = this.udfTreeDao.getTreesByParentId((Map<String, Object>)params);
        if (first == null || first.size() == 0) {
            String treeName = this.firstFloorName.getOrDefault(userName, "\u4e2a\u4eba\u51fd\u6570");
            UDFTree udfTree = new UDFTree(null, Long.valueOf(-1L), treeName, userName, "", new Date(), new Date(), category);
            this.udfTreeDao.addTree(udfTree);
            return udfTree;
        }
        if (first.size() > 1) {
            throw new UDFException("user(\u7528\u6237):" + userName + ",There are two root directory directories(\u5b58\u5728\u4e24\u4e2a\u6839\u76ee\u5f55\u76ee\u5f55)");
        }
        return first.get(0);
    }

    @Override
    public UDFTree addTree(UDFTree udfTree, String userName) throws UDFException {
        if (userName.equals(udfTree.getUserName())) {
            try {
                UDFTree parentTree = this.udfTreeDao.getTreeById(udfTree.getParent());
                if (parentTree != null && !parentTree.getUserName().equals(userName)) {
                    throw new UDFException("user(\u7528\u6237) " + userName + ", the parent directory is not yours(\u7236\u76ee\u5f55\u4e0d\u662f\u4f60\u7684)");
                }
                logger.info(userName + " to add directory");
                this.udfTreeDao.addTree(udfTree);
            }
            catch (Throwable e) {
                if (e instanceof DuplicateKeyException) {
                    throw new UDFException("Duplicate file name(\u6587\u4ef6\u540d\u91cd\u590d)");
                }
                throw new UDFException(e.getMessage());
            }
        } else {
            throw new UDFException("Current user must be consistent with the user created(\u5f53\u524d\u7528\u6237\u5fc5\u987b\u548c\u521b\u5efa\u7528\u6237\u4e00\u81f4)");
        }
        return udfTree;
    }

    @Override
    public UDFTree updateTree(UDFTree udfTree, String userName) throws UDFException {
        if (userName.equals(udfTree.getUserName())) {
            if (udfTree.getId() == null) {
                throw new UDFException("id Can not be empty(\u4e0d\u80fd\u4e3a\u7a7a)");
            }
            try {
                logger.info(userName + " to update directory");
                this.udfTreeDao.updateTree(udfTree);
            }
            catch (Throwable e) {
                if (e instanceof DuplicateKeyException) {
                    throw new UDFException("Duplicate file name(\u6587\u4ef6\u540d\u91cd\u590d)");
                }
                throw new UDFException(e.getMessage());
            }
        } else {
            throw new UDFException("Current user must be consistent with the modified user(\u5f53\u524d\u7528\u6237\u5fc5\u987b\u548c\u4fee\u6539\u7528\u6237\u4e00\u81f4)");
        }
        return udfTree;
    }

    @Override
    public Boolean deleteTree(Long id, String userName) throws UDFException {
        this.udfTreeDao.deleteTree(id, userName);
        return true;
    }

    @Override
    public UDFTree getTreeById(Long id, String userName, String type, String category) throws UDFException {
        UDFTree udfTree = null;
        if (id == null || id < 0L) {
            udfTree = this.initTree(userName, category);
        } else {
            udfTree = Arrays.asList(ConstantVar.specialTypes).contains(type) ? this.udfTreeDao.getTreeByIdAndCategory(id, category) : this.udfTreeDao.getTreeByIdAndCategoryAndUserName(id, category, userName);
            if (udfTree == null) {
                return udfTree;
            }
            HashedMap params = new HashedMap();
            params.put("parent", udfTree.getId());
            params.put("category", category);
            List<UDFTree> childrens = this.udfTreeDao.getTreesByParentId((Map<String, Object>)params);
            List<UDFInfoVo> udfInfos = null;
            switch (type) {
                case "sys": {
                    udfInfos = this.udfService.getUDFSByTreeIdAndUser(udfTree.getId(), type, category);
                    break;
                }
                case "bdp": {
                    udfInfos = this.udfService.getUDFInfoByTreeId(udfTree.getId(), userName, category);
                    break;
                }
                case "share": {
                    udfInfos = this.udfService.getSharedUDFs(userName, category);
                    break;
                }
                case "expire": {
                    udfInfos = this.udfService.getExpiredUDFs(userName, category);
                    break;
                }
                default: {
                    udfInfos = this.udfService.getUDFInfoByTreeId(udfTree.getId(), userName, category);
                }
            }
            udfTree.setChildrens(childrens);
            udfTree.setUdfInfos(udfInfos);
        }
        return udfTree;
    }

    @Override
    @Deprecated
    public UDFTree getSharedTree(String category) throws UDFException {
        HashedMap params = new HashedMap();
        params.put("parent", -1L);
        params.put("userName", "share");
        params.put("category", category);
        return (UDFTree)Iterables.getFirst(this.udfTreeDao.getTreesByParentId((Map<String, Object>)params), null);
    }
}

