/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.udf.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlCopyResourceResponse;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.BmlRollbackVersionResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.publicservice.common.lock.entity.CommonLock;
import org.apache.linkis.publicservice.common.lock.service.CommonLockService;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.udf.dao.UDFDao;
import org.apache.linkis.udf.dao.UDFTreeDao;
import org.apache.linkis.udf.dao.UDFVersionDao;
import org.apache.linkis.udf.entity.UDFInfo;
import org.apache.linkis.udf.entity.UDFManager;
import org.apache.linkis.udf.entity.UDFTree;
import org.apache.linkis.udf.entity.UDFVersion;
import org.apache.linkis.udf.excepiton.UDFException;
import org.apache.linkis.udf.service.UDFService;
import org.apache.linkis.udf.vo.DownloadVo;
import org.apache.linkis.udf.vo.UDFAddVo;
import org.apache.linkis.udf.vo.UDFInfoVo;
import org.apache.linkis.udf.vo.UDFUpdateVo;
import org.apache.linkis.udf.vo.UDFVersionVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service
public class UDFServiceImpl
implements UDFService {
    private static final Logger logger = LoggerFactory.getLogger(UDFServiceImpl.class);
    private static final String _LOCK = "_UDF";
    private static final long LOCK_TIMEOUT = 5000L;
    private static final String USER_REGEX = "^[0-9a-zA-Z_]{1,}$";
    Pattern pattern = Pattern.compile("^[0-9a-zA-Z_]{1,}$");
    Map<String, Collection<Integer>> categoryToCodes = new HashedMap();
    @Autowired
    private UDFDao udfDao;
    @Autowired
    private UDFTreeDao udfTreeDao;
    @Autowired
    private UDFVersionDao udfVersionDao;
    @Autowired
    private CommonLockService commonLockService;
    private final BmlClient bmlClient;

    public UDFServiceImpl() {
        this.categoryToCodes.put("function", Lists.newArrayList((Object[])new Integer[]{3, 4}));
        this.categoryToCodes.put("udf", Lists.newArrayList((Object[])new Integer[]{0, 1, 2}));
        this.categoryToCodes.put("all", Lists.newArrayList((Object[])new Integer[]{3, 4, 0, 1, 2}));
        this.bmlClient = BmlClientFactory.createBmlClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public long addUDF(UDFAddVo udfVo, String userName) throws Exception {
        logger.info(userName + " add udfVo: " + udfVo.getUdfName());
        CommonLock commonLock = new CommonLock();
        commonLock.setLockObject(userName + _LOCK);
        commonLock.setCreator(userName);
        commonLock.setLocker(Utils.getLocalHostname());
        commonLock.setCreateTime(new Date());
        commonLock.setUpdateTime(new Date());
        try {
            BmlUploadResponse response;
            this.commonLockService.lock(commonLock, Long.valueOf(5000L));
            if (this.validateDuplicateUDFName(udfVo.getUdfName(), userName)) {
                throw new UDFException("The name of udf is the same name. Please rename it and rebuild it.(udf\u7684\u540d\u5b57\u91cd\u540d\uff0c\u8bf7\u6539\u540d\u540e\u91cd\u5efa)");
            }
            if (StringUtils.isEmpty((CharSequence)udfVo.getDirectory())) {
                throw new UDFException("\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String path = udfVo.getPath();
            if (StringUtils.isBlank((CharSequence)path) || path.contains("../")) {
                throw new UDFException("The path: " + path + " of udf is error. Please rename it and rebuild it.(udf\u7684\u8def\u5f84\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u5efa)");
            }
            FsPath fsPath = new FsPath(path);
            FileSystem fileSystem = (FileSystem)FSFactory.getFsByProxyUser((FsPath)fsPath, (String)userName);
            if (udfVo.getUdfType() == 0 && StringUtils.isNotBlank((CharSequence)udfVo.getPath())) {
                this.validateJarFileName(udfVo.getPath().substring(udfVo.getPath().lastIndexOf("/") + 1), userName);
            }
            InputStream is = null;
            InputStream is2 = null;
            String md5 = "";
            try {
                fileSystem.init(null);
                is = fileSystem.read(fsPath);
                md5 = DigestUtils.md5DigestAsHex((InputStream)is);
                logger.info("fsPath.path:" + fsPath.getPath());
                is2 = fileSystem.read(fsPath);
                response = this.uploadToBml(userName, fsPath.getPath(), is2);
                logger.info("bml resourceId:" + response.resourceId());
            }
            catch (IOException e) {
                try {
                    throw new UDFException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff1a" + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is2);
                    IOUtils.closeQuietly(is);
                    if (fileSystem != null) {
                        fileSystem.close();
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is2);
            IOUtils.closeQuietly((InputStream)is);
            if (fileSystem != null) {
                fileSystem.close();
            }
            if (!response.isSuccess()) {
                throw new UDFException("\u4e0a\u4f20\u5230bml\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + udfVo.getPath());
            }
            String category = udfVo.getUdfType() == 3 || udfVo.getUdfType() == 4 ? "function" : "udf";
            UDFTree parentTree = this.getOrCreateTree(userName, category, udfVo.getDirectory());
            UDFInfo udfInfo = new UDFInfo();
            DateConverter converter = new DateConverter((Object)new Date());
            BeanUtilsBean.getInstance().getConvertUtils().register((Converter)converter, Date.class);
            BeanUtils.copyProperties((Object)udfInfo, (Object)udfVo);
            udfInfo.setId(null);
            udfInfo.setTreeId(parentTree.getId());
            udfInfo.setCreateTime(new Date());
            udfInfo.setUpdateTime(new Date());
            this.udfDao.addUDF(udfInfo);
            UDFVersion udfVersion = new UDFVersion();
            BeanUtils.copyProperties((Object)udfVersion, (Object)udfVo);
            udfVersion.setUdfId(udfInfo.getId());
            udfVersion.setId(null);
            udfVersion.setPublished(Boolean.valueOf(false));
            udfVersion.setCreateTime(new Date());
            udfVersion.setBmlResourceId(response.resourceId());
            udfVersion.setBmlResourceVersion(response.version());
            udfVersion.setMd5(md5);
            this.udfVersionDao.addUdfVersion(udfVersion);
            if (udfVo.getLoad() != null && udfVo.getLoad().booleanValue()) {
                this.addLoadInfo(udfInfo.getId(), userName);
            }
            logger.info("end for " + userName + " add udfVo: " + udfVo.getUdfName());
            long l = udfInfo.getId();
            return l;
        }
        finally {
            this.commonLockService.unlock(commonLock);
        }
    }

    private boolean validateDuplicateUDFName(String udfName, String userName) throws UDFException {
        long count = this.udfDao.getSameNameCountByUser(udfName, userName);
        long sharedCount = this.udfDao.getShareSameNameCountByUser(udfName, userName);
        return count > 0L || sharedCount > 0L;
    }

    private BmlUploadResponse uploadToBml(String userName, String filePath, InputStream inputStream) {
        BmlUploadResponse response = this.bmlClient.uploadResource(userName == null ? Utils.getJvmUser() : userName, filePath, inputStream);
        return response;
    }

    private BmlUpdateResponse uploadToBml(String userName, String filePath, InputStream inputStream, String resourceId) {
        BmlUpdateResponse response = this.bmlClient.updateResource(userName == null ? Utils.getJvmUser() : userName, resourceId, filePath, inputStream);
        return response;
    }

    private BmlDownloadResponse downloadBml(String userName, String resourceId, String version) {
        return this.bmlClient.downloadResource(userName == null ? Utils.getJvmUser() : userName, resourceId, version);
    }

    private void validateJarFileName(String jarPath, String userName) throws UDFException {
        int cnt = this.udfVersionDao.getSameJarCount(userName, jarPath);
        if (cnt > 0) {
            throw new UDFException("\u7528\u6237\u7684udf\u5df2\u5b58\u5728\u540c\u540djar\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public void updateUDF(UDFUpdateVo udfUpdateVo, String userName) throws Exception {
        int cnt;
        logger.info(userName + "start to update udfInfo, udfName:" + udfUpdateVo.getUdfName());
        if (udfUpdateVo.getId() == null) {
            throw new UDFException("id Can not be empty(\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        UDFInfo oldUdfInfo = this.udfDao.getUDFById(udfUpdateVo.getId());
        if (oldUdfInfo == null) {
            throw new UDFException("No old UDF found by this ID.");
        }
        if (!userName.equals(oldUdfInfo.getCreateUser())) {
            throw new UDFException("Current user must be consistent with the modified user(\u5f53\u524d\u7528\u6237\u5fc5\u987b\u548c\u4fee\u6539\u7528\u6237\u4e00\u81f4)");
        }
        if (!oldUdfInfo.getUdfType().equals(udfUpdateVo.getUdfType())) {
            throw new UDFException("UDF type modification is not allowed.");
        }
        if (!udfUpdateVo.getUdfName().equals(oldUdfInfo.getUdfName())) {
            throw new UDFException("The name of udf is not allowed modified.(udf\u7684\u540d\u5b57\u7981\u6b62\u4fee\u6539\uff01)");
        }
        if (udfUpdateVo.getUdfType() == 0 && StringUtils.isNotBlank((CharSequence)udfUpdateVo.getPath()) && (cnt = this.udfVersionDao.getOtherSameJarCount(userName, udfUpdateVo.getPath().substring(udfUpdateVo.getPath().lastIndexOf("/") + 1), udfUpdateVo.getId())) > 0) {
            throw new UDFException("\u7528\u6237\u7684udf\u5df2\u5b58\u5728\u540c\u540djar");
        }
        oldUdfInfo.setUpdateTime(new Date());
        CommonLock persistenceLock = new CommonLock();
        persistenceLock.setLockObject(userName + _LOCK);
        persistenceLock.setCreator(userName);
        persistenceLock.setLocker(Utils.getLocalHostname());
        persistenceLock.setCreateTime(new Date());
        persistenceLock.setUpdateTime(new Date());
        try {
            BmlUpdateResponse response;
            String newMd5;
            InputStream is2;
            InputStream is;
            FileSystem fileSystem;
            FsPath fsPath;
            UDFVersion latestVersion;
            block19: {
                this.commonLockService.lock(persistenceLock, Long.valueOf(5000L));
                latestVersion = this.udfVersionDao.selectLatestByUdfId(udfUpdateVo.getId());
                if (null == latestVersion) {
                    throw new UDFException("can't found latestVersion for the udf");
                }
                fsPath = new FsPath(udfUpdateVo.getPath());
                fileSystem = (FileSystem)FSFactory.getFsByProxyUser((FsPath)fsPath, (String)userName);
                is = null;
                is2 = null;
                newMd5 = "";
                fileSystem.init(null);
                is = fileSystem.read(fsPath);
                newMd5 = DigestUtils.md5DigestAsHex((InputStream)is);
                if (!newMd5.equals(latestVersion.getMd5())) break block19;
                latestVersion.setPath(udfUpdateVo.getPath());
                latestVersion.setRegisterFormat(udfUpdateVo.getRegisterFormat());
                latestVersion.setUseFormat(udfUpdateVo.getUseFormat());
                latestVersion.setDescription(udfUpdateVo.getDescription());
                this.udfVersionDao.updateUDFVersion(latestVersion);
                this.udfDao.updateUDF(oldUdfInfo);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((InputStream)is2);
                if (fileSystem == null) return;
                fileSystem.close();
                return;
            }
            try {
                is2 = fileSystem.read(fsPath);
                response = this.uploadToBml(userName, fsPath.getPath(), is2, latestVersion.getBmlResourceId());
            }
            catch (IOException e) {
                try {
                    throw new UDFException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff1a" + e.getMessage());
                    catch (Exception e2) {
                        throw new UDFException("\u4e0a\u4f20\u5230bml\u5f02\u5e38\uff01msg:" + e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(is2);
                    if (fileSystem == null) throw throwable;
                    fileSystem.close();
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)is2);
            if (fileSystem != null) {
                fileSystem.close();
            }
            if (!response.isSuccess()) {
                throw new UDFException("\u4e0a\u4f20\u5230bml\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + udfUpdateVo.getPath());
            }
            UDFVersion newVersion = new UDFVersion();
            newVersion.setUdfId(udfUpdateVo.getId());
            newVersion.setPath(udfUpdateVo.getPath());
            newVersion.setUseFormat(udfUpdateVo.getUseFormat());
            newVersion.setRegisterFormat(udfUpdateVo.getRegisterFormat());
            newVersion.setDescription(udfUpdateVo.getDescription());
            newVersion.setCreateTime(new Date());
            newVersion.setBmlResourceId(response.resourceId());
            newVersion.setBmlResourceVersion(response.version());
            newVersion.setMd5(newMd5);
            this.udfVersionDao.addUdfVersion(newVersion);
            this.udfDao.updateUDF(oldUdfInfo);
            logger.info("end for udf update, udfName:" + udfUpdateVo.getUdfName());
            return;
        }
        finally {
            this.commonLockService.unlock(persistenceLock);
        }
    }

    @Override
    @Deprecated
    public UDFInfo createSharedUdfInfo(UDFInfo udfInfo, Long shareParentId, FsPath sharedPath) throws Exception {
        UDFInfo sharedUDFInfo = new UDFInfo();
        DateConverter converter = new DateConverter((Object)new Date());
        BeanUtilsBean.getInstance().getConvertUtils().register((Converter)converter, Date.class);
        BeanUtils.copyProperties((Object)sharedUDFInfo, (Object)udfInfo);
        sharedUDFInfo.setId(null);
        sharedUDFInfo.setCreateTime(new Date());
        sharedUDFInfo.setUpdateTime(new Date());
        sharedUDFInfo.setTreeId(shareParentId);
        sharedUDFInfo.setShared(Boolean.valueOf(true));
        sharedUDFInfo.setExpire(Boolean.valueOf(false));
        return sharedUDFInfo;
    }

    private UDFTree getOrCreateTree(final String userName, final String category, String treeName) throws UDFException {
        final List<UDFTree> selfTree = this.udfTreeDao.getTreesByParentId((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("parent", -1);
                this.put("userName", userName);
                this.put("category", category);
            }
        });
        if (selfTree == null || selfTree.size() == 0) {
            throw new UDFException("\u8be5\u7528\u6237\u6ca1\u6709\u4e2a\u4eba\u51fd\u6570\u76ee\u5f55!");
        }
        List<UDFTree> selfTreeChildren = this.udfTreeDao.getTreesByParentId((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("parent", ((UDFTree)selfTree.get(0)).getId());
                this.put("userName", userName);
                this.put("category", category);
            }
        });
        for (UDFTree tree : selfTreeChildren) {
            if (!tree.getName().equals(treeName)) continue;
            return tree;
        }
        UDFTree treeToAdd = new UDFTree(null, selfTree.get(0).getId(), treeName, userName, "", new Date(), new Date(), category);
        this.udfTreeDao.addTree(treeToAdd);
        return treeToAdd;
    }

    @Override
    @Transactional
    public void handoverUdf(Long udfId, String handoverUser) throws UDFException {
        logger.info("begin to handover udf, udfId: " + udfId);
        UDFInfo udfInfo = this.udfDao.getUDFById(udfId);
        UDFVersion latestVersion = this.udfVersionDao.selectLatestByUdfId(udfId);
        long count = this.udfDao.getSameNameCountByUser(udfInfo.getUdfName(), handoverUser);
        long sharedCount = this.udfDao.getShareSameNameCountExcludeUser(udfInfo.getUdfName(), handoverUser, udfInfo.getCreateUser());
        if (count > 0L || sharedCount > 0L) {
            throw new UDFException("The handoverUser has same name udf.(\u88ab\u79fb\u4ea4\u7528\u6237\u5305\u542b\u91cd\u540dudf)");
        }
        if (udfInfo.getUdfType() == 0 && StringUtils.isNotBlank((CharSequence)latestVersion.getPath())) {
            this.validateJarFileName(latestVersion.getPath().substring(latestVersion.getPath().lastIndexOf("/") + 1), handoverUser);
        }
        String oldUser = udfInfo.getCreateUser();
        udfInfo.setCreateUser(handoverUser);
        String category = udfInfo.getUdfType() == 3 || udfInfo.getUdfType() == 4 ? "function" : "udf";
        UDFTree originTree = this.udfTreeDao.getTreeById(udfInfo.getTreeId());
        UDFTree tree = this.getOrCreateTree(handoverUser, category, originTree.getName());
        udfInfo.setTreeId(tree.getId());
        this.udfDao.updateUDF(udfInfo);
        this.udfDao.deleteSharedUser(handoverUser, udfId);
        this.udfDao.deleteLoadInfo(udfId, oldUser);
        BmlCopyResourceResponse response = this.bmlClient.copyResourceToAnotherUser(latestVersion.getBmlResourceId(), handoverUser, oldUser);
        if (!response.isSuccess()) {
            throw new UDFException("failed to copy resource to anotherUser:" + handoverUser);
        }
        this.udfVersionDao.updateResourceIdByUdfId(udfId, response.resourceId(), oldUser, handoverUser);
        logger.info("end to handover udf, udfId: " + udfId);
    }

    @Override
    public void publishUdf(Long udfId, String version) throws UDFException {
        logger.info("begin to publish udf, udfId: " + udfId);
        UDFInfo udfInfo = this.udfDao.getUDFById(udfId);
        if (!Boolean.TRUE.equals(udfInfo.getShared())) {
            throw new UDFException("\u975e\u5171\u4eabudf\u4e0d\u652f\u6301\u53d1\u5e03\u64cd\u4f5c\uff01");
        }
        this.udfVersionDao.updatePublishStatus(udfId, version, true);
        logger.info("end to publish udf, udfId: " + udfId);
    }

    @Override
    public void publishLatestUdf(Long udfId) throws UDFException {
        UDFVersion udfVersion = this.udfVersionDao.selectLatestByUdfId(udfId);
        this.udfVersionDao.updatePublishStatus(udfId, udfVersion.getBmlResourceVersion(), true);
    }

    @Override
    public void rollbackUDF(Long udfId, String version, String userName) throws UDFException {
        logger.info("begin to rollback udf, udfId: " + udfId);
        UDFVersion udfVersion = this.udfVersionDao.selectByUdfIdAndVersion(udfId, version);
        BmlRollbackVersionResponse response = this.bmlClient.rollbackVersion(udfVersion.getBmlResourceId(), udfVersion.getBmlResourceVersion(), userName);
        if (!response.isSuccess()) {
            throw new UDFException("bml rollback version \u5f02\u5e38\uff01");
        }
        UDFVersion newVersion = new UDFVersion(null, udfVersion.getUdfId(), udfVersion.getPath(), response.resourceId(), response.version(), udfVersion.getPublished(), udfVersion.getRegisterFormat(), udfVersion.getUseFormat(), udfVersion.getDescription(), new Date(), udfVersion.getMd5());
        this.udfVersionDao.addUdfVersion(newVersion);
        logger.info("end to rollback udf, udfId: " + udfId);
    }

    @Override
    public List<UDFVersionVo> getUdfVersionList(long udfId) {
        return this.udfVersionDao.getAllVersionByUdfId(udfId);
    }

    @Override
    public PageInfo<UDFAddVo> getManagerPages(String udfName, Collection<Integer> udfType, String createUser, int curPage, int pageSize) throws Exception {
        logger.info("begin to get managerPages.");
        List<Object> retList = new ArrayList();
        PageHelper.startPage((int)curPage, (int)pageSize);
        retList = this.udfDao.getUdfInfoByPages(udfName, udfType, createUser);
        PageInfo pageInfo = new PageInfo(retList);
        final boolean ismanager = this.isUDFManager(createUser);
        List<Long> loadedUdf = this.udfDao.getLoadedUDFIds(createUser);
        if (pageInfo.getList() != null) {
            pageInfo.getList().forEach(l -> {
                long loadCount;
                l.setLoad(Boolean.valueOf(loadedUdf.contains(l.getId())));
                boolean canExpire = false;
                if (Boolean.TRUE.equals(l.getShared()) && (loadCount = this.udfDao.getUserLoadCountByUdfId(l.getId(), createUser)) > 0L) {
                    canExpire = true;
                }
                final boolean finalCanExpire = canExpire;
                l.setOperationStatus((Map)new HashMap<String, Boolean>(){
                    {
                        this.put("canUpdate", true);
                        this.put("canDelete", !finalCanExpire);
                        this.put("canExpire", finalCanExpire);
                        this.put("canShare", ismanager);
                        this.put("canPublish", ismanager && Boolean.TRUE.equals(l.getShared()));
                        this.put("canHandover", true);
                    }
                });
            });
        }
        logger.info("end to get managerPages.");
        return pageInfo;
    }

    @Override
    public String downLoadUDF(long udfId, String version, String user) throws Exception {
        logger.info("user " + user + " begin to downLoad udf, udfId: " + udfId);
        UDFInfo udfInfo = this.udfDao.getUDFById(udfId);
        if (udfInfo.getUdfType() == 0) {
            throw new UDFException("jar\u7c7b\u578b\u7684udf\u4e0d\u652f\u6301\u4e0b\u8f7d\u67e5\u770b\u5185\u5bb9");
        }
        UDFVersion udfVersion = this.udfVersionDao.selectByUdfIdAndVersion(udfId, version);
        BmlDownloadResponse downloadResponse = this.downloadBml(user, udfVersion.getBmlResourceId(), udfVersion.getBmlResourceVersion());
        String content = IOUtils.toString((InputStream)downloadResponse.inputStream(), (String)((String)Configuration.BDP_ENCODING().getValue()));
        IOUtils.closeQuietly((InputStream)downloadResponse.inputStream());
        logger.info("user " + user + " end to downLoad udf, udfId: " + udfId);
        return content;
    }

    @Override
    public DownloadVo downloadToLocal(long udfId, String version, String user) throws Exception {
        logger.info("user " + user + " begin to downLoad udf, udfId: " + udfId);
        UDFVersion udfVersion = this.udfVersionDao.selectByUdfIdAndVersion(udfId, version);
        BmlDownloadResponse downloadResponse = this.downloadBml(user, udfVersion.getBmlResourceId(), udfVersion.getBmlResourceVersion());
        logger.info("user " + user + " end to downLoad udf, udfId: " + udfId);
        return new DownloadVo(udfVersion.getPath().substring(udfVersion.getPath().lastIndexOf("/") + 1), downloadResponse.inputStream());
    }

    @Override
    public List<String> allUdfUsers() {
        return this.udfDao.selectAllUser();
    }

    @Override
    public List<String> getUserDirectory(String user, String category) {
        return this.udfTreeDao.getUserDirectory(user, category);
    }

    @Override
    public List<UDFInfoVo> getAllUDFSByUserName(String userName) throws UDFException {
        logger.info("Start to get all udf {}", (Object)userName);
        ArrayList<String> users = new ArrayList<String>();
        users.add("sys");
        users.add("bdp");
        users.add(userName);
        List<UDFInfoVo> udfsByUsers = this.udfDao.getUDFSByUsers(users);
        List<UDFInfoVo> sharedUDFByUser = this.udfDao.getSharedUDFByUser(userName);
        ArrayList<UDFInfoVo> udfInfoVos = new ArrayList<UDFInfoVo>();
        if (null != udfsByUsers) {
            udfInfoVos.addAll(udfsByUsers);
        }
        if (null != sharedUDFByUser) {
            udfInfoVos.addAll(sharedUDFByUser);
        }
        logger.info("Finished to get all udf {}, size {}", (Object)userName, (Object)udfInfoVos.size());
        return udfInfoVos;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean deleteUDF(Long udfId, String userName) throws UDFException {
        logger.info(userName + " begin to delete udf, udfId: " + udfId);
        UDFInfo udfInfo = this.udfDao.getUDFById(udfId);
        if (Boolean.TRUE.equals(udfInfo.getShared())) {
            long loadCount = this.udfDao.getUserLoadCountByUdfId(udfId, userName);
            if (loadCount > 0L) {
                throw new UDFException("\u8be5\u5171\u4eabudf\u88ab\u7528\u6237\u52a0\u8f7d\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.udfDao.deleteAllSharedUser(udfId);
        }
        this.udfDao.deleteLoadInfo(udfId, userName);
        this.udfDao.deleteUDF(udfId, userName);
        this.udfVersionDao.deleteVersionByUdfId(udfId);
        logger.info(userName + " end to delete udf, udfId: " + udfId);
        return true;
    }

    @Override
    public UDFInfo getUDFById(Long id, String userName) {
        return this.udfDao.getUDFById(id);
    }

    @Override
    public Boolean deleteLoadInfo(Long id, String userName) {
        this.udfDao.deleteLoadInfo(id, userName);
        return true;
    }

    @Override
    public Boolean addLoadInfo(Long id, String userName) throws UDFException {
        try {
            long loadCount;
            UDFInfo udfInfo = this.getUDFById(id, userName);
            if (udfInfo.getUdfType() == 0 && (loadCount = this.udfDao.getSameLoadCount(userName, udfInfo.getUdfName())) > 0L) {
                throw new UDFException("There is a Jar package function with the same name(\u5b58\u5728\u540c\u540d\u7684Jar\u5305\u51fd\u6570)\uff1a " + udfInfo.getUdfName());
            }
            this.udfDao.addLoadInfo(id, userName);
        }
        catch (Throwable e) {
            if (e instanceof DuplicateKeyException) {
                return true;
            }
            throw new UDFException(e.getMessage());
        }
        return true;
    }

    @Override
    public List<UDFInfo> getUDFSByUserName(String userName) {
        return this.udfDao.getUDFSByUserName(userName);
    }

    @Override
    public List<UDFInfoVo> getUDFSByTreeIdAndUser(Long treeId, String userName, String category) {
        return this.udfDao.getUDFSByTreeIdAndUser(treeId, userName, this.categoryToCodes.get(category));
    }

    @Override
    public List<UDFInfoVo> getUDFInfoByTreeId(Long treeId, String userName, String category) {
        return this.udfDao.getUDFInfoByTreeId(treeId, userName, this.categoryToCodes.get(category));
    }

    @Override
    public List<UDFInfoVo> getUDFInfoByIds(Long[] ids, String category) {
        if (ids == null || ids.length == 0) {
            return new ArrayList<UDFInfoVo>(0);
        }
        return this.udfDao.getUDFInfoByIds(ids, this.categoryToCodes.get(category));
    }

    @Override
    @Deprecated
    public Map<String, List<String>> generateInitSql(String userName) {
        logger.info(userName + " generateInitSql");
        List<UDFInfo> loadedUDFs = this.udfDao.getLoadedUDFs(userName);
        HashSet fileSet = new HashSet();
        ArrayList udfJars = new ArrayList();
        ArrayList registerJars = new ArrayList();
        ArrayList udfPys = new ArrayList();
        ArrayList registerPys = new ArrayList();
        ArrayList udfScalas = new ArrayList();
        ArrayList registerScalas = new ArrayList();
        ArrayList functionsPython = new ArrayList();
        ArrayList functionsScala = new ArrayList();
        HashedMap res = new HashedMap();
        res.put("udfJars", udfJars);
        res.put("registerJars", registerJars);
        res.put("udfPys", udfPys);
        res.put("registerPys", registerPys);
        res.put("udfScalas", udfScalas);
        res.put("registerScalas", registerScalas);
        res.put("functionsPython", functionsPython);
        res.put("functionsScala", functionsScala);
        return res;
    }

    @Override
    @Deprecated
    public Iterator<String> getAllLoadJars(String userName) throws UDFException {
        List<UDFInfo> loadedUDFs = this.udfDao.getLoadedUDFs(userName);
        HashSet fileSet = new HashSet();
        for (UDFInfo uDFInfo : loadedUDFs) {
        }
        return fileSet.iterator();
    }

    @Override
    @Deprecated
    public List<UDFInfo> getSharedUDFByUserName(String userName) {
        return null;
    }

    @Override
    @Deprecated
    public List<UDFInfo> getSharedUDFByTreeId(Integer treeId, String userName) {
        return null;
    }

    @Override
    @Deprecated
    public List<UDFInfo> getSharedUDFInfos(Long id, String userName, String category) {
        return this.udfDao.selectSharedUDFInfosByTreeIdAndUserName(id, userName, this.categoryToCodes.get(category));
    }

    @Override
    public List<UDFInfoVo> getSharedUDFs(String userName, String category) {
        List<UDFInfoVo> udfIds = this.getLatesetPublishedUDF(userName, category);
        return udfIds.stream().filter(l -> !Boolean.TRUE.equals(l.getExpire())).collect(Collectors.toList());
    }

    private List<UDFInfoVo> getLatesetPublishedUDF(String userName, String category) {
        List<UDFInfoVo> udfIds = this.udfDao.getLatesetPublishedUDF(userName, this.categoryToCodes.get(category));
        return udfIds;
    }

    @Override
    public List<UDFInfoVo> getExpiredUDFs(String userName, String category) {
        List<UDFInfoVo> udfIds = this.getLatesetPublishedUDF(userName, category);
        return udfIds.stream().filter(l -> Boolean.TRUE.equals(l.getExpire())).collect(Collectors.toList());
    }

    @Override
    public Boolean isUDFManager(String userName) {
        UDFManager udfManager = this.udfDao.selectUDFManager(userName);
        if (udfManager == null) {
            return false;
        }
        return true;
    }

    @Override
    public void checkSharedUsers(Set<String> sharedUsers, String userName, String udfName) throws UDFException {
        if (sharedUsers.contains(userName)) {
            throw new UDFException("Do not support sharing to yourself!(\u4e0d\u652f\u6301\u5206\u4eab\u7ed9\u81ea\u5df1!)");
        }
        for (String shareduser : sharedUsers) {
            if (StringUtils.isEmpty((CharSequence)shareduser)) {
                throw new UDFException("\u5171\u4eab\u7528\u6237\u4e0d\u80fd\u5305\u542b\u7a7a\u7528\u6237\u540d\uff01");
            }
            if (!this.pattern.matcher(shareduser).matches()) {
                throw new UDFException("\u7528\u6237\u540d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6570\u5b57\u4e0b\u5212\u7ebf\uff01");
            }
            long count = this.udfDao.getSameNameCountByUser(udfName, shareduser);
            long sharedCount = this.udfDao.getShareSameNameCountExcludeUser(udfName, shareduser, userName);
            if (count <= 0L && sharedCount <= 0L) continue;
            throw new UDFException("\u7528\u6237\uff1a" + shareduser + "\u5305\u542b\u540c\u540dudf\uff01");
        }
    }

    @Override
    @Deprecated
    public UDFInfo addSharedUDFInfo(UDFInfo sharedUDFInfo) throws UDFException {
        long count = this.udfDao.getShareSameNameCountByUser(sharedUDFInfo.getUdfName(), sharedUDFInfo.getCreateUser());
        if (count > 0L) {
            throw new UDFException("Shared udf name(\u5206\u4eab\u7684udf\u7684\u540d\u5b57)(" + sharedUDFInfo.getUdfName() + ")Already exists, please edit the name and re-share(\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540d\u5b57\u540e\u91cd\u65b0\u8fdb\u884c\u5206\u4eab)");
        }
        this.udfDao.addUDF(sharedUDFInfo);
        return sharedUDFInfo;
    }

    @Override
    public void setUDFSharedInfo(boolean iShared, Long id) {
        this.udfDao.updateUDFIsShared(iShared, id);
    }

    @Override
    public Long getAllShareUDFInfoIdByUDFId(String userName, String udfName) {
        return this.udfDao.selectAllShareUDFInfoIdByUDFId(userName, udfName);
    }

    @Override
    public void setUdfExpire(Long udfId, String userName) throws UDFException {
        long loadCount;
        logger.info(userName + " begin to expire udf, udfId: " + udfId);
        UDFInfo udfInfo = this.getUDFById(udfId, userName);
        if (Boolean.TRUE.equals(udfInfo.getShared()) && (loadCount = this.udfDao.getUserLoadCountByUdfId(udfId, userName)) > 0L) {
            this.udfDao.updateSharedUDFExpire(udfId);
            logger.info(userName + " end to expire udf, udfId: " + udfId);
            return;
        }
        throw new UDFException("\u53ea\u6709\u88ab\u5171\u4eab\u7528\u6237\u52a0\u8f7d\u7684udf\u53ef\u4ee5\u8bbe\u7f6e\u8fc7\u671f");
    }

    @Override
    public List<String> getAllSharedUsersByUdfId(String userName, long udfId) {
        List<String> shareUsers = this.udfDao.selectAllShareUsersByUDFId(userName, udfId);
        shareUsers.removeIf(userName::equals);
        return shareUsers;
    }

    @Override
    public void addSharedUser(Set<String> sharedUsers, Long udfId) {
        for (String sharedUser : sharedUsers) {
            this.udfDao.insertSharedUser(sharedUser, udfId);
        }
    }

    @Override
    public void removeSharedUser(Collection<String> oldsharedUsers, Long udfId) {
        for (String oldsharedUser : oldsharedUsers) {
            this.udfDao.deleteSharedUser(oldsharedUser, udfId);
            this.udfDao.deleteLoadInfo(udfId, oldsharedUser);
        }
    }

    @Override
    public List<UDFAddVo> getUdfByNameList(List<String> udfNameList, String creator) {
        List<Object> retList = new ArrayList();
        retList = this.udfDao.getUdfInfoByNameList(udfNameList, creator);
        final boolean ismanager = this.isUDFManager(creator);
        List<Long> loadedUdf = this.udfDao.getLoadedUDFIds(creator);
        retList.forEach(udfInfo -> {
            long loadCount;
            udfInfo.setLoad(Boolean.valueOf(loadedUdf.contains(udfInfo.getId())));
            boolean canExpire = false;
            if (Boolean.TRUE.equals(udfInfo.getShared()) && (loadCount = this.udfDao.getUserLoadCountByUdfId(udfInfo.getId(), udfInfo.getCreateUser())) > 0L) {
                canExpire = true;
            }
            final boolean finalCanExpire = canExpire;
            udfInfo.setOperationStatus((Map)new HashMap<String, Boolean>(){
                {
                    this.put("canUpdate", true);
                    this.put("canDelete", !finalCanExpire);
                    this.put("canExpire", finalCanExpire);
                    this.put("canShare", ismanager);
                    this.put("canPublish", ismanager && Boolean.TRUE.equals(udfInfo.getShared()));
                    this.put("canHandover", true);
                }
            });
        });
        return retList;
    }

    @Override
    public UDFVersionVo getUdfVersionInfo(String udfName, String createUser) {
        return this.udfVersionDao.getUdfVersionInfoByName(udfName, createUser);
    }
}

