/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.udf;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class VectorUDFArgDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isConstant;
    private int columnNum;
    private transient GenericUDF.DeferredJavaObject constObjVal;
    private ExprNodeConstantDesc constExpr;

    public void setConstant(ExprNodeConstantDesc expr) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        this.isConstant = true;
        if (expr != null && expr.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE && (primitiveCategory = ((PrimitiveTypeInfo)expr.getTypeInfo()).getPrimitiveCategory()) == PrimitiveObjectInspector.PrimitiveCategory.VOID) {
            expr = null;
        }
        this.constExpr = expr;
    }

    public void prepareConstant() {
        Object writableValue;
        if (this.constExpr != null) {
            PrimitiveObjectInspector.PrimitiveCategory pc = ((PrimitiveTypeInfo)this.constExpr.getTypeInfo()).getPrimitiveCategory();
            writableValue = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pc).getPrimitiveWritableObject(this.constExpr.getValue());
        } else {
            writableValue = null;
        }
        this.constObjVal = new GenericUDF.DeferredJavaObject(writableValue);
    }

    public void setVariable(int i) {
        this.columnNum = i;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isVariable() {
        return !this.isConstant;
    }

    public int getColumn() {
        return this.columnNum;
    }

    public GenericUDF.DeferredObject getDeferredJavaObject(int row, VectorizedRowBatch b, int argPosition, VectorExpressionWriter[] writers) {
        if (this.isConstant()) {
            return this.constObjVal;
        }
        ColumnVector cv = b.cols[this.columnNum];
        try {
            Object o = writers[argPosition].writeValue(cv, row);
            return new GenericUDF.DeferredJavaObject(o);
        }
        catch (HiveException e) {
            throw new RuntimeException("Unable to get Java object from VectorizedRowBatch", e);
        }
    }

    public boolean getIsConstant() {
        return this.isConstant;
    }

    public void setIsConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    public int getColumnNum() {
        return this.columnNum;
    }

    public void setColumnNum(int columnNum) {
        this.columnNum = columnNum;
    }

    public ExprNodeConstantDesc getConstExpr() {
        return this.constExpr;
    }

    public void setConstExpr(ExprNodeConstantDesc constExpr) {
        this.constExpr = constExpr;
    }
}

