/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)Driver.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private static final int SLEEP_TIME = 2000;
    private Queue<Task<? extends Serializable>> runnable;
    private Queue<TaskRunner> running;
    private int curJobNo;
    private Context ctx;
    private boolean shutdown;
    final Map<String, StatsTask> statsTasks = new HashMap<String, StatsTask>(1);

    public DriverContext() {
    }

    public DriverContext(Context ctx) {
        this.runnable = new ConcurrentLinkedQueue<Task<? extends Serializable>>();
        this.running = new LinkedBlockingQueue<TaskRunner>();
        this.ctx = ctx;
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized boolean isRunning() {
        return !this.shutdown && (!this.running.isEmpty() || !this.runnable.isEmpty());
    }

    public synchronized void remove(Task<? extends Serializable> task) {
        this.runnable.remove(task);
    }

    public synchronized void launching(TaskRunner runner) throws HiveException {
        this.checkShutdown();
        this.running.add(runner);
    }

    public synchronized Task<? extends Serializable> getRunnable(int maxthreads) throws HiveException {
        this.checkShutdown();
        if (this.runnable.peek() != null && this.running.size() < maxthreads) {
            return this.runnable.remove();
        }
        return null;
    }

    public synchronized TaskRunner pollFinished() throws InterruptedException {
        while (!this.shutdown) {
            Iterator it = this.running.iterator();
            while (it.hasNext()) {
                TaskRunner runner = (TaskRunner)it.next();
                if (runner == null || runner.isRunning()) continue;
                it.remove();
                return runner;
            }
            this.wait(2000L);
        }
        return null;
    }

    private void checkShutdown() throws HiveException {
        if (this.shutdown) {
            throw new HiveException("FAILED: Operation cancelled");
        }
    }

    public synchronized void shutdown() {
        LOG.debug("Shutting down query " + this.ctx.getCmd());
        this.shutdown = true;
        for (TaskRunner runner : this.running) {
            Thread thread;
            if (!runner.isRunning()) continue;
            Task<? extends Serializable> task = runner.getTask();
            LOG.warn("Shutting down task : " + task);
            try {
                task.shutdown();
            }
            catch (Exception e) {
                console.printError("Exception on shutting down task " + task.getId() + ": " + e);
            }
            if ((thread = runner.getRunner()) == null) continue;
            thread.interrupt();
        }
        this.running.clear();
    }

    public static boolean isLaunchable(Task<? extends Serializable> tsk) {
        return tsk.isNotInitialized() && tsk.isRunnable();
    }

    public synchronized boolean addToRunnable(Task<? extends Serializable> tsk) throws HiveException {
        if (this.runnable.contains(tsk)) {
            return false;
        }
        this.checkShutdown();
        this.runnable.add(tsk);
        tsk.setQueued();
        return true;
    }

    public int getCurJobNo() {
        return this.curJobNo;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void incCurJobNo(int amount) {
        this.curJobNo += amount;
    }

    public void prepare(QueryPlan plan) {
        ArrayList<Task<? extends Serializable>> rootTasks = plan.getRootTasks();
        NodeUtils.iterateTask(rootTasks, StatsTask.class, new NodeUtils.Function<StatsTask>(){

            @Override
            public void apply(StatsTask statsTask) {
                if (((StatsWork)statsTask.getWork()).isAggregating()) {
                    DriverContext.this.statsTasks.put(((StatsWork)statsTask.getWork()).getAggKey(), statsTask);
                }
            }
        });
    }

    public void prepare(TaskRunner runner) {
    }

    public void finished(TaskRunner runner) {
        if (this.statsTasks.isEmpty() || !(runner.getTask() instanceof MapRedTask)) {
            return;
        }
        MapRedTask mapredTask = (MapRedTask)runner.getTask();
        MapWork mapWork = ((MapredWork)mapredTask.getWork()).getMapWork();
        ReduceWork reduceWork = ((MapredWork)mapredTask.getWork()).getReduceWork();
        ArrayList<Operator<? extends OperatorDesc>> operators = new ArrayList<Operator<? extends OperatorDesc>>(mapWork.getAliasToWork().values());
        if (reduceWork != null) {
            operators.add(reduceWork.getReducer());
        }
        final ArrayList statKeys = new ArrayList(1);
        NodeUtils.iterate(operators, FileSinkOperator.class, new NodeUtils.Function<FileSinkOperator>(){

            @Override
            public void apply(FileSinkOperator fsOp) {
                if (((FileSinkDesc)fsOp.getConf()).isGatherStats()) {
                    statKeys.add(((FileSinkDesc)fsOp.getConf()).getStatsAggPrefix());
                }
            }
        });
        for (String statKey : statKeys) {
            ((StatsWork)this.statsTasks.get(statKey).getWork()).setSourceTask(mapredTask);
        }
    }
}

