/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;

public class DataSources {
    private static final CommonVars<String> DEFAULT_HDFS_NAME = CommonVars.apply((String)"wds.linkis.server.dsm.default.hdfs.name", (Object)".LOCAL_HDFS");
    private static final Map<String, DataSource> DEFAULT_DATASOURCES = new HashMap<String, DataSource>();

    public static DataSource getDefault(String dataSourceName) {
        return DEFAULT_DATASOURCES.get(dataSourceName);
    }

    static {
        DataSourceType hdfsType = new DataSourceType();
        hdfsType.setName("hdfs");
        DataSource hdfs = new DataSource();
        hdfs.setDataSourceType(hdfsType);
        hdfs.setDataSourceName((String)DEFAULT_HDFS_NAME.getValue());
        DEFAULT_DATASOURCES.put(hdfs.getDataSourceName(), hdfs);
        DEFAULT_DATASOURCES.values().forEach(dataSource -> dataSource.setCreateUser(System.getProperty("user.name")));
    }
}

