/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.until;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.linkis.monitor.core.pac.DataFetcher;
import org.apache.linkis.monitor.core.scanner.AnomalyScanner;
import org.apache.linkis.monitor.factory.MapperFactory;
import org.apache.linkis.monitor.jobhistory.JobHistoryDataFetcher;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc;
import org.apache.linkis.monitor.utils.log.LogUtils;
import org.slf4j.Logger;

public class JobMonitorUtils {
    private static final Logger logger = LogUtils.stdOutLogger();

    public static void run(AnomalyScanner scanner, List<DataFetcher> fetchers, Boolean shouldStart) {
        if (shouldStart.booleanValue()) {
            scanner.addDataFetchers(fetchers);
            scanner.run();
        }
    }

    public static List<DataFetcher> generateFetchers(long startTime, long endTime, long maxIntervalMs, long id, String timeType) {
        ArrayList<DataFetcher> ret = new ArrayList<DataFetcher>();
        for (long pe = endTime; pe > startTime; pe -= maxIntervalMs) {
            long ps = Math.max(pe - maxIntervalMs, startTime);
            Object[] fetcherArgs = new String[]{String.valueOf(ps), String.valueOf(pe), String.valueOf(id), timeType};
            ret.add(new JobHistoryDataFetcher(fetcherArgs, MapperFactory.getJobHistoryMapper()));
            logger.info("Generated dataFetcher for startTime: " + new Date(ps) + ". EndTime: " + new Date(pe));
        }
        return ret;
    }

    public static List<DataFetcher> generateFetchersfortime(long startTime, long endTime, long id, String timeType) {
        ArrayList<DataFetcher> fetchers = new ArrayList<DataFetcher>();
        Object[] fetcherArgs = new String[]{String.valueOf(startTime), String.valueOf(endTime), String.valueOf(id), timeType};
        fetchers.add(new JobHistoryDataFetcher(fetcherArgs, MapperFactory.getJobHistoryMapper()));
        logger.info("Generated dataFetcher for startTime: " + new Date(startTime) + ". EndTime: " + new Date(endTime));
        return fetchers;
    }

    public static void addIntervalToImsAlerts(Map<String, AlertDesc> alerts, long realIntervals) {
        for (AlertDesc alert : alerts.values()) {
            if (!(alert instanceof ImsAlertDesc)) {
                logger.info("[warn]  ignore wrong alert" + alert);
                continue;
            }
            ((ImsAlertDesc)alert).hitIntervalMs_$eq(realIntervals);
        }
    }
}

