/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.properties.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.PropsException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.properties.reader.PropertiesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsFileReader
implements PropertiesReader {
    private static final Logger logger = LoggerFactory.getLogger(PropsFileReader.class);
    private String propsId;
    private String propsPath;

    @Override
    public String getPropsId() {
        return this.propsId;
    }

    @Override
    public PropertiesReader setPropsId(String identifier) {
        this.propsId = identifier;
        return this;
    }

    @Override
    public String getPropsPath() {
        return this.propsPath;
    }

    @Override
    public PropsFileReader setPropsPath(String propsPath) {
        File propsFile = new File(propsPath);
        this.propsPath = propsFile.getAbsolutePath();
        return this;
    }

    @Override
    public Properties getProperties() {
        this.checkInit();
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.propsPath));
            properties.load(in);
        }
        catch (Exception e) {
            throw new PropsException("PRP0002", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PropsReaderErr, "Source: " + this.propsPath, e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    @Override
    public void checkInit() {
        if (StringUtils.isBlank((CharSequence)this.propsId) || StringUtils.isBlank((CharSequence)this.propsPath)) {
            throw new PropsException("PRP0001", ErrorLevel.WARN, (ErrorMsg)CommonErrMsg.PropsReaderInitErr, "properties reader for source: " + this.propsPath + " is not inited. because of blank propsId or propsPath");
        }
    }
}

