/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.cli.application.constants.CliConstants;
import org.apache.linkis.cli.application.interactor.job.common.KillResult;
import org.apache.linkis.cli.application.operator.ujes.LinkisJobOper;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobKiller {
    private static final Logger logger = LoggerFactory.getLogger(JobKiller.class);
    private LinkisJobOper oper;

    public JobKiller(LinkisJobOper linkisJobOperator) {
        this.oper = linkisJobOperator;
    }

    public KillResult doKill(String username, String jobId) {
        Object msg3;
        LinkisOperResultAdapter jobInfoResult;
        try {
            jobInfoResult = this.oper.queryJobInfo(username, jobId);
        }
        catch (Exception e) {
            return new KillResult(true, "Failed to query jobInfo" + ExceptionUtils.getStackTrace((Throwable)e), new HashMap<String, String>());
        }
        if (jobInfoResult.getUser() == null || jobInfoResult.getJobID() == null) {
            return new KillResult(false, "user or jobID is null", new HashMap<String, String>());
        }
        if (jobInfoResult.getJobStatus() == null) {
            return new KillResult(false, "jobStatus is null", new HashMap<String, String>());
        }
        if (jobInfoResult.getJobStatus().isJobCancelled()) {
            String msg2 = "Kill job aborted: Job has already been canceled.";
            return new KillResult(false, msg2, new HashMap<String, String>());
        }
        if (jobInfoResult.getJobStatus().isJobFinishedState()) {
            String msg3 = "Kill job aborted: Job is already in finished-state(SUCCEED/FAILED).";
            return new KillResult(false, msg3, new HashMap<String, String>());
        }
        try {
            msg3 = this.oper.kill(jobInfoResult.getUser(), jobInfoResult.getJobID(), jobInfoResult.getStrongerExecId());
        }
        catch (Exception e) {
            return new KillResult(false, "Exception thrown when trying to send kill request. Messgae: " + ExceptionUtils.getStackTrace((Throwable)e), new HashMap<String, String>());
        }
        msg3 = "Kill request has been sent";
        LoggerManager.getPlaintTextLogger().info((String)msg3);
        int retryCnt = 0;
        int MAX_RETRY = 30;
        while (!jobInfoResult.getJobStatus().isJobFinishedState() && !jobInfoResult.getJobStatus().isJobCancelled()) {
            CliUtils.doSleepQuietly(CliConstants.JOB_QUERY_SLEEP_MILLS);
            try {
                jobInfoResult = this.oper.queryJobInfo(jobInfoResult.getUser(), jobInfoResult.getJobID());
                retryCnt = 0;
            }
            catch (Exception e) {
                CliUtils.doSleepQuietly(5L * CliConstants.JOB_QUERY_SLEEP_MILLS);
                if (++retryCnt < 30) continue;
                return new KillResult(false, MessageFormat.format("After send kill. Client cannot get jobStatus from server continuously for {0} seconds. Client aborted. Assume kill failed! Error message: \n", 150L * CliConstants.JOB_QUERY_SLEEP_MILLS), new HashMap<String, String>());
            }
        }
        if (jobInfoResult.getJobStatus().isJobFinishedState() && !jobInfoResult.getJobStatus().isJobCancelled()) {
            msg3 = "Kill Failed: Job Current status: " + jobInfoResult.getJobStatus();
            return new KillResult(false, (String)msg3, new HashMap<String, String>());
        }
        if (jobInfoResult.getJobStatus().isJobCancelled()) {
            msg3 = MessageFormat.format("Kill successful: jobId={0}, status={1}.", jobInfoResult.getJobID(), jobInfoResult.getJobStatus());
            return new KillResult(true, (String)msg3, new HashMap<String, String>());
        }
        return new KillResult(false, "Unknown Error!!", new HashMap<String, String>());
    }
}

