/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.template.option;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.command.CmdOption;
import org.apache.linkis.cli.application.interactor.command.template.converter.AbstractStringConverter;

public abstract class BaseOption<T>
implements CmdOption<T>,
Cloneable {
    private final String keyPrefix;
    private final String key;
    private final String description;
    private final boolean isOptional;
    private final AbstractStringConverter<T> converter;
    private final T defaultValue;
    protected boolean hasVal = false;
    protected String rawVal = null;
    protected T value = null;

    protected BaseOption(String keyPrefix, String key, String description, boolean isOptional, T defaultValue, AbstractStringConverter<T> converter) {
        this.keyPrefix = keyPrefix;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.converter = converter;
        this.isOptional = isOptional;
    }

    @Override
    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public abstract String getParamName();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setValueWithStr(String value) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((CharSequence)this.rawVal) && !StringUtils.equals((CharSequence)this.rawVal, (CharSequence)value)) {
            String msg = MessageFormat.format("Multiple Values for same option were found! Option: \"{0}\"", this.getParamName());
            throw new IllegalArgumentException(msg);
        }
        try {
            this.rawVal = value;
            this.value = this.converter.convert(value);
            this.hasVal = true;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T getValue() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void reset() {
        this.value = null;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getRawVal() {
        return this.rawVal;
    }

    public AbstractStringConverter<T> getConverter() {
        return this.converter;
    }

    @Override
    public BaseOption<T> clone() throws CloneNotSupportedException {
        BaseOption ret = (BaseOption)super.clone();
        ret.value = StringUtils.isBlank((CharSequence)this.rawVal) || ret.converter == null ? null : ret.converter.convert(this.rawVal);
        return ret;
    }

    @Override
    public boolean hasVal() {
        return this.hasVal;
    }
}

