/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.message.parser;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Chain;
import org.apache.linkis.rpc.message.annotation.Order;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.rpc.message.parser.ServiceMethod;
import org.apache.linkis.rpc.message.parser.ServiceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public class DefaultServiceParser
implements ServiceParser {
    Logger logger = LoggerFactory.getLogger(DefaultServiceParser.class);

    @Override
    public Map<String, List<ServiceMethod>> parse(Object service) {
        Method[] methods = AopUtils.getTargetClass((Object)service).getMethods();
        return Arrays.stream(methods).filter(this::methodFilterPredicate).map(m -> this.getServiceMethod((Method)m, service)).collect(Collectors.groupingBy(ServiceMethod::getProtocolName));
    }

    private ServiceMethod getServiceMethod(Method method, Object service) {
        Chain chain;
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        Parameter protocolParameter = parameters[0];
        ServiceMethod serviceMethod = new ServiceMethod();
        serviceMethod.setMethod(method);
        serviceMethod.setService(service);
        serviceMethod.setAlias(String.format("%s.%s", service.getClass().getName(), method.getName()));
        Order order = method.getAnnotation(Order.class);
        if (order != null) {
            serviceMethod.setOrder(order.value());
        }
        if ((chain = method.getAnnotation(Chain.class)) != null) {
            serviceMethod.setChainName(chain.value());
        }
        if (parameters.length == 2) {
            serviceMethod.setHasSender(true);
            if (Sender.class.isAssignableFrom(parameters[0].getType())) {
                serviceMethod.setSenderOnLeft(true);
                protocolParameter = parameters[1];
            }
        }
        this.logger.info(method + " parameter:" + Arrays.toString(Arrays.stream(parameters).map(Parameter::getName).toArray()));
        serviceMethod.setProtocolName(protocolParameter.getType().getName());
        return serviceMethod;
    }

    private boolean methodFilterPredicate(Method method) {
        if (method.getAnnotation(Receiver.class) != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (method.getParameterCount() == 1) {
                return !Sender.class.isAssignableFrom(parameterTypes[0]);
            }
            if (method.getParameterCount() == 2) {
                boolean hasContext = Arrays.stream(parameterTypes).anyMatch(Sender.class::isAssignableFrom);
                boolean allContext = Arrays.stream(parameterTypes).allMatch(Sender.class::isAssignableFrom);
                return hasContext && !allContext;
            }
        }
        return false;
    }
}

