/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.restful;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.scheduler.EntranceSchedulerContext;
import org.apache.linkis.instance.label.client.InstanceLabelClient;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.label.InsLabelRefreshRequest;
import org.apache.linkis.protocol.label.InsLabelRemoveRequest;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.SchedulerContext;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"entrance lable manager"})
@RestController
@RequestMapping(path={"/entrance/operation/label"})
public class EntranceLabelRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(EntranceLabelRestfulApi.class);
    private EntranceServer entranceServer;
    private static Boolean offlineFlag = false;

    @Autowired
    public void setEntranceServer(EntranceServer entranceServer) {
        this.entranceServer = entranceServer;
    }

    @ApiOperation(value="update", notes="update route label", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/update"}, method={RequestMethod.POST})
    public Message updateRouteLabel(HttpServletRequest req, @RequestBody JsonNode jsonNode) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"updateRouteLabel");
        if (Configuration.isNotAdmin((String)userName)) {
            return Message.error((String)"Non-administrators cannot update Route Label");
        }
        String routeLabel = jsonNode.get("routeLabel").textValue();
        HashMap<String, String> labels = new HashMap<String, String>();
        logger.info("Prepare to update entrance label {}", (Object)routeLabel);
        labels.put("route", routeLabel);
        InsLabelRefreshRequest insLabelRefreshRequest = new InsLabelRefreshRequest();
        insLabelRefreshRequest.setLabels(labels);
        insLabelRefreshRequest.setServiceInstance(Sender.getThisServiceInstance());
        InstanceLabelClient.getInstance().refreshLabelsToInstance(insLabelRefreshRequest);
        logger.info("Finished to update entrance label {}", (Object)routeLabel);
        return Message.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="markoffline", notes="add offline label", response=Message.class)
    @RequestMapping(path={"/markoffline"}, method={RequestMethod.GET})
    public Message updateRouteLabel(HttpServletRequest req) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"markoffline");
        HashMap<String, String> labels = new HashMap<String, String>();
        logger.info("Prepare to modify the routelabel of entrance to offline");
        labels.put("route", "offline");
        InsLabelRefreshRequest insLabelRefreshRequest = new InsLabelRefreshRequest();
        insLabelRefreshRequest.setLabels(labels);
        insLabelRefreshRequest.setServiceInstance(Sender.getThisServiceInstance());
        InstanceLabelClient.getInstance().refreshLabelsToInstance(insLabelRefreshRequest);
        Boolean bl = offlineFlag;
        synchronized (bl) {
            offlineFlag = true;
        }
        logger.info("Finished to modify the routelabel of entry to offline");
        logger.info("Prepare to update all not execution task instances to empty string");
        SchedulerContext schedulerContext = this.entranceServer.getEntranceContext().getOrCreateScheduler().getSchedulerContext();
        if (schedulerContext instanceof EntranceSchedulerContext) {
            ((EntranceSchedulerContext)schedulerContext).setOfflineFlag(true);
        }
        this.entranceServer.updateAllNotExecutionTaskInstances(true);
        logger.info("Finished to update all not execution task instances to empty string");
        return Message.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="backonline", notes="from offline status to recover", response=Message.class)
    @RequestMapping(path={"/backonline"}, method={RequestMethod.GET})
    public Message backOnline(HttpServletRequest req) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"backonline");
        logger.info("Prepare to modify the routelabel of entrance to remove offline");
        InsLabelRemoveRequest insLabelRemoveRequest = new InsLabelRemoveRequest();
        insLabelRemoveRequest.setServiceInstance(Sender.getThisServiceInstance());
        InstanceLabelClient.getInstance().removeLabelsFromInstance(insLabelRemoveRequest);
        Boolean bl = offlineFlag;
        synchronized (bl) {
            offlineFlag = false;
        }
        logger.info("Finished to backonline");
        return Message.ok();
    }

    @ApiOperation(value="isOnline", notes="entrance isOnline", response=Message.class)
    @RequestMapping(path={"/isOnline"}, method={RequestMethod.GET})
    public Message isOnline(HttpServletRequest req) {
        String thisInstance = Sender.getThisInstance();
        ServiceInstance mainInstance = DataWorkCloudApplication.getServiceInstance();
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setApplicationName(mainInstance.getApplicationName());
        serviceInstance.setInstance(thisInstance);
        List labelFromInstance = InstanceLabelClient.getInstance().getLabelFromInstance(serviceInstance);
        boolean res = true;
        String offline = "offline";
        if (!CollectionUtils.isEmpty((Collection)labelFromInstance)) {
            for (Label label : labelFromInstance) {
                if (!offline.equals(label.getValue())) continue;
                res = false;
            }
        }
        logger.info("Whether Entrance is online: {}", (Object)res);
        return Message.ok().data("isOnline", (Object)res);
    }
}

