/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkJobProgressUtil$
implements Logging {
    public static SparkJobProgressUtil$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SparkJobProgressUtil$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SparkJobProgressUtil$ sparkJobProgressUtil$ = this;
        synchronized (sparkJobProgressUtil$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public float getProgress(String applicationId, String sparkUIUrl) {
        Map<String, Object>[] sparkJobsResult;
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            return 0.0f;
        }
        Map<String, Object>[] mapArray = sparkJobsResult = StringUtils.isBlank((CharSequence)sparkUIUrl) ? this.getSparkJobInfo(applicationId) : this.getKubernetesSparkJobInfo(applicationId, sparkUIUrl);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult)).isEmpty()) {
            return 0.0f;
        }
        Tuple2 tuple = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult)).filter((Function1 & Serializable & scala.Serializable)sparkJobResult -> BoxesRunTime.boxToBoolean((boolean)SparkJobProgressUtil$.$anonfun$getProgress$1(sparkJobResult))))).map((Function1 & Serializable & scala.Serializable)result -> new Tuple2((Object)((Integer)result.get("numTasks")), (Object)((Integer)result.get("numCompletedTasks"))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).reduce((Function2 & Serializable & scala.Serializable)(total, completed) -> new Tuple2((Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)total._1()) + Predef$.MODULE$.Integer2int((Integer)completed._1())), (Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)total._2()) + Predef$.MODULE$.Integer2int((Integer)completed._2()))));
        return (float)Predef$.MODULE$.Integer2int((Integer)tuple._2()) / (float)Predef$.MODULE$.Integer2int((Integer)tuple._1());
    }

    public JobProgressInfo[] getSparkJobProgressInfo(String applicationId, String sparkUIUrl) {
        Map<String, Object>[] sparkJobsResult;
        Map<String, Object>[] mapArray = sparkJobsResult = StringUtils.isBlank((CharSequence)sparkUIUrl) ? this.getSparkJobInfo(applicationId) : this.getKubernetesSparkJobInfo(applicationId, sparkUIUrl);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult)).isEmpty()) {
            return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
        }
        return (JobProgressInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult)).map((Function1 & Serializable & scala.Serializable)sparkJobResult -> new JobProgressInfo(MODULE$.getJobId(Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("jobId")), (String)sparkJobResult.get("jobGroup")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numTasks")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numActiveTasks")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numFailedTasks")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numCompletedTasks"))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JobProgressInfo.class)));
    }

    public Map<String, Object>[] getSparkJobInfo(String applicationId) {
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        String yarnRestfulUrl = (String)SparkConfiguration$.MODULE$.SPARK_ONCE_YARN_RESTFUL_URL().getValue(EngineConnServer$.MODULE$.getEngineCreationContext().getOptions());
        String getAppUrl = new StringBuilder(20).append(yarnRestfulUrl).append("/ws/v1/cluster/apps/").append(applicationId).toString();
        this.logger().info(new StringBuilder(19).append("get yarn app, url: ").append(getAppUrl).toString());
        Map appResult = (Map)JsonUtils$.MODULE$.jackson().readValue(this.get(getAppUrl), Map.class);
        Map app = (Map)appResult.get("app");
        if (app == null) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        String trackingUrl = app.getOrDefault("trackingUrl", "");
        String state = app.getOrDefault("state", "");
        if (StringUtils.isBlank((CharSequence)trackingUrl) || "FINISHED".equals(state)) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        String getSparkJobsUrl = new StringBuilder(25).append(trackingUrl).append("api/v1/applications/").append(applicationId).append("/jobs").toString();
        this.logger().info(new StringBuilder(21).append("get spark jobs, url: ").append(getSparkJobsUrl).toString());
        String jobs = this.get(getSparkJobsUrl);
        if (StringUtils.isBlank((CharSequence)jobs)) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        return (Map[])JsonUtils$.MODULE$.jackson().readValue(this.get(getSparkJobsUrl), Map[].class);
    }

    public Map<String, Object>[] getKubernetesSparkJobInfo(String applicationId, String sparkUIUrl) {
        if (StringUtils.isBlank((CharSequence)applicationId) || StringUtils.isBlank((CharSequence)sparkUIUrl)) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        String getSparkJobsStateUrl = new StringBuilder(28).append("http://").append(sparkUIUrl).append("/api/v1/applications/").append(applicationId).toString();
        this.logger().info(new StringBuilder(51).append("get spark job state from kubernetes spark ui, url: ").append(getSparkJobsStateUrl).toString());
        Map appStateResult = (Map)JsonUtils$.MODULE$.jackson().readValue(this.get(getSparkJobsStateUrl), Map.class);
        List appAttemptList = (List)appStateResult.get("attempts");
        if (appAttemptList == null || appAttemptList.size() == 0) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        Map appLastAttempt = (Map)appAttemptList.get(appAttemptList.size() - 1);
        boolean isLastAttemptCompleted = BoxesRunTime.unboxToBoolean(appLastAttempt.get("completed"));
        if (isLastAttemptCompleted) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        String getSparkJobsInfoUrl = new StringBuilder(33).append("http://").append(sparkUIUrl).append("/api/v1/applications/").append(applicationId).append("/jobs").toString();
        this.logger().info(new StringBuilder(45).append("get spark job info from kubernetes spark ui: ").append(getSparkJobsInfoUrl).toString());
        String jobs = this.get(getSparkJobsInfoUrl);
        if (StringUtils.isBlank((CharSequence)jobs)) {
            return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        }
        return (Map[])JsonUtils$.MODULE$.jackson().readValue(this.get(getSparkJobsInfoUrl), Map[].class);
    }

    public String get(String url) {
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        if (response.getStatusLine().getStatusCode() == 200) {
            String str = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            this.logger().info(new StringBuilder(5).append("url: ").append(url).toString());
            this.logger().info(new StringBuilder(10).append("response: ").append(str).toString());
            return str;
        }
        return "";
    }

    public String getProgress$default$2() {
        return "";
    }

    public String getSparkJobProgressInfo$default$2() {
        return "";
    }

    private String getJobId(int jobId, String jobGroup) {
        return new StringBuilder(8).append("jobId-").append(jobId).append("(").append(jobGroup).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getProgress$1(Map sparkJobResult) {
        String status = sparkJobResult.getOrDefault("status", "");
        return "RUNNING".equals(status) || "SUCCEEDED".equals(status);
    }

    private SparkJobProgressUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

