/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall.spi;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorBase;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;

public class MySqlWallVisitor
extends WallVisitorBase
implements WallVisitor,
MySqlASTVisitor {
    public MySqlWallVisitor(WallProvider provider) {
        super(provider);
    }

    @Override
    public DbType getDbType() {
        return DbType.mysql;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        WallVisitorUtils.checkSelect(this, x);
        return true;
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        WallVisitorUtils.checkReadOnly(this, x.getFrom());
        return this.visit((SQLDeleteStatement)x);
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        return this.visit((SQLUpdateStatement)x);
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        if (x.getOwner() instanceof SQLVariantRefExpr) {
            SQLVariantRefExpr varExpr = (SQLVariantRefExpr)x.getOwner();
            SQLObject parent = x.getParent();
            String varName = varExpr.getName();
            if (varName.equalsIgnoreCase("@@session") || varName.equalsIgnoreCase("@@global")) {
                boolean isTop;
                if (!(parent instanceof SQLSelectItem) && !(parent instanceof SQLAssignItem)) {
                    this.violations.add(new IllegalSQLObjectViolation(2003, "variable in condition not allow", this.toSQL(x)));
                    return false;
                }
                if (!this.checkVar(x.getParent(), x.getName()) && !(isTop = WallVisitorUtils.isTopNoneFromSelect(this, x))) {
                    boolean allow = true;
                    if (this.isDeny(varName) && (WallVisitorUtils.isWhereOrHaving(x) || WallVisitorUtils.checkSqlExpr(varExpr))) {
                        allow = false;
                    }
                    if (!allow) {
                        this.violations.add(new IllegalSQLObjectViolation(2003, "variable not allow : " + x.getName(), this.toSQL(x)));
                    }
                }
                return false;
            }
        }
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    public boolean checkVar(SQLObject parent, String varName) {
        if (varName == null) {
            return false;
        }
        if (varName.equals("?")) {
            return true;
        }
        if (!this.config.isVariantCheck()) {
            return true;
        }
        if (varName.startsWith("@@")) {
            if (!(parent instanceof SQLSelectItem) && !(parent instanceof SQLAssignItem)) {
                return false;
            }
            varName = varName.substring(2);
        }
        return this.config.getPermitVariants().contains(varName);
    }

    public boolean isDeny(String varName) {
        if (varName.startsWith("@@")) {
            varName = varName.substring(2);
        }
        varName = varName.toLowerCase();
        return this.config.getDenyVariants().contains(varName);
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        String varName = x.getName();
        if (varName == null) {
            return false;
        }
        if (varName.startsWith("@@") && !this.checkVar(x.getParent(), x.getName())) {
            WallVisitorUtils.WallTopStatementContext topStatementContext = WallVisitorUtils.getWallTopStatementContext();
            if (topStatementContext != null && (topStatementContext.fromSysSchema() || topStatementContext.fromSysTable())) {
                return false;
            }
            boolean isTop = WallVisitorUtils.isTopNoneFromSelect(this, x);
            if (!isTop) {
                boolean allow = true;
                if (this.isDeny(varName) && (WallVisitorUtils.isWhereOrHaving(x) || WallVisitorUtils.checkSqlExpr(x))) {
                    allow = false;
                }
                if (!allow) {
                    this.violations.add(new IllegalSQLObjectViolation(2003, "variable not allow : " + x.getName(), this.toSQL(x)));
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(MySqlOutFileExpr x) {
        if (!this.config.isSelectIntoOutfileAllow() && !WallVisitorUtils.isTopSelectOutFile(x)) {
            this.violations.add(new IllegalSQLObjectViolation(3000, "into out file not allow", this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean isDenyTable(String name) {
        if (!this.config.isTableCheck()) {
            return false;
        }
        return !this.provider.checkDenyTable(name);
    }

    @Override
    public boolean visit(MySqlCreateTableStatement x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }
}

