/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

import java.util.Objects;
import java.util.regex.Pattern;

public class SqlInjectionUtils {
    private static final Pattern sqlSyntaxPattern = Pattern.compile("(insert|delete|update|select|create|drop|truncate|grant|alter|deny|revoke|call|execute|exec|declare|show|rename|set).+(into|from|set|where|table|database|view|index|on|cursor|procedure|trigger|for|password|union|and|or)", 2);
    private static final Pattern sqlCommentPattern = Pattern.compile("'.*(or|union|--|#|/*|;)", 2);

    public static boolean check(String value) {
        Objects.requireNonNull(value);
        if (sqlCommentPattern.matcher(value).find()) {
            return true;
        }
        return sqlSyntaxPattern.matcher(value).find();
    }
}

