/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import java.util.Optional;
import javax.validation.constraints.Null;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class IsNullAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<Null> isNull = this.extractAnnotation(context);
        if (isNull.isPresent()) {
            context.getBuilder().readOnly(Boolean.valueOf(isNull.isPresent()));
        }
    }

    private Optional<Null> extractAnnotation(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Null.class).map(Optional::of).orElse(Validators.annotationFromField(context, Null.class));
    }
}

