/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.adapter.druid.DruidType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class DruidExpressions {
    static final Map<SqlTypeName, DruidType> EXPRESSION_TYPES;
    private static final char[] SAFE_CHARS;

    private DruidExpressions() {
    }

    @Nullable
    public static String toDruidExpression(RexNode rexNode, RelDataType inputRowType, DruidQuery druidRel) {
        SqlKind kind = rexNode.getKind();
        SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
        if (kind == SqlKind.INPUT_REF) {
            RexInputRef ref = (RexInputRef)rexNode;
            String columnName = (String)inputRowType.getFieldNames().get(ref.getIndex());
            if (columnName == null) {
                return null;
            }
            if (druidRel.getDruidTable().timestampFieldName.equals(columnName)) {
                return DruidExpressions.fromColumn("__time");
            }
            return DruidExpressions.fromColumn(columnName);
        }
        if (rexNode instanceof RexCall) {
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            DruidSqlOperatorConverter conversion = druidRel.getOperatorConversionMap().get(operator);
            if (conversion == null) {
                return null;
            }
            return conversion.toDruidExpression(rexNode, inputRowType, druidRel);
        }
        if (kind == SqlKind.LITERAL) {
            if (RexLiteral.isNullLiteral((RexNode)rexNode)) {
                return null;
            }
            if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
                return DruidExpressions.numberLiteral((Number)((Object)RexLiteral.value((RexNode)rexNode)));
            }
            if (SqlTypeFamily.INTERVAL_DAY_TIME == sqlTypeName.getFamily()) {
                long milliseconds = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
                return DruidExpressions.numberLiteral(milliseconds);
            }
            if (SqlTypeFamily.INTERVAL_YEAR_MONTH == sqlTypeName.getFamily()) {
                long months = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
                return DruidExpressions.numberLiteral(months);
            }
            if (SqlTypeName.STRING_TYPES.contains(sqlTypeName)) {
                return DruidExpressions.stringLiteral(RexLiteral.stringValue((RexNode)rexNode));
            }
            if (SqlTypeName.TIMESTAMP == sqlTypeName || SqlTypeName.DATE == sqlTypeName || SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE == sqlTypeName) {
                return DruidExpressions.numberLiteral(DruidDateTimeUtils.literalValue(rexNode, TimeZone.getTimeZone(druidRel.getConnectionConfig().timeZone())).getMillisSinceEpoch());
            }
            if (SqlTypeName.BOOLEAN == sqlTypeName) {
                return DruidExpressions.numberLiteral(RexLiteral.booleanValue((RexNode)rexNode) ? 1 : 0);
            }
        }
        return null;
    }

    public static String fromColumn(String columnName) {
        return DruidQuery.format("\"%s\"", columnName);
    }

    public static String nullLiteral() {
        return "null";
    }

    public static String numberLiteral(Number n) {
        return n == null ? DruidExpressions.nullLiteral() : n.toString();
    }

    public static String stringLiteral(String s) {
        return s == null ? DruidExpressions.nullLiteral() : "'" + DruidExpressions.escape(s) + "'";
    }

    private static String escape(String s) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Arrays.binarySearch(SAFE_CHARS, c) >= 0) {
                escaped.append(c);
                continue;
            }
            escaped.append("\\u").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
        }
        return escaped.toString();
    }

    public static String functionCall(String functionName, List<String> args) {
        Preconditions.checkNotNull((Object)functionName, (Object)"druid functionName");
        Preconditions.checkNotNull(args, (Object)"args");
        StringBuilder builder = new StringBuilder(functionName);
        builder.append("(");
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)Preconditions.checkNotNull((Object)args.get(i), (String)"arg #%s", (Object[])new Object[]{i});
            builder.append(arg);
            if (i >= args.size() - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String nAryOperatorCall(String druidOperator, List<String> args) {
        Preconditions.checkNotNull((Object)druidOperator, (Object)"druid operator missing");
        Preconditions.checkNotNull(args, (Object)"args");
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)Preconditions.checkNotNull((Object)args.get(i), (String)"arg #%s", (Object[])new Object[]{i});
            builder.append(arg);
            if (i >= args.size() - 1) continue;
            builder.append(druidOperator);
        }
        builder.append(")");
        return builder.toString();
    }

    @Nullable
    public static List<String> toDruidExpressions(DruidQuery druidRel, RelDataType rowType, List<RexNode> rexNodes) {
        ArrayList<String> retVal = new ArrayList<String>(rexNodes.size());
        for (RexNode rexNode : rexNodes) {
            String druidExpression = DruidExpressions.toDruidExpression(rexNode, rowType, druidRel);
            if (druidExpression == null) {
                return null;
            }
            retVal.add(druidExpression);
        }
        return retVal;
    }

    public static String applyTimestampFloor(String input, String granularity, String origin, TimeZone timeZone) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkNotNull((Object)granularity, (Object)"granularity");
        return DruidExpressions.functionCall("timestamp_floor", (List<String>)ImmutableList.of((Object)input, (Object)DruidExpressions.stringLiteral(granularity), (Object)DruidExpressions.stringLiteral(origin), (Object)DruidExpressions.stringLiteral(timeZone.getID())));
    }

    public static String applyTimestampCeil(String input, String granularity, String origin, TimeZone timeZone) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkNotNull((Object)granularity, (Object)"granularity");
        return DruidExpressions.functionCall("timestamp_ceil", (List<String>)ImmutableList.of((Object)input, (Object)DruidExpressions.stringLiteral(granularity), (Object)DruidExpressions.stringLiteral(origin), (Object)DruidExpressions.stringLiteral(timeZone.getID())));
    }

    public static String applyTimeExtract(String timeExpression, String druidUnit, TimeZone timeZone) {
        return DruidExpressions.functionCall("timestamp_extract", (List<String>)ImmutableList.of((Object)timeExpression, (Object)DruidExpressions.stringLiteral(druidUnit), (Object)DruidExpressions.stringLiteral(timeZone.getID())));
    }

    static {
        SAFE_CHARS = " ,._-;:(){}[]<>!@#$%^&*`~?/".toCharArray();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SqlTypeName type : SqlTypeName.FRACTIONAL_TYPES) {
            builder.put((Object)type, (Object)DruidType.DOUBLE);
        }
        for (SqlTypeName type : SqlTypeName.INT_TYPES) {
            builder.put((Object)type, (Object)DruidType.LONG);
        }
        for (SqlTypeName type : SqlTypeName.STRING_TYPES) {
            builder.put((Object)type, (Object)DruidType.STRING);
        }
        builder.put((Object)SqlTypeName.TIMESTAMP, (Object)DruidType.LONG);
        builder.put((Object)SqlTypeName.DATE, (Object)DruidType.LONG);
        builder.put((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (Object)DruidType.LONG);
        builder.put((Object)SqlTypeName.OTHER, (Object)DruidType.COMPLEX);
        EXPRESSION_TYPES = builder.build();
        Arrays.sort(SAFE_CHARS);
    }
}

