/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.entities.Application;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.BuildVersion;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.StatusInfo;
import de.codecentric.boot.admin.server.eventstore.InstanceEventPublisher;
import de.codecentric.boot.admin.server.services.InstanceRegistry;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ApplicationRegistry {
    private final InstanceRegistry instanceRegistry;
    private final InstanceEventPublisher instanceEventPublisher;

    public ApplicationRegistry(InstanceRegistry instanceRegistry, InstanceEventPublisher instanceEventPublisher) {
        this.instanceRegistry = instanceRegistry;
        this.instanceEventPublisher = instanceEventPublisher;
    }

    public Flux<Application> getApplications() {
        return this.instanceRegistry.getInstances().filter(Instance::isRegistered).groupBy(instance -> instance.getRegistration().getName()).flatMap(grouped -> this.toApplication((String)grouped.key(), (Flux<Instance>)grouped), Integer.MAX_VALUE);
    }

    public Mono<Application> getApplication(String name) {
        return this.toApplication(name, (Flux<Instance>)this.instanceRegistry.getInstances(name).filter(Instance::isRegistered)).filter(a -> !a.getInstances().isEmpty());
    }

    public Flux<Application> getApplicationStream() {
        return Flux.from((Publisher)this.instanceEventPublisher).flatMap(event -> this.instanceRegistry.getInstance(event.getInstance())).map(this::getApplicationForInstance).flatMap(group -> this.toApplication((String)group.getT1(), (Flux<Instance>)((Flux)group.getT2())));
    }

    public Flux<InstanceId> deregister(String name) {
        return this.instanceRegistry.getInstances(name).flatMap(instance -> this.instanceRegistry.deregister(instance.getId()));
    }

    protected Tuple2<String, Flux<Instance>> getApplicationForInstance(Instance instance) {
        String name = instance.getRegistration().getName();
        return Tuples.of((Object)name, (Object)this.instanceRegistry.getInstances(name).filter(Instance::isRegistered));
    }

    protected Mono<Application> toApplication(String name, Flux<Instance> instances) {
        return instances.collectList().map(instanceList -> {
            Tuple2<String, Instant> status = this.getStatus((List<Instance>)instanceList);
            return Application.create(name).instances((List<Instance>)instanceList).buildVersion(this.getBuildVersion((List<Instance>)instanceList)).status((String)status.getT1()).statusTimestamp((Instant)status.getT2()).build();
        });
    }

    @Nullable
    protected BuildVersion getBuildVersion(List<Instance> instances) {
        List versions = instances.stream().map(Instance::getBuildVersion).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        if (versions.isEmpty()) {
            return null;
        }
        if (versions.size() == 1) {
            return (BuildVersion)versions.get(0);
        }
        return BuildVersion.valueOf(versions.get(0) + " ... " + versions.get(versions.size() - 1));
    }

    protected Tuple2<String, Instant> getStatus(List<Instance> instances) {
        Map<String, Instant> statusWithTime = instances.stream().collect(Collectors.toMap(instance -> instance.getStatusInfo().getStatus(), Instance::getStatusTimestamp, this::getMax));
        if (statusWithTime.size() == 1) {
            Map.Entry<String, Instant> e2 = statusWithTime.entrySet().iterator().next();
            return Tuples.of((Object)e2.getKey(), (Object)e2.getValue());
        }
        if (statusWithTime.containsKey("UP")) {
            Instant oldestNonUp = statusWithTime.entrySet().stream().filter(e -> !"UP".equals(e.getKey())).map(Map.Entry::getValue).min(Comparator.naturalOrder()).orElse(Instant.EPOCH);
            Instant latest = this.getMax(oldestNonUp, statusWithTime.getOrDefault("UP", Instant.EPOCH));
            return Tuples.of((Object)"RESTRICTED", (Object)latest);
        }
        return statusWithTime.entrySet().stream().min(Map.Entry.comparingByKey(StatusInfo.severity())).map(e -> Tuples.of(e.getKey(), e.getValue())).orElse(Tuples.of((Object)"UNKNOWN", (Object)Instant.EPOCH));
    }

    protected Instant getMax(Instant t1, Instant t2) {
        return t1.compareTo(t2) >= 0 ? t1 : t2;
    }
}

