/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.hive.executor;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.tez.TezJobExecHelper;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.utlis.ProgressUtils$;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.executor.entity.ResourceFetchExecutor;
import org.apache.linkis.engineplugin.hive.conf.Counters$;
import org.apache.linkis.engineplugin.hive.conf.HiveEngineConfiguration$;
import org.apache.linkis.engineplugin.hive.cs.CSHiveHelper$;
import org.apache.linkis.engineplugin.hive.errorcode.HiveErrorCodeSummary;
import org.apache.linkis.engineplugin.hive.exception.HiveQueryFailedException;
import org.apache.linkis.engineplugin.hive.executor.HiveDriverProxy;
import org.apache.linkis.engineplugin.hive.executor.HiveDriverProxy$;
import org.apache.linkis.engineplugin.hive.executor.HiveEngineConnExecutor$;
import org.apache.linkis.engineplugin.hive.progress.HiveProgressHelper$;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.protocol.resource.ResourceWithStatus;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015g\u0001\u0002(P\u0001qC\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"Q\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u0005M\u0001A!A!\u0002\u0013\t)\u0002\u0003\u0006\u0002\"\u0001\u0011\t\u0011)A\u0005\u0003GAq!a\r\u0001\t\u0003\t)\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H!A\u0011Q\u000b\u0001!\u0002\u0013\tI\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0003\u0002Z!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0006C\u0006\u0002t\u0001\u0001\r\u00111A\u0005\n\u0005U\u0004bCAB\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bC1\"!%\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002x!I\u00111\u0013\u0001A\u0002\u0013%\u0011Q\u0013\u0005\n\u0003/\u0003\u0001\u0019!C\u0005\u00033Cq!!(\u0001A\u0003&\u0001\u000fC\u0005\u0002 \u0002\u0001\r\u0011\"\u0003\u0002\u0016\"I\u0011\u0011\u0015\u0001A\u0002\u0013%\u00111\u0015\u0005\b\u0003O\u0003\u0001\u0015)\u0003q\u0011%\tI\u000b\u0001b\u0001\n\u0013\tY\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAW\u0011%\t)\f\u0001a\u0001\n\u0013\tY\u000bC\u0005\u00028\u0002\u0001\r\u0011\"\u0003\u0002:\"A\u0011Q\u0018\u0001!B\u0013\ti\u000bC\u0006\u0002@\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0007bCAe\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017D1\"a4\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002D\"I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0003S\u0004\u0001\u0015!\u0003\u0002V\"I\u00111\u001e\u0001A\u0002\u0013%\u0011Q\u0013\u0005\n\u0003[\u0004\u0001\u0019!C\u0005\u0003_Dq!a=\u0001A\u0003&\u0001\u000fC\u0005\u0002v\u0002\u0001\r\u0011\"\u0003\u0002,\"I\u0011q\u001f\u0001A\u0002\u0013%\u0011\u0011 \u0005\t\u0003{\u0004\u0001\u0015)\u0003\u0002.\"I\u0011q \u0001C\u0002\u0013%!\u0011\u0001\u0005\t\u0005\u0017\u0001\u0001\u0015!\u0003\u0003\u0004!I!Q\u0002\u0001C\u0002\u0013%!q\u0002\u0005\t\u0005g\u0001\u0001\u0015!\u0003\u0003\u0012!Y!1\t\u0001A\u0002\u0003\u0007I\u0011\u0002B#\u0011-\u0011i\u0005\u0001a\u0001\u0002\u0004%IAa\u0014\t\u0017\tM\u0003\u00011A\u0001B\u0003&!q\t\u0005\f\u0005+\u0002\u0001\u0019!a\u0001\n\u0013\u00119\u0006C\u0006\u0003f\u0001\u0001\r\u00111A\u0005\n\t\u001d\u0004b\u0003B6\u0001\u0001\u0007\t\u0011)Q\u0005\u00053B\u0011B!\u001c\u0001\u0005\u0004%IAa\u001c\t\u0011\tU\u0004\u0001)A\u0005\u0005cB\u0011Ba\u001e\u0001\u0005\u0004%IAa\u001c\t\u0011\te\u0004\u0001)A\u0005\u0005cB\u0011Ba\u001f\u0001\u0001\u0004%IA! \t\u0013\t\u0015\u0005\u00011A\u0005\n\t\u001d\u0005\u0002\u0003BF\u0001\u0001\u0006KAa \t\u000f\t5\u0005\u0001\"\u0011\u0003\u0010\"9!\u0011\u0013\u0001\u0005B\tM\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005k\u0003A\u0011\u0002B\\\u0011\u001d\u0011)\u000e\u0001C\u0005\u0005/DqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0003|\u0002!IAa$\t\u000f\tu\b\u0001\"\u0003\u0003\u0010\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0004\u0001\u0011\u00053\u0011\u0002\u0005\b\u0007'\u0001A\u0011\tBH\u0011\u001d\u0019)\u0002\u0001C!\u0007/Aqaa\r\u0001\t\u0003\u001a)\u0004C\u0004\u0004<\u0001!\te!\u0010\t\u000f\rU\u0003\u0001\"\u0011\u0004X!911\f\u0001\u0005B\ru\u0003bBB0\u0001\u0011\u00053\u0011\r\u0005\b\u0007_\u0002A\u0011IB9\u0011\u001d\u0019\u0019\t\u0001C!\u0007\u000bCqaa&\u0001\t\u0003\u001aI\nC\u0004\u0004\u001c\u0002!\te!(\b\u0013\r}u*!A\t\u0002\r\u0005f\u0001\u0003(P\u0003\u0003E\taa)\t\u000f\u0005M2\n\"\u0001\u0004,\"I1QV&\u0012\u0002\u0013\u00051q\u0016\u0002\u0017\u0011&4X-\u00128hS:,7i\u001c8o\u000bb,7-\u001e;pe*\u0011\u0001+U\u0001\tKb,7-\u001e;pe*\u0011!kU\u0001\u0005Q&4XM\u0003\u0002U+\u0006aQM\\4j]\u0016\u0004H.^4j]*\u0011akV\u0001\u0007Y&t7.[:\u000b\u0005aK\u0016AB1qC\u000eDWMC\u0001[\u0003\ry'oZ\u0002\u0001'\r\u0001Q\f\u001b\t\u0003=\u001al\u0011a\u0018\u0006\u0003A\u0006\fq!\u001a=fGV$XM\u0003\u0002QE*\u00111\rZ\u0001\fG>l\u0007/\u001e;bi&|gN\u0003\u0002f+\u0006QQM\\4j]\u0016\u001cwN\u001c8\n\u0005\u001d|&aE\"p[B,H/\u0019;j_:,\u00050Z2vi>\u0014\bCA5n\u001b\u0005Q'BA6m\u0003\u0019)g\u000e^5us*\u0011\u0001\u000bZ\u0005\u0003]*\u0014QCU3t_V\u00148-\u001a$fi\u000eDW\t_3dkR|'/\u0001\u0002jIB\u0011\u0011\u000f^\u0007\u0002e*\t1/A\u0003tG\u0006d\u0017-\u0003\u0002ve\n\u0019\u0011J\u001c;\u0002\u0019M,7o]5p]N#\u0018\r^3\u0011\u0007a\f\t!D\u0001z\u0015\tQ80A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005ql\u0018AA9m\u0015\t\u0011fP\u0003\u0002\u0000/\u00061\u0001.\u00193p_BL1!a\u0001z\u00051\u0019Vm]:j_:\u001cF/\u0019;f\u0003\r)x-\u001b\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002@\u0002\u0011M,7-\u001e:jifLA!!\u0005\u0002\f\t!Rk]3s\u000fJ|W\u000f]%oM>\u0014X.\u0019;j_:\f\u0001\u0002[5wK\u000e{gN\u001a\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D?\u0002\t\r|gNZ\u0005\u0005\u0003?\tIB\u0001\u0005ISZ,7i\u001c8g\u0003\u0011\u0011\u0017m\\:\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005\u0011\u0011n\u001c\u0006\u0003\u0003[\tAA[1wC&!\u0011\u0011GA\u0014\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\fa\u0001P5oSRtD\u0003DA\u001c\u0003w\ti$a\u0010\u0002B\u0005\r\u0003cAA\u001d\u00015\tq\nC\u0003p\r\u0001\u0007\u0001\u000fC\u0003w\r\u0001\u0007q\u000fC\u0004\u0002\u0006\u0019\u0001\r!a\u0002\t\u000f\u0005Ma\u00011\u0001\u0002\u0016!I\u0011\u0011\u0005\u0004\u0011\u0002\u0003\u0007\u00111E\u0001\u0004\u0019>;UCAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(3\u0006)1\u000f\u001c45U&!\u00111KA'\u0005\u0019aunZ4fe\u0006!AjT$!\u0003)q\u0017-\\3Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002l9!\u0011qLA4!\r\t\tG]\u0007\u0003\u0003GR1!!\u001a\\\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u000e:\u0002\rA\u0013X\rZ3g\u0013\u0011\ti'a\u001c\u0003\rM#(/\u001b8h\u0015\r\tIG]\u0001\f]\u0006lW\r\u0015:fM&D\b%\u0001\u0003qe>\u001cWCAA<!\u0011\tI(a \u000e\u0005\u0005m$bAA?w\u0006Q\u0001O]8dKN\u001cxN]:\n\t\u0005\u0005\u00151\u0010\u0002\u0011\u0007>lW.\u00198e!J|7-Z:t_J\f\u0001\u0002\u001d:pG~#S-\u001d\u000b\u0005\u0003\u000f\u000bi\tE\u0002r\u0003\u0013K1!a#s\u0005\u0011)f.\u001b;\t\u0013\u0005=E\"!AA\u0002\u0005]\u0014a\u0001=%c\u0005)\u0001O]8dA\u0005\u0019Q.\u00199\u0016\u0003A\fq!\\1q?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006m\u0005\u0002CAH\u001f\u0005\u0005\t\u0019\u00019\u0002\t5\f\u0007\u000fI\u0001\u0007e\u0016$WoY3\u0002\u0015I,G-^2f?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006\u0015\u0006\u0002CAH%\u0005\u0005\t\u0019\u00019\u0002\u000fI,G-^2fA\u0005IAo\u001c;bYR\u000b7o[\u000b\u0003\u0003[\u00032!]AX\u0013\r\t\tL\u001d\u0002\u0006\r2|\u0017\r^\u0001\u000bi>$\u0018\r\u001c+bg.\u0004\u0013AE:j]\u001edW\rT5oKB\u0013xn\u001a:fgN\fac]5oO2,G*\u001b8f!J|wM]3tg~#S-\u001d\u000b\u0005\u0003\u000f\u000bY\fC\u0005\u0002\u0010^\t\t\u00111\u0001\u0002.\u0006\u00192/\u001b8hY\u0016d\u0015N\\3Qe><'/Z:tA\u0005)RM\\4j]\u0016,\u00050Z2vi>\u00148i\u001c8uKb$XCAAb!\rq\u0016QY\u0005\u0004\u0003\u000f|&AF#oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u00023\u0015tw-\u001b8f\u000bb,7-\u001e;pe\u000e{g\u000e^3yi~#S-\u001d\u000b\u0005\u0003\u000f\u000bi\rC\u0005\u0002\u0010j\t\t\u00111\u0001\u0002D\u00061RM\\4j]\u0016,\u00050Z2vi>\u00148i\u001c8uKb$\b%A\ntS:<G.Z\"pI\u0016\u001cu.\u001c9mKR,G-\u0006\u0002\u0002VB!\u0011q[As\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017AB1u_6L7M\u0003\u0003\u0002`\u0006\u0005\u0018AC2p]\u000e,(O]3oi*!\u00111]A\u0016\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0018\u0011\u001c\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002)MLgn\u001a7f\u0007>$WmQ8na2,G/\u001a3!\u00039qW/\u001c2fe>3WJ\u0015&pEN\f!C\\;nE\u0016\u0014xJZ'S\u0015>\u00147o\u0018\u0013fcR!\u0011qQAy\u0011!\tyiHA\u0001\u0002\u0004\u0001\u0018a\u00048v[\n,'o\u00144N%*{'m\u001d\u0011\u0002%\r,(O]3oiN\u000bH\u000e\u0015:pOJ,7o]\u0001\u0017GV\u0014(/\u001a8u'Fd\u0007K]8he\u0016\u001c8o\u0018\u0013fcR!\u0011qQA~\u0011%\tyIIA\u0001\u0002\u0004\ti+A\ndkJ\u0014XM\u001c;Tc2\u0004&o\\4sKN\u001c\b%\u0001\u000btS:<G.Z*rYB\u0013xn\u001a:fgNl\u0015\r]\u000b\u0003\u0005\u0007\u0001\u0002B!\u0002\u0003\b\u0005m\u0013QV\u0007\u0003\u0003CLAA!\u0003\u0002b\n\u0019Q*\u00199\u0002+MLgn\u001a7f'Fd\u0007K]8he\u0016\u001c8/T1qA\u0005qQ\r_3dkR|'\u000fT1cK2\u001cXC\u0001B\t!\u0019\u0011)Aa\u0005\u0003\u0018%!!QCAq\u0005\u0011a\u0015n\u001d;1\t\te!q\u0006\t\u0007\u00057\u00119Ca\u000b\u000e\u0005\tu!bA6\u0003 )!!\u0011\u0005B\u0012\u0003\u0015a\u0017MY3m\u0015\r\u0011)#V\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\u0011IC!\b\u0003\u000b1\u000b'-\u001a7\u0011\t\t5\"q\u0006\u0007\u0001\t-\u0011\tdJA\u0001\u0002\u0003\u0015\tA!\u000e\u0003\u0007}#\u0013'A\bfq\u0016\u001cW\u000f^8s\u0019\u0006\u0014W\r\\:!#\u0011\u00119D!\u0010\u0011\u0007E\u0014I$C\u0002\u0003<I\u0014qAT8uQ&tw\rE\u0002r\u0005\u007fI1A!\u0011s\u0005\r\te._\u0001\u0007IJLg/\u001a:\u0016\u0005\t\u001d\u0003\u0003BA\u001d\u0005\u0013J1Aa\u0013P\u0005=A\u0015N^3Ee&4XM\u001d)s_bL\u0018A\u00033sSZ,'o\u0018\u0013fcR!\u0011q\u0011B)\u0011%\ty)KA\u0001\u0002\u0004\u00119%A\u0004ee&4XM\u001d\u0011\u0002\rQD'/Z1e+\t\u0011I\u0006\u0005\u0003\u0003\\\t\u0005TB\u0001B/\u0015\u0011\u0011y&a\u000b\u0002\t1\fgnZ\u0005\u0005\u0005G\u0012iF\u0001\u0004UQJ,\u0017\rZ\u0001\u000bi\"\u0014X-\u00193`I\u0015\fH\u0003BAD\u0005SB\u0011\"a$-\u0003\u0003\u0005\rA!\u0017\u0002\u000fQD'/Z1eA\u0005)\u0012\r\u001d9mS\u000e\fG/[8o'R\u0014\u0018N\\4OC6,WC\u0001B9!\u0011\u0011YFa\u001d\n\t\u00055$QL\u0001\u0017CB\u0004H.[2bi&|gn\u0015;sS:<g*Y7fA\u0005A1\u000f\u001d7jiR,'/A\u0005ta2LG\u000f^3sA\u0005y!/Z1e%\u0016\u001c()_(cU\u0016\u001cG/\u0006\u0002\u0003\u0000A\u0019\u0011O!!\n\u0007\t\r%OA\u0004C_>dW-\u00198\u0002'I,\u0017\r\u001a*fg\nKxJ\u00196fGR|F%Z9\u0015\t\u0005\u001d%\u0011\u0012\u0005\n\u0003\u001f\u001b\u0014\u0011!a\u0001\u0005\u007f\n\u0001C]3bIJ+7OQ=PE*,7\r\u001e\u0011\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u0003\u000f\u000b1\"\u001a=fGV$X\rT5oKR1!Q\u0013BS\u0005O\u0003BAa&\u0003\"6\u0011!\u0011\u0014\u0006\u0005\u00057\u0013i*\u0001\u0005fq\u0016\u001cW\u000f^3s\u0015\r\u0011y*V\u0001\ng\u000eDW\rZ;mKJLAAa)\u0003\u001a\nyQ\t_3dkR,'+Z:q_:\u001cX\rC\u0004\u0002@Z\u0002\r!a1\t\u000f\t%f\u00071\u0001\u0002\\\u0005!1m\u001c3f\u0003))\u00070Z2vi\u0016D\u0015\u000b\u0014\u000b\u0007\u0005+\u0013yKa-\t\u000f\tEv\u00071\u0001\u0002\\\u0005A!/Z1m\u0007>$W\rC\u0004\u0003D]\u0002\rAa\u0012\u0002\u001bM,g\u000e\u001a*fgVdGoU3u)\u001d\u0001(\u0011\u0018B^\u0005{Cq!a09\u0001\u0004\t\u0019\rC\u0004\u0003Da\u0002\rAa\u0012\t\u000f\t}\u0006\b1\u0001\u0003B\u0006AQ.\u001a;b\t\u0006$\u0018\r\u0005\u0003\u0003D\nEWB\u0001Bc\u0015\u0011\u00119M!3\u0002\u000bQ\f'\r\\3\u000b\t\t-'QZ\u0001\ne\u0016\u001cX\u000f\u001c;tKRT1Aa4V\u0003\u001d\u0019Ho\u001c:bO\u0016LAAa5\u0003F\niA+\u00192mK6+G/\u0019#bi\u0006\f\u0011cZ3u%\u0016\u001cX\u000f\u001c;NKR\fG)\u0019;b)\u0019\u0011\tM!7\u0003p\"9!1\\\u001dA\u0002\tu\u0017\u0001\u00044jK2$7k\u00195f[\u0006\u001c\bC\u0002B\u0003\u0005'\u0011y\u000e\u0005\u0003\u0003b\n-XB\u0001Br\u0015\u0011\u0011)Oa:\u0002\u0007\u0005\u0004\u0018NC\u0002\u0003jv\f\u0011\"\\3uCN$xN]3\n\t\t5(1\u001d\u0002\f\r&,G\u000eZ*dQ\u0016l\u0017\rC\u0004\u0003rf\u0002\rAa \u0002\u0019U\u001cX\rV1cY\u0016t\u0015-\\3\u0002\u001b%\u001chj\u001c*fgVdGoU9m)\u0011\u0011yHa>\t\u000f\te(\b1\u0001\u0002\\\u0005\u00191/\u001d7\u0002\u0015=t7i\\7qY\u0016$X-\u0001\u000bdY\u0016\f'oQ;se\u0016tG\u000f\u0015:pOJ,7o]\u0001\u000eUV\u001cHOR5fY\u0012t\u0015-\\3\u0015\t\u0005m31\u0001\u0005\b\u0007\u000bi\u0004\u0019AA.\u0003)\u00198\r[3nC:\u000bW.Z\u0001\u0012Kb,7-\u001e;f\u0007>l\u0007\u000f\\3uK2LH\u0003\u0003BK\u0007\u0017\u0019iaa\u0004\t\u000f\u0005}f\b1\u0001\u0002D\"9!\u0011\u0016 A\u0002\u0005m\u0003bBB\t}\u0001\u0007\u00111L\u0001\u000eG>l\u0007\u000f\\3uK\u0012d\u0015N\\3\u0002\u000b\rdwn]3\u0002\u001b\u0019+Go\u00195SKN|WO]2f+\t\u0019I\u0002\u0005\u0005\u0003\u0006\rm\u00111LB\u0010\u0013\u0011\u0019i\"!9\u0003\u000f!\u000b7\u000f['baB!1\u0011EB\u0018\u001b\t\u0019\u0019C\u0003\u0003\u0004&\r\u001d\u0012\u0001\u0003:fg>,(oY3\u000b\t\r%21F\u0001\taJ|Go\\2pY*!1Q\u0006B\u0012\u0003\u0019\u0019w.\\7p]&!1\u0011GB\u0012\u0005I\u0011Vm]8ve\u000e,w+\u001b;i'R\fG/^:\u0002\u0011A\u0014xn\u001a:fgN$B!!,\u00048!91\u0011H!A\u0002\u0005m\u0013A\u0002;bg.LE)A\bhKR\u0004&o\\4sKN\u001c\u0018J\u001c4p)\u0011\u0019yda\u0015\u0011\u000bE\u001c\te!\u0012\n\u0007\r\r#OA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0004H\r=SBAB%\u0015\u0011\u0019Ye!\u0014\u0002\r\u0015tw-\u001b8f\u0015\r\u0019I#V\u0005\u0005\u0007#\u001aIEA\bK_\n\u0004&o\\4sKN\u001c\u0018J\u001c4p\u0011\u001d\u0019ID\u0011a\u0001\u00037\n\u0001b[5mYR\u000b7o\u001b\u000b\u0005\u0003\u000f\u001bI\u0006C\u0004\u0004:\r\u0003\r!a\u0017\u0002'M,\b\u000f]8si\u000e\u000bG\u000e\u001c\"bG.dunZ:\u0015\u0005\t}\u0014!E4fi\u0016CXmY;u_Jd\u0015MY3mgR\u001111\r\t\u0007\u0005\u000b\u0011\u0019b!\u001a1\t\r\u001d41\u000e\t\u0007\u00057\u00119c!\u001b\u0011\t\t521\u000e\u0003\f\u0007[*\u0015\u0011!A\u0001\u0006\u0003\u0011)DA\u0002`IM\n\u0011c]3u\u000bb,7-\u001e;pe2\u000b'-\u001a7t)\u0011\t9ia\u001d\t\u000f\rUd\t1\u0001\u0004x\u00051A.\u00192fYN\u0004bA!\u0002\u0003\u0014\re\u0004\u0007BB>\u0007\u007f\u0002bAa\u0007\u0003(\ru\u0004\u0003\u0002B\u0017\u0007\u007f\"Ab!!\u0004t\u0005\u0005\t\u0011!B\u0001\u0005k\u00111a\u0018\u00135\u0003]\u0011X-];fgR,\u0005\u0010]3di\u0016$'+Z:pkJ\u001cW\r\u0006\u0003\u0004\b\u000eM\u0005\u0003BBE\u0007\u001fk!aa#\u000b\t\r\u00152Q\u0012\u0006\u0004W\u000e-\u0012\u0002BBI\u0007\u0017\u0013ABT8eKJ+7o\\;sG\u0016Dqa!&H\u0001\u0004\u00199)\u0001\tfqB,7\r^3e%\u0016\u001cx.\u001e:dK\u00061r-\u001a;DkJ\u0014XM\u001c;O_\u0012,'+Z:pkJ\u001cW\r\u0006\u0002\u0004\b\u0006)q-\u001a;JIR\u0011\u00111L\u0001\u0017\u0011&4X-\u00128hS:,7i\u001c8o\u000bb,7-\u001e;peB\u0019\u0011\u0011H&\u0014\u0007-\u001b)\u000bE\u0002r\u0007OK1a!+s\u0005\u0019\te.\u001f*fMR\u00111\u0011U\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\rE&\u0006BA\u0012\u0007g[#a!.\u0011\t\r]6\u0011Y\u0007\u0003\u0007sSAaa/\u0004>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u007f\u0013\u0018AC1o]>$\u0018\r^5p]&!11YB]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class HiveEngineConnExecutor
extends ComputationExecutor
implements ResourceFetchExecutor {
    private final int id;
    private final SessionState sessionState;
    private final UserGroupInformation ugi;
    private final HiveConf hiveConf;
    public final ByteArrayOutputStream org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos;
    private final Logger LOG;
    private final String namePrefix;
    private CommandProcessor proc;
    private int map;
    private int reduce;
    private final float totalTask;
    private float singleLineProgress;
    private EngineExecutionContext engineExecutorContext;
    private final AtomicBoolean singleCodeCompleted;
    private int numberOfMRJobs;
    private float currentSqlProgress;
    private final Map<String, Object> org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap;
    private final List<Label<?>> executorLabels;
    private HiveDriverProxy org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver;
    private Thread org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread;
    private final String applicationStringName;
    private final String splitter;
    private boolean readResByObject;

    public static ByteArrayOutputStream $lessinit$greater$default$5() {
        return HiveEngineConnExecutor$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger LOG() {
        return this.LOG;
    }

    private String namePrefix() {
        return this.namePrefix;
    }

    private CommandProcessor proc() {
        return this.proc;
    }

    private void proc_$eq(CommandProcessor x$1) {
        this.proc = x$1;
    }

    private int map() {
        return this.map;
    }

    private void map_$eq(int x$1) {
        this.map = x$1;
    }

    private int reduce() {
        return this.reduce;
    }

    private void reduce_$eq(int x$1) {
        this.reduce = x$1;
    }

    private float totalTask() {
        return this.totalTask;
    }

    private float singleLineProgress() {
        return this.singleLineProgress;
    }

    private void singleLineProgress_$eq(float x$1) {
        this.singleLineProgress = x$1;
    }

    private EngineExecutionContext engineExecutorContext() {
        return this.engineExecutorContext;
    }

    private void engineExecutorContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutorContext = x$1;
    }

    private AtomicBoolean singleCodeCompleted() {
        return this.singleCodeCompleted;
    }

    private int numberOfMRJobs() {
        return this.numberOfMRJobs;
    }

    private void numberOfMRJobs_$eq(int x$1) {
        this.numberOfMRJobs = x$1;
    }

    private float currentSqlProgress() {
        return this.currentSqlProgress;
    }

    private void currentSqlProgress_$eq(float x$1) {
        this.currentSqlProgress = x$1;
    }

    public Map<String, Object> org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    public HiveDriverProxy org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver;
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver_$eq(HiveDriverProxy x$1) {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver = x$1;
    }

    private Thread org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread;
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread_$eq(Thread x$1) {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread = x$1;
    }

    private String applicationStringName() {
        return this.applicationStringName;
    }

    private String splitter() {
        return this.splitter;
    }

    private boolean readResByObject() {
        return this.readResByObject;
    }

    private void readResByObject_$eq(boolean x$1) {
        this.readResByObject = x$1;
    }

    public void init() {
        this.LOG().info("Ready to change engine state!");
        Object object = BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_ENABLED().getValue()) ? System.setProperty("javax.security.auth.useSubjectCredsOnly", "false") : BoxedUnit.UNIT;
        this.setCodeParser((CodeParser)new SQLCodeParser());
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        this.readResByObject_$eq(MapUtils.getBooleanValue((Map)engineExecutorContext.getProperties(), (Object)JobRequestConstants$.MODULE$.LINKIS_HIVE_EC_READ_RESULT_BY_OBJECT(), (boolean)false));
        if (this.readResByObject()) {
            this.hiveConf.set("list.sink.output.formatter", "org.apache.hadoop.hive.serde2.thrift.ThriftFormatter");
        }
        this.engineExecutorContext_$eq(engineExecutorContext);
        CSHiveHelper$.MODULE$.setContextIDInfoToHiveConf(engineExecutorContext, this.hiveConf);
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        this.singleCodeCompleted().set(false);
        this.currentSqlProgress_$eq(0.0f);
        String realCode = code.trim();
        this.LOG().info(new StringBuilder(37).append("hive client begins to run hql code:\n ").append(realCode.trim()).toString());
        String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutorContext.getProperties());
        if (StringUtils.isNotBlank((CharSequence)jobId)) {
            String jobTags = JobUtils$.MODULE$.getJobSourceTagsFromObjectMap(engineExecutorContext.getProperties());
            String tags = StringUtils.isAsciiPrintable((CharSequence)jobTags) ? new StringBuilder(8).append("LINKIS_").append(jobId).append(",").append(jobTags).toString() : new StringBuilder(7).append("LINKIS_").append(jobId).toString();
            this.LOG().info(new StringBuilder(23).append("set mapreduce.job.tags=").append(tags).toString());
            this.hiveConf.set("mapreduce.job.tags", tags);
        }
        if (realCode.trim().length() > 500) {
            engineExecutorContext.appendStdout(new StringBuilder(8).append(this.getId()).append(" >> ").append(realCode.trim().substring(0, 500)).append(" ...").toString());
        } else {
            engineExecutorContext.appendStdout(new StringBuilder(4).append(this.getId()).append(" >> ").append(realCode.trim()).toString());
        }
        String[] tokens = realCode.trim().split("\\s+");
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        this.sessionState.setLastCommand(code);
        if (engineExecutorContext.getCurrentParagraph() == 1 && engineExecutorContext.getProperties().containsKey(JobRequestConstants$.MODULE$.LINKIS_JDBC_DEFAULT_DB())) {
            String defaultDB = (String)engineExecutorContext.getProperties().get(JobRequestConstants$.MODULE$.LINKIS_JDBC_DEFAULT_DB());
            this.logger().info(new StringBuilder(18).append("set default DB to ").append(defaultDB).toString());
            this.sessionState.setCurrentDatabase(defaultDB);
        }
        CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)this.hiveConf);
        this.proc_$eq(proc);
        this.LOG().debug(new StringBuilder(7).append("ugi is ").append(this.ugi.getUserName()).toString());
        return (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> (ExecuteResponse)$this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ExecuteResponse>(this, proc, realCode, tokens, engineExecutorContext){
            private final /* synthetic */ HiveEngineConnExecutor $outer;
            private final CommandProcessor proc$1;
            private final String realCode$1;
            private final String[] tokens$1;
            private final EngineExecutionContext engineExecutorContext$1;

            public ExecuteResponse run() {
                CommandProcessor commandProcessor = this.proc$1;
                if (HiveDriverProxy$.MODULE$.isDriver(commandProcessor)) {
                    this.$outer.logger().info(new StringBuilder(10).append("driver is ").append(commandProcessor).toString());
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread_$eq(Thread.currentThread());
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver_$eq(new HiveDriverProxy(commandProcessor));
                    return this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$executeHQL(this.realCode$1, this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver());
                }
                CommandProcessorResponse resp = this.proc$1.run(this.realCode$1.substring(this.tokens$1[0].length()).trim());
                String result = new String(this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos.toByteArray());
                this.$outer.logger().info("RESULT => {}", new Object[]{result});
                this.engineExecutorContext$1.appendStdout(result);
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos.reset();
                if (resp.getResponseCode() != 0) {
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
                    HiveProgressHelper$.MODULE$.clearHiveProgress();
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                    throw resp.getException();
                }
                HiveProgressHelper$.MODULE$.clearHiveProgress();
                HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                return new SuccessExecuteResponse();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.proc$1 = proc$1;
                this.realCode$1 = realCode$1;
                this.tokens$1 = tokens$1;
                this.engineExecutorContext$1 = engineExecutorContext$1;
            }
        }), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver() != null) {
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().close();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver_$eq(null);
                    SessionState ss = SessionState.get();
                    if (ss != null) {
                        ss.deleteTmpOutputFile();
                        ss.deleteTmpErrOutputFile();
                        return;
                    }
                });
                return;
            }
        });
    }

    public ExecuteResponse org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$executeHQL(String realCode, HiveDriverProxy driver) {
        boolean needRetry = true;
        int tryCount = 0;
        boolean hasResult = false;
        int rows = 0;
        int columnCount = 0;
        while (needRetry) {
            needRetry = false;
            driver.setTryCount(tryCount + 1);
            long startTime = System.currentTimeMillis();
            try {
                List list;
                CommandProcessorResponse hiveResponse;
                CommandProcessorResponse commandProcessorResponse;
                if (!HiveDriverProxy$.MODULE$.isIDriver(driver.getDriver())) {
                    IntRef compileRet = IntRef.create((int)-1);
                    Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        compileRet$1.elem = driver.compile(realCode);
                        this.logger().info(new StringBuilder(50).append("driver compile realCode : \n ").append(realCode).append(" \n finished, status : ").append(compileRet$1.elem).toString());
                        if (0 != compileRet$1.elem) {
                            this.logger().warn(new StringBuilder(39).append("compile realCode : \n ").append(realCode).append(" \n error status : ").append(compileRet$1.elem).toString());
                            throw new HiveQueryFailedException(HiveErrorCodeSummary.COMPILE_HIVE_QUERY_ERROR.getErrorCode(), HiveErrorCodeSummary.COMPILE_HIVE_QUERY_ERROR.getErrorDesc());
                        }
                        QueryPlan queryPlan = driver.getPlan();
                        int numberOfJobs = Utilities.getMRTasks((List)queryPlan.getRootTasks()).size();
                        this.numberOfMRJobs_$eq(numberOfJobs);
                        this.logger().info(new StringBuilder(16).append("there are ").append(this.numberOfMRJobs()).append(" jobs.").toString());
                    }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        HiveEngineConnExecutor.$anonfun$executeHQL$2(this, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (this.numberOfMRJobs() > 0) {
                        this.engineExecutorContext().appendStdout(new StringBuilder(32).append("Your hive sql has ").append(this.numberOfMRJobs()).append(" MR jobs to do").toString());
                    }
                    if (this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$thread().isInterrupted()) {
                        this.logger().error("The thread of execution has been interrupted and the task should be terminated");
                        return new ErrorExecuteResponse("The thread of execution has been interrupted and the task should be terminated", null);
                    }
                    commandProcessorResponse = driver.run(realCode, compileRet.elem == 0);
                } else {
                    commandProcessorResponse = hiveResponse = driver.run(realCode);
                }
                if (hiveResponse.getResponseCode() != 0) {
                    this.LOG().error("Hive query failed, response code is {}", (Object)BoxesRunTime.boxToInteger((int)hiveResponse.getResponseCode()));
                    return new ErrorExecuteResponse(hiveResponse.getErrorMessage(), hiveResponse.getException());
                }
                this.engineExecutorContext().appendStdout(new StringBuilder(37).append("Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", begin to fetch results.").toString());
                this.LOG().info(new StringBuilder(41).append(this.getId()).append(" >> Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", begin to fetch results.").toString());
                if (hiveResponse.getSchema() != null) {
                    list = hiveResponse.getSchema().getFieldSchemas();
                } else if (driver.getSchema() != null) {
                    list = driver.getSchema().getFieldSchemas();
                } else {
                    throw new HiveQueryFailedException(HiveErrorCodeSummary.GET_FIELD_SCHEMAS_ERROR.getErrorCode(), HiveErrorCodeSummary.GET_FIELD_SCHEMAS_ERROR.getErrorDesc());
                }
                List fieldSchemas = list;
                this.LOG().debug(new StringBuilder(17).append("fieldSchemas are ").append(fieldSchemas).toString());
                if (fieldSchemas == null || this.isNoResultSql(realCode)) {
                    this.numberOfMRJobs_$eq(-1);
                    this.singleCodeCompleted().set(true);
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    return new SuccessExecuteResponse();
                }
                TableMetaData metaData = this.getResultMetaData(fieldSchemas, this.engineExecutorContext().getEnableResultsetMetaWithTableName());
                rows = this.sendResultSet(this.engineExecutorContext(), driver, metaData);
                columnCount = fieldSchemas != null ? fieldSchemas.size() : 0;
                hasResult = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (HiveDriverProxy$.MODULE$.isCommandNeedRetryException(throwable2)) {
                    ++tryCount;
                    needRetry = true;
                    HiveProgressHelper$.MODULE$.clearHiveProgress();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
                    HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                    this.LOG().warn("Retry hive query with a different approach...");
                    continue;
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.LOG().error("query failed, reason : ", throwable3);
                    HiveProgressHelper$.MODULE$.clearHiveProgress();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
                    HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
                    this.singleCodeCompleted().set(true);
                    this.numberOfMRJobs_$eq(-1);
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
                    return new ErrorExecuteResponse(throwable3.getMessage(), throwable3);
                }
                throw throwable;
            }
        }
        if (hasResult) {
            this.engineExecutorContext().appendStdout(new StringBuilder(34).append("Fetched  ").append(columnCount).append(" col(s) : ").append(rows).append(" row(s) in hive").toString());
            this.LOG().info(new StringBuilder(38).append(this.getId()).append(" >> Fetched  ").append(columnCount).append(" col(s) : ").append(rows).append(" row(s) in hive").toString());
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
        HiveProgressHelper$.MODULE$.clearHiveProgress();
        HiveProgressHelper$.MODULE$.storeSingleSQLProgress(0.0f);
        this.singleCodeCompleted().set(true);
        this.numberOfMRJobs_$eq(-1);
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        return new SuccessExecuteResponse();
    }

    private int sendResultSet(EngineExecutionContext engineExecutorContext, HiveDriverProxy driver, TableMetaData metaData) {
        ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
        resultSetWriter.addMetaData((MetaData)metaData);
        int colLength = metaData.columns().length;
        ArrayList result = new ArrayList();
        int rows = 0;
        while (driver.getResults(result)) {
            Buffer scalaResult = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala();
            scalaResult.foreach((Function1 & Serializable & scala.Serializable)s -> {
                HiveEngineConnExecutor.$anonfun$sendResultSet$1(this, colLength, resultSetWriter, s);
                return BoxedUnit.UNIT;
            });
            rows += result.size();
            result.clear();
        }
        engineExecutorContext.sendResultSet(resultSetWriter);
        return rows;
    }

    private TableMetaData getResultMetaData(List<FieldSchema> fieldSchemas, boolean useTableName) {
        List<FieldSchema> results = null;
        HashSet nameSet = new HashSet();
        ArrayList<FieldSchema> cleanSchema = new ArrayList<FieldSchema>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchemas).asScala()).foreach((Function1 & Serializable & scala.Serializable)fieldSchema -> {
            String name = fieldSchema.getName();
            if (new StringOps(Predef$.MODULE$.augmentString(name)).split('.').length == 2) {
                nameSet.add((Object)new StringOps(Predef$.MODULE$.augmentString(name)).split('.')[1]);
                return ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)cleanSchema).asScala()).$plus$eq((Object)new FieldSchema(new StringOps(Predef$.MODULE$.augmentString(name)).split('.')[1], fieldSchema.getType(), fieldSchema.getComment()));
            }
            return BoxedUnit.UNIT;
        });
        results = nameSet.size() < ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchemas).asScala()).length() ? fieldSchemas : (useTableName ? fieldSchemas : cleanSchema);
        Column[] columns = (Column[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results).asScala()).map((Function1 & Serializable & scala.Serializable)result -> new Column(result.getName(), DataType$.MODULE$.toDataType(result.getType().toLowerCase()), result.getComment()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        TableMetaData metaData = new TableMetaData(columns);
        return metaData;
    }

    private boolean isNoResultSql(String sql) {
        return sql.trim().startsWith("create table") || sql.trim().startsWith("drop table");
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$onComplete() {
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress() {
        this.reduce_$eq(0);
        this.map_$eq(0);
        this.singleLineProgress_$eq(0.0f);
    }

    private String justFieldName(String schemaName) {
        this.LOG().debug(new StringBuilder(12).append("schemaName: ").append(schemaName).toString());
        String[] arr = schemaName.split("\\.");
        if (arr.length == 2) {
            return arr[1];
        }
        return schemaName;
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        String completeCode = new StringBuilder(0).append(code).append(completedLine).toString();
        return this.executeLine(engineExecutorContext, completeCode);
    }

    public void close() {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.sessionState.close(), "close session failed", this.logger());
        super.close();
    }

    public HashMap<String, ResourceWithStatus> FetchResource() {
        HashMap<String, ResourceWithStatus> resourceMap = new HashMap<String, ResourceWithStatus>();
        String queue = this.hiveConf.get("mapreduce.job.queuename");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HadoopJobExecHelper.runningJobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)yarnJob -> {
            Counters counters = yarnJob.getCounters();
            if (counters != null) {
                long millsMap = counters.getCounter((Enum)Counters$.MODULE$.MILLIS_MAPS());
                long millsReduces = counters.getCounter((Enum)Counters$.MODULE$.MILLIS_REDUCES());
                long totalMapCores = counters.getCounter((Enum)Counters$.MODULE$.VCORES_MILLIS_MAPS());
                long totalReducesCores = counters.getCounter((Enum)Counters$.MODULE$.VCORES_MILLIS_REDUCES());
                long totalMapMBMemory = counters.getCounter((Enum)Counters$.MODULE$.MB_MILLIS_MAPS());
                long totalReducesMBMemory = counters.getCounter((Enum)Counters$.MODULE$.MB_MILLIS_REDUCES());
                int avgCores = 0;
                long avgMemory = 0L;
                if (millsMap > 0L && millsReduces > 0L) {
                    avgCores = (int)Math.ceil(totalMapCores / millsMap + totalReducesCores / millsReduces);
                    avgMemory = (long)Math.ceil(totalMapMBMemory * 1024L * 1024L / millsMap + totalReducesMBMemory * 1024L * 1024L / millsReduces);
                    ResourceWithStatus yarnResource = new ResourceWithStatus(avgMemory, avgCores, 0, JobStatus.getJobRunState((int)yarnJob.getJobStatus().getRunState()), queue);
                    String applicationId = new StringBuilder(0).append(this.applicationStringName()).append(this.splitter()).append(yarnJob.getID().getJtIdentifier()).append(this.splitter()).append(yarnJob.getID().getId()).toString();
                    return resourceMap.put(applicationId, yarnResource);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return resourceMap;
    }

    public float progress(String taskID) {
        if (this.engineExecutorContext() != null) {
            int hiveRunJobs;
            RunningJob runningJob;
            float _progress;
            int totalSQLs = this.engineExecutorContext().getTotalParagraph();
            int currentSQL = this.engineExecutorContext().getCurrentParagraph();
            float currentBegin = (float)(currentSQL - 1) / (float)totalSQLs;
            int finishedStage = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver() != null && this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().getPlan() != null && !this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().getPlan().getRootTasks().isEmpty() ? BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Utilities.getMRTasks((List)this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().getPlan().getRootTasks())).asScala()).count((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)HiveEngineConnExecutor.$anonfun$progress$2(task))))) : 0;
            float totalProgress = 0.0f;
            if (!HadoopJobExecHelper.runningJobs.isEmpty() && !Float.isNaN(_progress = BoxesRunTime.unboxToFloat((Object)Utils$.MODULE$.tryCatch((Function0)((JFunction0.mcF.sp & Serializable & scala.Serializable)() -> HiveEngineConnExecutor.$anonfun$progress$3(runningJob = (RunningJob)HadoopJobExecHelper.runningJobs.get(0))), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToFloat((float)HiveEngineConnExecutor.$anonfun$progress$4(this, runningJob, x0$1)))))) {
                totalProgress = _progress / (float)2;
            }
            this.logger().info(new StringBuilder(51).append("Running stage  progress is ").append(totalProgress).append(", and finished stage is ").append(finishedStage).toString());
            int n = hiveRunJobs = this.numberOfMRJobs() <= 0 ? 1 : this.numberOfMRJobs();
            if (finishedStage <= hiveRunJobs) {
                totalProgress += (float)finishedStage;
            }
            try {
                totalProgress /= (float)(hiveRunJobs * totalSQLs);
            }
            catch (Exception e) {
                totalProgress = 0.0f;
            }
            catch (Throwable throwable) {
                totalProgress = 0.0f;
            }
            float newProgress = Float.isNaN(totalProgress) || Float.isInfinite(totalProgress) ? currentBegin : totalProgress + currentBegin;
            this.logger().info(new StringBuilder(41).append("Hive progress is ").append(newProgress).append(", and finished stage is ").append(finishedStage).toString());
            float oldProgress = ProgressUtils$.MODULE$.getOldProgress(this.engineExecutorContext());
            if (newProgress < oldProgress) {
                return oldProgress;
            }
            ProgressUtils$.MODULE$.putProgress(newProgress, this.engineExecutorContext());
            return newProgress;
        }
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        Map<String, Object> map = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap();
        synchronized (map) {
            Set<String> set = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().keySet();
            java.util.HashSet tempSet = new java.util.HashSet(HadoopJobExecHelper.runningJobs);
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(set).asScala()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                if (!tempSet.contains(key)) {
                    return arrayBuffer.$plus$eq((Object)new JobProgressInfo(key, 200, 0, 0, 200));
                }
                return BoxedUnit.UNIT;
            });
        }
        List list = HadoopJobExecHelper.runningJobs;
        synchronized (list) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HadoopJobExecHelper.runningJobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)runningJob -> {
                int succeedTask = (int)((runningJob.mapProgress() + runningJob.reduceProgress()) * (float)100);
                if (((Object)BoxesRunTime.boxToInteger((int)succeedTask)).equals(BoxesRunTime.boxToInteger((int)((int)this.totalTask()))) || runningJob.isComplete() || runningJob.isSuccessful()) {
                    return arrayBuffer.$plus$eq((Object)new JobProgressInfo(runningJob.getID().toString(), (int)this.totalTask(), 0, 0, (int)this.totalTask()));
                }
                return arrayBuffer.$plus$eq((Object)new JobProgressInfo(runningJob.getID().toString(), (int)this.totalTask(), 1, 0, succeedTask));
            });
        }
        return (JobProgressInfo[])arrayBuffer.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public void killTask(String taskID) {
        this.LOG().info(new StringBuilder(34).append("hive begins to kill job with id : ").append(taskID).toString());
        this.LOG().info(new StringBuilder(18).append("hive engine type :").append(HiveEngineConfiguration$.MODULE$.HIVE_ENGINE_TYPE()).toString());
        String string = HiveEngineConfiguration$.MODULE$.HIVE_ENGINE_TYPE();
        if ("mr".equals(string)) {
            HadoopJobExecHelper.killRunningJobs();
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> HiveInterruptUtils.interrupt());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().close(), this.logger());
        } else if ("tez".equals(string)) {
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TezJobExecHelper.killRunningJobs());
            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$driver().close();
        } else {
            throw new MatchError((Object)string);
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$clearCurrentProgress();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap().clear();
        HiveProgressHelper$.MODULE$.clearHiveProgress();
        this.LOG().info("hive killed job successfully");
        super.killTask(taskID);
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils$.MODULE$.applyAsLoadInstanceResource(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions()));
        return resource;
    }

    public String getId() {
        return new StringBuilder(0).append(this.namePrefix()).append(this.id).toString();
    }

    public static final /* synthetic */ void $anonfun$executeHQL$2(HiveEngineConnExecutor $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().warn("obtain hive execute query plan failed,", (Throwable)exception);
            return;
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            $this.logger().warn("obtain hive execute query plan failed,", throwable2);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$sendResultSet$1(HiveEngineConnExecutor $this, int colLength$1, ResultSetWriter resultSetWriter$1, Object s) {
        if (!$this.readResByObject()) {
            String[] arr = ((String)s).split("\t");
            ArrayBuffer arrAny = new ArrayBuffer();
            if (arr.length > colLength$1) {
                $this.logger().error("There is a \t tab in the result of hive code query, hive cannot cut it, please use spark to execute(\u67e5\u8be2\u7684\u7ed3\u679c\u4e2d\u6709\t\u5236\u8868\u7b26\uff0chive\u4e0d\u80fd\u8fdb\u884c\u5207\u5272,\u8bf7\u4f7f\u7528spark\u6267\u884c)");
                throw new ErrorException(60078, "There is a \\t tab in the result of your query, hive cannot cut it, please use spark to execute(\u60a8\u67e5\u8be2\u7684\u7ed3\u679c\u4e2d\u6709\\t\u5236\u8868\u7b26\uff0chive\u4e0d\u80fd\u8fdb\u884c\u5207\u5272,\u8bf7\u4f7f\u7528spark\u6267\u884c)");
            }
            if (arr.length == colLength$1) {
                arrAny.appendAll((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)));
            } else if (arr.length == 0) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), colLength$1).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava()).add(""));
            } else {
                int i2 = colLength$1 - arr.length;
                List list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), i2).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava()).add(""));
            }
            resultSetWriter$1.addRecord((Record)new TableRecord((Object[])arrAny.toArray(ClassTag$.MODULE$.Any())));
            return;
        }
        resultSetWriter$1.addRecord((Record)new TableRecord((Object[])s));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$progress$2(ExecDriver task) {
        if (!task.isMapRedTask()) return false;
        Task.TaskState taskState = task.getTaskState();
        Task.TaskState taskState2 = Task.TaskState.FINISHED;
        if (taskState != null) {
            if (!taskState.equals(taskState2)) return false;
            return true;
        }
        if (taskState2 == null) return true;
        return false;
    }

    public static final /* synthetic */ float $anonfun$progress$3(RunningJob runningJob$1) {
        return runningJob$1.reduceProgress() + runningJob$1.mapProgress();
    }

    public static final /* synthetic */ float $anonfun$progress$4(HiveEngineConnExecutor $this, RunningJob runningJob$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().info(new StringBuilder(29).append("Failed to get job(").append(runningJob$1.getJobName()).append(") progress ").toString(), (Throwable)exception);
            return 0.2f;
        }
        throw new MatchError((Object)throwable);
    }

    public HiveEngineConnExecutor(int id, SessionState sessionState, UserGroupInformation ugi, HiveConf hiveConf, ByteArrayOutputStream baos) {
        this.id = id;
        this.sessionState = sessionState;
        this.ugi = ugi;
        this.hiveConf = hiveConf;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$baos = baos;
        super(ComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.LOG = LoggerFactory.getLogger((Class)this.getClass());
        this.namePrefix = "HiveEngineExecutor_";
        this.map = 0;
        this.reduce = 0;
        this.totalTask = 200.0f;
        this.singleLineProgress = 0.0f;
        this.singleCodeCompleted = new AtomicBoolean(false);
        this.numberOfMRJobs = 0;
        this.currentSqlProgress = 0.0f;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConnExecutor$$singleSqlProgressMap = new HashMap<String, Object>();
        this.executorLabels = new ArrayList();
        this.applicationStringName = "application";
        this.splitter = "_";
        this.readResByObject = false;
    }
}

