/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.route;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.errorcode.LinkisGatewayCoreErrorCodeSummary;
import org.apache.linkis.gateway.exception.TooManyServiceException;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.route.AbstractGatewayRouter;
import org.apache.linkis.gateway.route.GatewayRouter;
import org.apache.linkis.rpc.interceptor.ServiceInstanceUtils$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001Q3A\u0001C\u0005\u0001)!A\u0011\u0004\u0001BA\u0002\u0013\u0005!\u0004\u0003\u0005%\u0001\t\u0005\r\u0011\"\u0001&\u0011!Y\u0003A!A!B\u0013Y\u0002\"\u0002\u0017\u0001\t\u0003i\u0003\"\u0002\u0019\u0001\t\u0013\t\u0004\"\u0002\"\u0001\t#\u0019\u0005\"\u0002\u0006\u0001\t\u0003\u0012&\u0001\u0006#fM\u0006,H\u000e^$bi\u0016<\u0018-\u001f*pkR,'O\u0003\u0002\u000b\u0017\u0005)!o\\;uK*\u0011A\"D\u0001\bO\u0006$Xm^1z\u0015\tqq\"\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u0018\u001b\u0005I\u0011B\u0001\r\n\u0005U\t%m\u001d;sC\u000e$x)\u0019;fo\u0006L(k\\;uKJ\fabZ1uK^\f\u0017PU8vi\u0016\u00148/F\u0001\u001c!\rar$I\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t)\u0011I\u001d:bsB\u0011aCI\u0005\u0003G%\u0011QbR1uK^\f\u0017PU8vi\u0016\u0014\u0018AE4bi\u0016<\u0018-\u001f*pkR,'o]0%KF$\"AJ\u0015\u0011\u0005q9\u0013B\u0001\u0015\u001e\u0005\u0011)f.\u001b;\t\u000f)\u0012\u0011\u0011!a\u00017\u0005\u0019\u0001\u0010J\u0019\u0002\u001f\u001d\fG/Z<bsJ{W\u000f^3sg\u0002\na\u0001P5oSRtDC\u0001\u00180!\t1\u0002\u0001C\u0003\u001a\t\u0001\u00071$A\tgS:$7i\\7n_:\u001cVM\u001d<jG\u0016$\"A\r!\u0011\u0007q\u0019T'\u0003\u00025;\t1q\n\u001d;j_:\u0004\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d\u001e\u001b\u0005I$B\u0001\u001e\u0014\u0003\u0019a$o\\8u}%\u0011A(H\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=;!)\u0011)\u0002a\u0001k\u0005y\u0001/\u0019:tK\u0012\u001cVM\u001d<jG\u0016LE-A\tgS:$'+Z1mYf\u001cVM\u001d<jG\u0016$\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dk\u0011AB2p[6|g.\u0003\u0002J\r\ny1+\u001a:wS\u000e,\u0017J\\:uC:\u001cW\rC\u0003L\r\u0001\u0007A*\u0001\bhCR,w/Y=D_:$X\r\u001f;\u0011\u00055\u0003V\"\u0001(\u000b\u0005=[\u0011\u0001\u00025uiBL!!\u0015(\u0003\u001d\u001d\u000bG/Z<bs\u000e{g\u000e^3yiR\u0011Ai\u0015\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014")
public class DefaultGatewayRouter
extends AbstractGatewayRouter {
    private GatewayRouter[] gatewayRouters;

    public GatewayRouter[] gatewayRouters() {
        return this.gatewayRouters;
    }

    public void gatewayRouters_$eq(GatewayRouter[] x$1) {
        this.gatewayRouters = x$1;
    }

    private Option<String> findCommonService(String parsedServiceId) {
        return this.findService(parsedServiceId, (Function1<List<String>, Option<String>>)(Function1 & Serializable & scala.Serializable)services -> {
            TooManyServiceException errorMsg = new TooManyServiceException(MessageFormat.format(LinkisGatewayCoreErrorCodeSummary.CANNOT_SERVICEID.getErrorDesc(), parsedServiceId, services));
            this.logger().warn("", (Throwable)((Object)errorMsg));
            throw errorMsg;
        });
    }

    public ServiceInstance findReallyService(GatewayContext gatewayContext) {
        ObjectRef serviceInstance = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gatewayRouters())).withFilter((Function1 & Serializable & scala.Serializable)router -> BoxesRunTime.boxToBoolean((boolean)DefaultGatewayRouter.$anonfun$findReallyService$1(serviceInstance, router))).foreach((Function1 & Serializable & scala.Serializable)router -> {
            serviceInstance.elem = router.route(gatewayContext);
            return BoxedUnit.UNIT;
        });
        if ((ServiceInstance)serviceInstance.elem == null) {
            serviceInstance.elem = gatewayContext.getGatewayRoute().getServiceInstance();
        }
        Option<String> service = this.findAndRefreshIfNotExists(((ServiceInstance)serviceInstance.elem).getApplicationName(), (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.findCommonService(((ServiceInstance)serviceInstance$2.elem).getApplicationName()));
        return (ServiceInstance)service.map((Function1 & Serializable & scala.Serializable)applicationName -> {
            if (StringUtils.isNotBlank((CharSequence)((ServiceInstance)serviceInstance$2.elem).getInstance())) {
                ServiceInstance _serviceInstance = ServiceInstance$.MODULE$.apply(applicationName, ((ServiceInstance)serviceInstance$2.elem).getInstance());
                if (this.enabledRefresh()) {
                    ServiceInstanceUtils$.MODULE$.getRPCServerLoader().getOrRefreshServiceInstance(_serviceInstance);
                }
                return _serviceInstance;
            }
            return ServiceInstance$.MODULE$.apply(applicationName, null);
        }).get();
    }

    @Override
    public ServiceInstance route(GatewayContext gatewayContext) {
        ServiceInstance serviceInstance;
        Object object = new Object();
        try {
            if (gatewayContext.getGatewayRoute().getServiceInstance() != null) {
                ServiceInstance serviceInstance2;
                String parsedService = gatewayContext.getGatewayRoute().getServiceInstance().getApplicationName();
                serviceInstance = serviceInstance2 = (ServiceInstance)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.findReallyService(gatewayContext), (Function1 & Serializable & scala.Serializable)t -> {
                    Message message = Message$.MODULE$.error(ExceptionUtils.getRootCauseMessage((Throwable)t)).$less$less(gatewayContext.getRequest().getRequestURI());
                    message.data("data", (Object)gatewayContext.getRequest().getRequestBody());
                    this.logger().warn("", t);
                    if (gatewayContext.isWebSocketRequest()) {
                        gatewayContext.getResponse().writeWebSocket(Message$.MODULE$.response(message));
                    } else {
                        gatewayContext.getResponse().write(Message$.MODULE$.response(message));
                    }
                    gatewayContext.getResponse().sendResponse();
                    throw new NonLocalReturnControl(object, null);
                });
            } else {
                serviceInstance = null;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                serviceInstance = (ServiceInstance)ex.value();
            }
            throw ex;
        }
        return serviceInstance;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(GatewayRouter x) {
        return x != null;
    }

    public static final /* synthetic */ boolean $anonfun$new$2(GatewayRouter left, GatewayRouter right) {
        return left.order() < right.order();
    }

    public static final /* synthetic */ boolean $anonfun$findReallyService$1(ObjectRef serviceInstance$2, GatewayRouter router) {
        return (ServiceInstance)serviceInstance$2.elem == null;
    }

    public DefaultGatewayRouter(GatewayRouter[] gatewayRouters) {
        block0: {
            this.gatewayRouters = gatewayRouters;
            if (this.gatewayRouters() == null || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gatewayRouters())).nonEmpty()) break block0;
            GatewayRouter[] notNullRouters = (GatewayRouter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gatewayRouters())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DefaultGatewayRouter.$anonfun$new$1(x)));
            this.gatewayRouters_$eq((GatewayRouter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])notNullRouters)).sortWith((Function2 & Serializable & scala.Serializable)(left, right) -> BoxesRunTime.boxToBoolean((boolean)DefaultGatewayRouter.$anonfun$new$2(left, right))));
        }
    }
}

