/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.builder;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.linkis.manager.label.builder.ExtensibleLabelBuilder;
import org.apache.linkis.manager.label.entity.CloneableLabel;
import org.apache.linkis.manager.label.entity.InheritableLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericLabelBuilder
implements ExtensibleLabelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGenericLabelBuilder.class);

    protected <V> V transformValueToConcreteType(Object rawValue, Type concreteType, Type[] parameterTypes, Function<String, V> deserializer) {
        if (null != rawValue) {
            try {
                Class<?> sourceClass = rawValue.getClass();
                Class concreteClass = (Class)concreteType;
                if (concreteClass.isAssignableFrom(sourceClass)) {
                    if (CloneableLabel.class.isAssignableFrom(sourceClass)) {
                        return (V)((CloneableLabel)rawValue).clone();
                    }
                } else {
                    if (LabelUtils.isBasicType(concreteClass)) {
                        return (V)LabelUtils.Jackson.convert(LabelUtils.Jackson.toJson(rawValue, null), concreteClass, new Class[0]);
                    }
                    if (LabelUtils.isBasicType(rawValue.getClass())) {
                        String rawString = String.valueOf(rawValue);
                        if (null != deserializer) {
                            return deserializer.apply(rawString);
                        }
                        JavaType javaType = this.getJavaType(concreteType, parameterTypes);
                        if (concreteClass.equals(Map.class)) {
                            try {
                                return (V)LabelUtils.Jackson.convert(LabelUtils.Jackson.fromJson(rawString, Map.class, Object.class, Object.class), javaType);
                            }
                            catch (Exception e) {
                                LOG.trace("Transform raw value fail, return empty object", (Throwable)e);
                                return (V)LabelUtils.Jackson.fromJson("{}", javaType);
                            }
                        }
                        if (concreteClass.equals(List.class)) {
                            try {
                                return (V)LabelUtils.Jackson.convert(LabelUtils.Jackson.fromJson(rawString, List.class, Object.class), javaType);
                            }
                            catch (Exception e) {
                                LOG.trace("Transform raw value fail, return empty list", (Throwable)e);
                                return (V)LabelUtils.Jackson.fromJson("[]", javaType);
                            }
                        }
                    }
                }
                return (V)LabelUtils.Jackson.convert(rawValue, this.getJavaType(concreteType, parameterTypes));
            }
            catch (Exception e) {
                LOG.trace("Transform raw value fail, return null", (Throwable)e);
            }
        }
        return null;
    }

    public Class<?>[] findActualLabelValueClass(Class<? extends Label> labelClass) {
        HashMap classTypeVariableMap = new HashMap();
        Type[] classTypes = this.recurseToFindActualLabelValueType(labelClass, classTypeVariableMap);
        if (null != classTypes) {
            ArrayList<Class<Object>> classesReturn = new ArrayList<Class<Object>>();
            for (Type classType : classTypes = this.expandParameterizedType(classTypes)) {
                if (classType instanceof Class) {
                    classesReturn.add((Class)classType);
                    continue;
                }
                if (!(classType instanceof WildcardType)) continue;
                classesReturn.add(Object.class);
            }
            return classesReturn.toArray(new Class[0]);
        }
        return null;
    }

    public Type[] findActualLabelValueType(Class<? extends Label> labelType) {
        HashMap classTypeVariableMap = new HashMap();
        return this.recurseToFindActualLabelValueType(labelType, classTypeVariableMap);
    }

    private Type[] recurseToFindActualLabelValueType(Class<? extends Label> labelClass, Map<Class<?>, Type[]> classTypeVariableMap) {
        if (null == labelClass) {
            return null;
        }
        HashMap<String, Type> typeVariableReflect = new HashMap<String, Type>();
        TypeVariable<Class<? extends Label>>[] typeParameters = labelClass.getTypeParameters();
        if (typeParameters.length > 0) {
            Type[] classTypes = classTypeVariableMap.get(labelClass);
            if (null == classTypes) {
                return null;
            }
            for (int i = 0; i < classTypes.length; ++i) {
                typeVariableReflect.put(typeParameters[i].getTypeName(), classTypes[i]);
            }
        }
        if (labelClass.equals(Label.class) || labelClass.equals(InheritableLabel.class)) {
            return classTypeVariableMap.get(labelClass);
        }
        Type[] valueTypes = this.findValueTypeFromInterface(labelClass, classTypeVariableMap, typeVariableReflect);
        if (null == valueTypes) {
            valueTypes = this.findValueTypeFromSuperclass(labelClass, classTypeVariableMap, typeVariableReflect);
        }
        return valueTypes;
    }

    private Type[] findValueTypeFromInterface(Class<? extends Label> labelClass, Map<Class<?>, Type[]> classTypeVariableMap, Map<String, Type> typeVariableReflect) {
        Class<?>[] interfaces = labelClass.getInterfaces();
        if (interfaces.length > 0) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> interfaceClass = interfaces[i];
                if (!Label.class.isAssignableFrom(interfaceClass)) continue;
                Type interfaceType = labelClass.getGenericInterfaces()[i];
                if (interfaceType instanceof ParameterizedType) {
                    Type[] actualTypes = ((ParameterizedType)interfaceType).getActualTypeArguments();
                    actualTypes = this.transformParameterizedType(actualTypes, typeVariableReflect);
                    classTypeVariableMap.put(interfaceClass, actualTypes);
                }
                return this.recurseToFindActualLabelValueType(interfaceClass, classTypeVariableMap);
            }
        }
        return null;
    }

    private Type[] findValueTypeFromSuperclass(Class<? extends Label> label, Map<Class<?>, Type[]> classTypeVariableMap, Map<String, Type> typeVariableReflect) {
        Type superclassType = label.getGenericSuperclass();
        if (superclassType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)superclassType).getActualTypeArguments();
            actualTypes = this.transformParameterizedType(actualTypes, typeVariableReflect);
            classTypeVariableMap.put(label.getSuperclass(), actualTypes);
        }
        return this.recurseToFindActualLabelValueType(label.getSuperclass(), classTypeVariableMap);
    }

    private Type[] transformParameterizedType(Type[] rawTypes, Map<String, Type> typeVariableReflect) {
        return this.resolveParameterizedType(rawTypes, rawType -> {
            if (rawType instanceof TypeVariable) {
                return typeVariableReflect.getOrDefault(rawType.getTypeName(), (Type)rawType);
            }
            return rawType;
        });
    }

    private Type[] resolveParameterizedType(Type[] rawTypes, Function<Type, Type> resolveFunc) {
        LinkedList<Type> queue = new LinkedList<Type>();
        ArrayList<Type> resolvedTypes = new ArrayList<Type>();
        CombineType combineType = null;
        for (Type rawType : rawTypes) {
            queue.add(rawType);
            while (!queue.isEmpty()) {
                Type typeInQueue = (Type)queue.poll();
                if (typeInQueue instanceof CombineType) {
                    combineType = (CombineType)typeInQueue;
                    continue;
                }
                if (typeInQueue instanceof ParameterizedType) {
                    CombineType newCombineType = new CombineType(((ParameterizedType)typeInQueue).getRawType());
                    queue.add(newCombineType);
                    Type[] actualTypes = ((ParameterizedType)typeInQueue).getActualTypeArguments();
                    queue.addAll(Arrays.asList(actualTypes));
                    if (null != combineType) {
                        combineType.childTypes.add(newCombineType);
                        queue.add(combineType);
                        continue;
                    }
                    resolvedTypes.add(newCombineType);
                    continue;
                }
                if (null != combineType) {
                    combineType.childTypes.add(resolveFunc.apply(typeInQueue));
                    continue;
                }
                resolvedTypes.add(resolveFunc.apply(typeInQueue));
            }
            combineType = null;
        }
        return resolvedTypes.toArray(new Type[0]);
    }

    private Type[] expandParameterizedType(Type[] resolvedTypes) {
        LinkedList<Type> queue = new LinkedList<Type>();
        ArrayList<Type> expandTypes = new ArrayList<Type>();
        for (Type expandType : resolvedTypes) {
            queue.add(expandType);
            while (!queue.isEmpty()) {
                Type typeInQueue = (Type)queue.poll();
                if (typeInQueue instanceof CombineType) {
                    CombineType combineType = (CombineType)typeInQueue;
                    expandTypes.add(combineType.actual);
                    queue.addAll(combineType.childTypes);
                    continue;
                }
                expandTypes.add(typeInQueue);
            }
        }
        return expandTypes.toArray(new Type[0]);
    }

    private JavaType getJavaType(Type concreteType, Type ... parameterTypes) {
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        for (Type parameterType : parameterTypes) {
            if (parameterType instanceof CombineType) {
                CombineType combineType = (CombineType)parameterType;
                javaTypes.add(this.getJavaType(combineType.actual, combineType.childTypes.toArray(new Type[0])));
                continue;
            }
            javaTypes.add(this.getJavaType(parameterType, new Type[0]));
        }
        if (javaTypes.size() > 0) {
            Class rawClass = Object.class;
            if (concreteType instanceof Class) {
                rawClass = (Class)concreteType;
            }
            return TypeFactory.defaultInstance().constructParametricType(rawClass, javaTypes.toArray(new JavaType[0]));
        }
        return TypeFactory.defaultInstance().constructType(concreteType);
    }

    protected static class CombineType
    implements Type {
        protected Type actual;
        protected List<Type> childTypes = new ArrayList<Type>();

        CombineType(Type actual) {
            this.actual = actual;
        }
    }
}

