/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.scheduler;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.scheduler.Scheduler;
import org.apache.linkis.scheduler.conf.SchedulerConfiguration$;
import org.apache.linkis.scheduler.errorcode.LinkisSchedulerErrorCodeSummary;
import org.apache.linkis.scheduler.exception.SchedulerErrorException;
import org.apache.linkis.scheduler.queue.Consumer;
import org.apache.linkis.scheduler.queue.Group;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q\u0001D\u0007\u0002\u0002YAQa\t\u0001\u0005\u0002\u0011BQA\n\u0001\u0005B\u001dBQA\f\u0001\u0005B\u001dBqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\u0006u\u0001!Ia\u000f\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006)\u0002!\t%\u0016\u0005\u0006=\u0002!\te\u0018\u0005\u0006=\u0002!\t\u0005\u001a\u0005\u0006M\u0002!\te\n\u0002\u0012\u0003\n\u001cHO]1diN\u001b\u0007.\u001a3vY\u0016\u0014(B\u0001\b\u0010\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0011#\u00051A.\u001b8lSNT!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011c\u0001\u0001\u00187A\u0011\u0001$G\u0007\u0002\u001b%\u0011!$\u0004\u0002\n'\u000eDW\rZ;mKJ\u0004\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0001z\u0011AB2p[6|g.\u0003\u0002#;\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001&!\tA\u0002!\u0001\u0003j]&$H#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\tUs\u0017\u000e^\u0001\u0006gR\f'\u000f^\u0001\u000f\u000bZ+e\nV0J\t~\u001b\u0006\u000bT%U+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f\u00153VI\u0014+`\u0013\u0012{6\u000b\u0015'J)\u0002\n!bZ3u\u000bZ,g\u000e^%e)\radi\u0013\t\u0003{\u0011s!A\u0010\"\u0011\u0005}RS\"\u0001!\u000b\u0005\u0005+\u0012A\u0002\u001fs_>$h(\u0003\u0002DU\u00051\u0001K]3eK\u001aL!\u0001O#\u000b\u0005\rS\u0003\"B$\u0007\u0001\u0004A\u0015!B5oI\u0016D\bCA\u0015J\u0013\tQ%FA\u0002J]RDQ\u0001\u0014\u0004A\u0002q\n\u0011b\u001a:pkBt\u0015-\\3\u0002)\u001d,G/\u00138eKb\fe\u000eZ$s_V\u0004h*Y7f)\ty%\u000b\u0005\u0003*!\"c\u0014BA)+\u0005\u0019!V\u000f\u001d7fe!)1k\u0002a\u0001y\u00059QM^3oi&#\u0017AB:vE6LG\u000f\u0006\u0002)-\")q\u000b\u0003a\u00011\u0006)QM^3oiB\u0011\u0011\fX\u0007\u00025*\u00111,D\u0001\u0006cV,W/Z\u0005\u0003;j\u0013abU2iK\u0012,H.\u001a:Fm\u0016tG/A\u0002hKR$\"\u0001Y2\u0011\u0007%\n\u0007,\u0003\u0002cU\t1q\n\u001d;j_:DQaV\u0005A\u0002a#\"\u0001Y3\t\u000bMS\u0001\u0019\u0001\u001f\u0002\u0011MDW\u000f\u001e3po:\u0004")
public abstract class AbstractScheduler
extends Scheduler
implements Logging {
    private final String EVENT_ID_SPLIT;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractScheduler abstractScheduler = this;
        synchronized (abstractScheduler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    private String EVENT_ID_SPLIT() {
        return this.EVENT_ID_SPLIT;
    }

    private String getEventId(int index, String groupName) {
        return new StringBuilder(0).append(groupName).append(this.EVENT_ID_SPLIT()).append(index).toString();
    }

    private Tuple2<Object, String> getIndexAndGroupName(String eventId) {
        if (StringUtils.isBlank((CharSequence)eventId) || !eventId.contains(this.EVENT_ID_SPLIT()) || eventId.startsWith(this.EVENT_ID_SPLIT())) {
            throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.UNRECOGNIZED_EXECID.getErrorCode(), new StringBuilder(1).append(LinkisSchedulerErrorCodeSummary.UNRECOGNIZED_EXECID.getErrorDesc()).append(eventId).append(".").toString());
        }
        int index = eventId.lastIndexOf(this.EVENT_ID_SPLIT());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(eventId.substring(index + 1))).toInt()), (Object)eventId.substring(0, index));
    }

    @Override
    public void submit(SchedulerEvent event) {
        Group group = this.getSchedulerContext().getOrCreateGroupFactory().getOrCreateGroup(event);
        Consumer consumer = this.getSchedulerContext().getOrCreateConsumerManager().getOrCreateConsumer(group.getGroupName());
        this.logger().info(new StringBuilder(37).append("Consumer ").append(consumer.getGroup().getGroupName()).append(" running size ").append(consumer.getRunningSize()).append(" waiting size ").append(consumer.getWaitingSize()).toString());
        if (consumer.getWaitingSize() >= SchedulerConfiguration$.MODULE$.MAX_GROUP_ALTER_WAITING_SIZE()) {
            this.logger().warn(new StringBuilder(61).append("Group waiting size exceed max alter waiting size ").append(consumer.getWaitingSize()).append(" group name ").append(consumer.getGroup().getGroupName()).toString());
        }
        Option<Object> index = consumer.getConsumeQueue().offer(event);
        index.map((Function1 & Serializable & scala.Serializable)x$1 -> this.getEventId(BoxesRunTime.unboxToInt((Object)x$1), group.getGroupName())).foreach((Function1 & Serializable & scala.Serializable)id -> {
            event.setId(id);
            return BoxedUnit.UNIT;
        });
        if (index.isEmpty()) {
            throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.JOB_QUEUE_IS_FULL.getErrorCode(), LinkisSchedulerErrorCodeSummary.JOB_QUEUE_IS_FULL.getErrorDesc());
        }
    }

    @Override
    public Option<SchedulerEvent> get(SchedulerEvent event) {
        return this.get(event.getId());
    }

    @Override
    public Option<SchedulerEvent> get(String eventId) {
        Tuple2<Object, String> tuple2 = this.getIndexAndGroupName(eventId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int index = tuple2._1$mcI$sp();
        String groupName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)groupName);
        int index2 = tuple22._1$mcI$sp();
        String groupName2 = (String)tuple22._2();
        Consumer consumer = this.getSchedulerContext().getOrCreateConsumerManager().getOrCreateConsumer(groupName2);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])consumer.getRunningEvents())).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractScheduler.$anonfun$get$1(eventId, x$3))).orElse((Function0 & Serializable & scala.Serializable)() -> consumer.getConsumeQueue().get(index2));
    }

    @Override
    public void shutdown() {
        if (this.getSchedulerContext() != null) {
            Object object = this.getSchedulerContext().getOrCreateConsumerManager() != null ? Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.getSchedulerContext().getOrCreateConsumerManager().shutdown()) : BoxedUnit.UNIT;
            Object object2 = this.getSchedulerContext().getOrCreateExecutorManager() != null ? Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.getSchedulerContext().getOrCreateExecutorManager().shutdown()) : BoxedUnit.UNIT;
            if (this.getSchedulerContext().getOrCreateSchedulerListenerBus() != null) {
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.getSchedulerContext().getOrCreateSchedulerListenerBus().stop());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$get$1(String eventId$1, SchedulerEvent x$3) {
        String string = x$3.getId();
        String string2 = eventId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public AbstractScheduler() {
        Logging.$init$((Logging)this);
        this.EVENT_ID_SPLIT = "_";
    }
}

