/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.listener.callback.imp;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.cs.common.entity.listener.CommonContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.listener.CSIDListener;
import org.apache.linkis.cs.listener.callback.ContextIDCallbackEngine;
import org.apache.linkis.cs.listener.callback.imp.ContextKeyValueBean;
import org.apache.linkis.cs.listener.event.ContextIDEvent;
import org.apache.linkis.cs.listener.event.impl.DefaultContextIDEvent;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextIDCallbackEngine
implements CSIDListener,
ContextIDCallbackEngine {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextIDCallbackEngine.class);
    private HashMultimap<String, ContextID> registerCSIDcsClients = HashMultimap.create();
    private List<ContextID> removedContextIDS = new ArrayList<ContextID>();
    private static DefaultContextIDCallbackEngine singleDefaultContextIDCallbackEngine = null;

    @Override
    public ArrayList<ContextKeyValueBean> getListenerCallback(String source) {
        Set ContextIDSets = this.registerCSIDcsClients.get((Object)source);
        ArrayList<ContextKeyValueBean> contextKeyValueBeans = new ArrayList<ContextKeyValueBean>();
        for (ContextID contextID : this.removedContextIDS) {
            if (!ContextIDSets.contains(contextID)) continue;
            ContextKeyValueBean contextKeyValueBean = new ContextKeyValueBean();
            contextKeyValueBean.setCsID(contextID);
            contextKeyValueBeans.add(contextKeyValueBean);
        }
        return contextKeyValueBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClient(ListenerDomain listenerDomain) {
        if (listenerDomain != null && listenerDomain instanceof CommonContextIDListenerDomain) {
            CommonContextIDListenerDomain commonContextIDListenerDomain = (CommonContextIDListenerDomain)listenerDomain;
            String source = commonContextIDListenerDomain.getSource();
            ContextID contextID = commonContextIDListenerDomain.getContextID();
            if (source != null && contextID != null) {
                HashMultimap<String, ContextID> hashMultimap = this.registerCSIDcsClients;
                synchronized (hashMultimap) {
                    this.registerCSIDcsClients.put((Object)source, (Object)contextID);
                }
            }
        }
    }

    @Override
    public void onEvent(Event event) {
        DefaultContextIDEvent defaultContextIDEvent = null;
        if (event != null && event instanceof DefaultContextIDEvent) {
            defaultContextIDEvent = (DefaultContextIDEvent)event;
        }
        if (null == defaultContextIDEvent) {
            logger.warn("defaultContextIDEvent event \u4e3a\u7a7a");
            return;
        }
        switch (defaultContextIDEvent.getOperateType()) {
            case REMOVEALL: {
                this.onCSIDRemoved(defaultContextIDEvent);
                break;
            }
            case ADD: {
                this.onCSIDADD(defaultContextIDEvent);
                break;
            }
            case ACCESS: {
                this.onCSIDAccess(defaultContextIDEvent);
                break;
            }
            case UPDATE: {
                break;
            }
            case DELETE: {
                break;
            }
            default: {
                logger.info("check defaultContextIDEvent event operate type(\u68c0\u67e5defaultContextIDEvent event\u64cd\u4f5c\u7c7b\u578b)");
            }
        }
    }

    @Override
    public void onCSIDAccess(ContextIDEvent contextIDEvent) {
    }

    @Override
    public void onCSIDADD(ContextIDEvent contextIDEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCSIDRemoved(ContextIDEvent contextIDEvent) {
        DefaultContextIDEvent defaultContextIDEvent = null;
        if (contextIDEvent != null && contextIDEvent instanceof DefaultContextIDEvent) {
            defaultContextIDEvent = (DefaultContextIDEvent)contextIDEvent;
        }
        if (null == defaultContextIDEvent) {
            return;
        }
        List<ContextID> list = this.removedContextIDS;
        synchronized (list) {
            this.removedContextIDS.add(defaultContextIDEvent.getContextID());
        }
    }

    public void onEventError(Event event, Throwable t) {
    }

    private DefaultContextIDCallbackEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultContextIDCallbackEngine getInstance() {
        if (singleDefaultContextIDCallbackEngine != null) return singleDefaultContextIDCallbackEngine;
        Class<DefaultContextIDCallbackEngine> clazz = DefaultContextIDCallbackEngine.class;
        synchronized (DefaultContextIDCallbackEngine.class) {
            if (singleDefaultContextIDCallbackEngine != null) return singleDefaultContextIDCallbackEngine;
            singleDefaultContextIDCallbackEngine = new DefaultContextIDCallbackEngine();
            DefaultContextListenerManager instanceContextListenerManager = DefaultContextListenerManager.getInstance();
            instanceContextListenerManager.getContextAsyncListenerBus().addListener(singleDefaultContextIDCallbackEngine);
            logger.info("add listerner singleDefaultContextIDCallbackEngine success");
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleDefaultContextIDCallbackEngine;
        }
    }
}

