/*
 * Decompiled with CFR 0.152.
 */
package springfox.boot.starter.autoconfigure;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import springfox.boot.starter.autoconfigure.SwaggerUiWebMvcConfigurer;
import springfox.documentation.builders.BuilderDefaults;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"springfox.documentation.swagger-ui.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerUiWebMvcConfiguration {
    @Value(value="${springfox.documentation.swagger-ui.base-url:}")
    private String swaggerBaseUrl;

    @Bean
    public SwaggerUiWebMvcConfigurer swaggerUiConfigurer() {
        return new SwaggerUiWebMvcConfigurer(this.fixup(this.swaggerBaseUrl));
    }

    private String fixup(String swaggerBaseUrl) {
        return StringUtils.trimTrailingCharacter((String)BuilderDefaults.nullToEmpty((String)swaggerBaseUrl), (char)'/');
    }
}

