/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.ResourceWarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DriverAndYarnResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(DriverAndYarnResource.class);
    private final LoadInstanceResource loadInstanceResource;
    private final YarnResource yarnResource;

    public DriverAndYarnResource(LoadInstanceResource loadInstanceResource, YarnResource yarnResource) {
        this.loadInstanceResource = loadInstanceResource;
        this.yarnResource = yarnResource;
    }

    public DriverAndYarnResource() {
        this(new LoadInstanceResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new YarnResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, "default", ""));
    }

    public LoadInstanceResource getLoadInstanceResource() {
        return this.loadInstanceResource;
    }

    private DriverAndYarnResource(Resource r) {
        if (r instanceof DriverAndYarnResource) {
            DriverAndYarnResource t = (DriverAndYarnResource)r;
            this.loadInstanceResource = t.loadInstanceResource;
            this.yarnResource = t.yarnResource;
        } else if (r instanceof YarnResource) {
            this.loadInstanceResource = new LoadInstanceResource(0L, 0, 0);
            this.yarnResource = (YarnResource)r;
        } else if (r instanceof LoadInstanceResource) {
            this.loadInstanceResource = (LoadInstanceResource)r;
            this.yarnResource = new YarnResource(0L, 0, 0, "default", "");
        } else if (r instanceof LoadResource) {
            LoadResource l = (LoadResource)r;
            this.loadInstanceResource = new LoadInstanceResource(l.getMemory(), l.getCores(), 0);
            this.yarnResource = new YarnResource(0L, 0, 0, "default", "");
        } else if (r instanceof MemoryResource) {
            MemoryResource m = (MemoryResource)r;
            this.loadInstanceResource = new LoadInstanceResource(m.getMemory(), 0, 0);
            this.yarnResource = new YarnResource(0L, 0, 0, "default", "");
        } else if (r instanceof CPUResource) {
            CPUResource c = (CPUResource)r;
            this.loadInstanceResource = new LoadInstanceResource(0L, c.getCores(), 0);
            this.yarnResource = new YarnResource(0L, 0, 0, "default", "");
        } else {
            this.loadInstanceResource = new LoadInstanceResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.yarnResource = new YarnResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, "default", "");
        }
    }

    public YarnResource getYarnResource() {
        return this.yarnResource;
    }

    @Override
    public DriverAndYarnResource add(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        return new DriverAndYarnResource(this.loadInstanceResource.add(r.getLoadInstanceResource()), this.yarnResource.add(r.getYarnResource()));
    }

    @Override
    public DriverAndYarnResource minus(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        return new DriverAndYarnResource(this.loadInstanceResource.minus(r.getLoadInstanceResource()), this.yarnResource.minus(r.getYarnResource()));
    }

    @Override
    public Resource multiplied(Resource r) {
        throw new ResourceWarnException(ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorCode(), ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorDesc());
    }

    @Override
    public Resource multiplied(float rate) {
        return new DriverAndYarnResource(this.loadInstanceResource.multiplied(rate), this.yarnResource.multiplied(rate));
    }

    @Override
    public Resource divide(Resource r) {
        throw new ResourceWarnException(ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorCode(), ManagerCommonErrorCodeSummary.OPERATION_MULTIPLIED.getErrorDesc());
    }

    @Override
    public Resource divide(int rate) {
        return new DriverAndYarnResource(this.loadInstanceResource.divide(rate), this.yarnResource.divide(rate));
    }

    @Override
    public boolean moreThan(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        return this.loadInstanceResource.moreThan(r.loadInstanceResource) && this.yarnResource.moreThan(r.yarnResource);
    }

    @Override
    public boolean caseMore(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        return this.loadInstanceResource.caseMore(r.loadInstanceResource) || this.yarnResource.caseMore(r.yarnResource);
    }

    @Override
    public boolean equalsTo(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        return this.loadInstanceResource.equalsTo(r.loadInstanceResource) && this.yarnResource.equalsTo(r.yarnResource);
    }

    @Override
    public boolean notLess(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        return this.loadInstanceResource.notLess(r.loadInstanceResource) && this.yarnResource.notLess(r.yarnResource);
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource resource) {
        DriverAndYarnResource r = new DriverAndYarnResource(resource);
        if (this.loadInstanceResource.getMemory() > r.loadInstanceResource.getMemory()) {
            return 1;
        }
        if (this.loadInstanceResource.getMemory() < r.loadInstanceResource.getMemory()) {
            return -1;
        }
        if (this.loadInstanceResource.getCores() > r.loadInstanceResource.getCores()) {
            return 1;
        }
        if (this.loadInstanceResource.getCores() < r.loadInstanceResource.getCores()) {
            return -1;
        }
        if (this.loadInstanceResource.getInstances() > r.loadInstanceResource.getInstances()) {
            return 1;
        }
        if (this.loadInstanceResource.getInstances() < r.loadInstanceResource.getInstances()) {
            return -1;
        }
        if (this.yarnResource.getQueueMemory() > r.yarnResource.getQueueMemory()) {
            return 1;
        }
        if (this.yarnResource.getQueueMemory() < r.yarnResource.getQueueMemory()) {
            return -1;
        }
        return Integer.compare(this.yarnResource.getQueueCores(), r.yarnResource.getQueueCores());
    }

    @Override
    public String toJson() {
        String load = "null";
        String yarn = "null";
        if (this.loadInstanceResource != null) {
            load = this.loadInstanceResource.toJson();
        }
        if (this.yarnResource != null) {
            yarn = this.yarnResource.toJson();
        }
        return String.format("{\"driver\":%s, \"yarn\":%s}", load, yarn);
    }

    public String toString() {
        return String.format("Driver resources(Driver\u8d44\u6e90)\uff1a%s, Queue resource(\u961f\u5217\u8d44\u6e90):%s", this.loadInstanceResource, this.yarnResource);
    }
}

