/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.validate;

import com.google.gson.GsonBuilder;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.configuration.errorcode.LinkisConfigurationErrorCodeSummary;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.validate.Validator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00153AAB\u0004\u0001%!)Q\u0005\u0001C\u0001M!)\u0001\u0002\u0001C!Q!91\b\u0001a\u0001\n\u0003b\u0004bB\u001f\u0001\u0001\u0004%\tE\u0010\u0005\u0007\t\u0002\u0001\u000b\u0015\u0002\u0018\u0003\u001d\u0019cw.\u0019;WC2LG-\u0019;pe*\u0011\u0001\"C\u0001\tm\u0006d\u0017\u000eZ1uK*\u0011!bC\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u00051i\u0011A\u00027j].L7O\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0005\u0001MIR\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011aB\u0005\u00039\u001d\u0011\u0011BV1mS\u0012\fGo\u001c:\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013!B;uS2\u001c(B\u0001\u0012\f\u0003\u0019\u0019w.\\7p]&\u0011Ae\b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002\u001b\u0001Q\u0019\u0011\u0006L\u001d\u0011\u0005QQ\u0013BA\u0016\u0016\u0005\u001d\u0011un\u001c7fC:DQ!\f\u0002A\u00029\nQA^1mk\u0016\u0004\"a\f\u001c\u000f\u0005A\"\u0004CA\u0019\u0016\u001b\u0005\u0011$BA\u001a\u0012\u0003\u0019a$o\\8u}%\u0011Q'F\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026+!)!H\u0001a\u0001]\u0005)!/\u00198hK\u0006!1.\u001b8e+\u0005q\u0013\u0001C6j]\u0012|F%Z9\u0015\u0005}\u0012\u0005C\u0001\u000bA\u0013\t\tUC\u0001\u0003V]&$\bbB\"\u0005\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\n\u0014!B6j]\u0012\u0004\u0003")
public class FloatValidator
implements Validator,
Logging {
    private String kind;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FloatValidator floatValidator = this;
        synchronized (floatValidator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(String value, String range) {
        try {
            double[] rangArray = (double[])new GsonBuilder().create().fromJson(range, double[].class);
            if (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rangArray)).size() != 2) {
                throw new ConfigurationException(LinkisConfigurationErrorCodeSummary.ERROR_VALIDATOR_RANGE.getErrorDesc());
            }
            StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(value));
            ArrayOps.ofDouble ofDouble2 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rangArray));
            if (!(stringOps.toDouble() >= ((double[])ofDouble2.sorted((Ordering)Ordering.Double$.MODULE$))[0])) return false;
            StringOps stringOps2 = new StringOps(Predef$.MODULE$.augmentString(value));
            ArrayOps.ofDouble ofDouble3 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rangArray));
            if (!(stringOps2.toDouble() <= ((double[])ofDouble3.sorted((Ordering)Ordering.Double$.MODULE$))[1])) return false;
            return true;
        }
        catch (NumberFormatException e) {
            this.logger().info(new StringBuilder(16).append(value).append("\u4e0d\u80fd\u8f6c\u6362\u4e3adouble\uff0c\u6821\u9a8c\u5931\u8d25").toString());
            return false;
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public String kind() {
        return this.kind;
    }

    @Override
    public void kind_$eq(String x$1) {
        this.kind = x$1;
    }

    public FloatValidator() {
        Logging.$init$((Logging)this);
        this.kind = "FloatInterval";
    }
}

