/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.configuration.entity.ConfigLabel;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;

public class LabelEntityParser {
    static LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();

    public static ConfigLabel parseToConfigLabel(CombinedLabel combinedLabel) {
        ConfigLabel label = new ConfigLabel();
        label.setLabelKey(combinedLabel.getLabelKey());
        label.setStringValue(combinedLabel.getStringValue());
        label.setFeature(combinedLabel.getFeature());
        label.setLabelValueSize(((List)combinedLabel.getValue()).size());
        return label;
    }

    public static ArrayList<Label> generateUserCreatorEngineTypeLabelList(String username, String creator, String engineType, String version) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            username = "*";
        }
        if (StringUtils.isEmpty((CharSequence)creator)) {
            creator = "*";
        }
        if (StringUtils.isEmpty((CharSequence)engineType)) {
            engineType = "*";
        }
        UserCreatorLabel userCreatorLabel = (UserCreatorLabel)labelBuilderFactory.createLabel(UserCreatorLabel.class);
        userCreatorLabel.setUser(username);
        userCreatorLabel.setCreator(creator);
        EngineTypeLabel engineTypeLabel = EngineTypeLabelCreator.createEngineTypeLabel((String)engineType);
        if (!StringUtils.isEmpty((CharSequence)version)) {
            engineTypeLabel.setVersion(version);
        }
        ArrayList<Label> labelList = new ArrayList<Label>();
        labelList.add((Label)userCreatorLabel);
        labelList.add((Label)engineTypeLabel);
        return labelList;
    }

    public static ArrayList<Label> labelDecompile(String labelKey, String stringValue) {
        String[] labelKeyList = labelKey.split("_");
        String[] stringValueList = stringValue.split(",");
        ArrayList<Label> labelList = new ArrayList<Label>();
        int i = 1;
        int j = 1;
        while (i < labelKeyList.length) {
            String[] innerString;
            String innerKey = labelKeyList[i];
            if (innerKey.equalsIgnoreCase("usercreator")) {
                UserCreatorLabel userCreatorLabel = (UserCreatorLabel)labelBuilderFactory.createLabel(UserCreatorLabel.class);
                innerString = stringValueList[j].split("-");
                userCreatorLabel.setUser(innerString[0]);
                userCreatorLabel.setCreator(innerString[1]);
                labelList.add((Label)userCreatorLabel);
            } else if (innerKey.equalsIgnoreCase("enginetype")) {
                EngineTypeLabel engineTypeLabel = (EngineTypeLabel)labelBuilderFactory.createLabel(EngineTypeLabel.class);
                innerString = stringValueList[j].split("-");
                engineTypeLabel.setEngineType(innerString[0]);
                engineTypeLabel.setVersion(innerString[1]);
                labelList.add((Label)engineTypeLabel);
            }
            ++i;
            --j;
        }
        return labelList;
    }
}

