/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import springfox.documentation.schema.Example;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.VendorExtension;

public class RequestParameter {
    public static final int DEFAULT_PRECEDENCE = 0;
    private final String name;
    private final int parameterIndex;
    private final ParameterType in;
    private final String description;
    private final Boolean required;
    private final Boolean deprecated;
    private final Boolean hidden;
    private final ParameterSpecification parameterSpecification;
    private final Integer precedence;
    private final Example scalarExample;
    private final List<Example> examples = new ArrayList<Example>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public RequestParameter(String name, ParameterType in, String description, Boolean required, Boolean deprecated, Boolean hidden, ParameterSpecification parameterSpecification, Example scalarExample, Collection<Example> examples, int precedence, List<VendorExtension> extensions, int parameterIndex) {
        this.name = name;
        this.in = in;
        this.description = description;
        this.required = required;
        this.deprecated = deprecated;
        this.hidden = hidden;
        this.parameterSpecification = parameterSpecification;
        this.precedence = precedence;
        this.parameterIndex = parameterIndex;
        this.extensions.addAll(extensions);
        this.scalarExample = scalarExample;
        this.examples.addAll(examples);
    }

    public String getName() {
        return this.name;
    }

    public ParameterType getIn() {
        return this.in;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public ParameterSpecification getParameterSpecification() {
        return this.parameterSpecification;
    }

    public List<VendorExtension> getExtensions() {
        return this.extensions;
    }

    public Integer getPrecedence() {
        return this.precedence;
    }

    String getParamType() {
        return this.in.getIn();
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public Example getScalarExample() {
        return this.scalarExample;
    }

    public boolean isRequestBody() {
        return false;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestParameter that = (RequestParameter)o;
        return this.parameterIndex == that.parameterIndex && Objects.equals(this.name, that.name) && this.in == that.in && Objects.equals(this.description, that.description) && Objects.equals(this.required, that.required) && Objects.equals(this.deprecated, that.deprecated) && Objects.equals(this.hidden, that.hidden) && Objects.equals(this.parameterSpecification, that.parameterSpecification) && Objects.equals(this.precedence, that.precedence) && Objects.equals(this.scalarExample, that.scalarExample) && Objects.equals(this.examples, that.examples) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.parameterIndex, this.in, this.description, this.required, this.deprecated, this.hidden, this.parameterSpecification, this.precedence, this.scalarExample, this.examples, this.extensions});
    }

    public String toString() {
        return "RequestParameter{name='" + this.name + '\'' + ", parameterIndex=" + this.parameterIndex + ", in=" + (Object)((Object)this.in) + ", description='" + this.description + '\'' + ", required=" + this.required + ", deprecated=" + this.deprecated + ", hidden=" + this.hidden + ", parameterSpecification=" + this.parameterSpecification + ", precedence=" + this.precedence + ", scalarExample=" + this.scalarExample + ", examples=" + this.examples + ", extensions=" + this.extensions + '}';
    }
}

