/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.persistence.persistence.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.linkis.cs.common.entity.listener.CommonContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.persistence.dao.ContextKeyListenerMapper;
import org.apache.linkis.cs.persistence.dao.ContextMapMapper;
import org.apache.linkis.cs.persistence.entity.PersistenceContextKeyListener;
import org.apache.linkis.cs.persistence.entity.PersistenceContextKeyValue;
import org.apache.linkis.cs.persistence.persistence.ContextKeyListenerPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextMapPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextKeyListenerPersistenceImpl
implements ContextKeyListenerPersistence {
    @Autowired
    private ContextKeyListenerMapper contextKeyListenerMapper;
    @Autowired
    private ContextMapMapper contextMapMapper;
    @Autowired
    private ContextMapPersistence contextMapPersistence;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void create(ContextID contextID, ContextKeyListenerDomain contextKeyListenerDomain) throws CSErrorException {
        PersistenceContextKeyListener listener = new PersistenceContextKeyListener();
        listener.setSource(contextKeyListenerDomain.getSource());
        PersistenceContextKeyValue contextMap = this.contextMapMapper.getContextMap(contextID, contextKeyListenerDomain.getContextKey());
        listener.setKeyId(contextMap.getId());
        this.contextKeyListenerMapper.createKeyListener(listener);
    }

    @Override
    public void remove(ContextID contextID, ContextKeyListenerDomain contextKeyListenerDomain) throws CSErrorException {
        PersistenceContextKeyValue contextMap = this.contextMapMapper.getContextMap(contextID, contextKeyListenerDomain.getContextKey());
        Integer keyId = contextMap.getId();
        this.contextKeyListenerMapper.remove(contextKeyListenerDomain, keyId);
    }

    @Override
    public void removeAll(ContextID contextID) throws CSErrorException {
        List<Integer> keyIds = this.contextMapMapper.getAllContextMapByContextID(contextID).stream().map(PersistenceContextKeyValue::getId).collect(Collectors.toList());
        this.contextKeyListenerMapper.removeAll(keyIds);
    }

    @Override
    public List<ContextKeyListenerDomain> getAll(ContextID contextID) throws CSErrorException {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByContextID(contextID);
        List<Integer> keyIds = this.contextMapMapper.getAllContextMapByContextID(contextID).stream().map(PersistenceContextKeyValue::getId).collect(Collectors.toList());
        ArrayList<ContextKeyListenerDomain> domains = new ArrayList<ContextKeyListenerDomain>();
        if (!keyIds.isEmpty()) {
            this.logger.info("fetch %s keyIds by contextId %s", (Object)keyIds.size(), (Object)contextID.getContextId());
            List<PersistenceContextKeyListener> listeners = this.contextKeyListenerMapper.getAll(keyIds);
            for (PersistenceContextKeyListener listener : listeners) {
                domains.add(this.pDomainToCommon(listener, contextID, pKVs));
            }
        }
        return domains;
    }

    public ContextKeyListenerDomain pDomainToCommon(PersistenceContextKeyListener listener, ContextID contextID, List<PersistenceContextKeyValue> pKVs) throws CSErrorException {
        CommonContextKeyListenerDomain domain = new CommonContextKeyListenerDomain();
        domain.setSource(listener.getSource());
        Optional<PersistenceContextKeyValue> first = pKVs.stream().filter(kv -> kv.getId().equals(listener.getId())).findFirst();
        if (first.isPresent()) {
            ContextKeyValue contextKeyValue = this.contextMapPersistence.get(contextID, first.get().getContextKey());
            domain.setContextKey(contextKeyValue.getContextKey());
        }
        return domain;
    }

    @Override
    public ContextKeyListenerDomain getBy(ContextKeyListenerDomain contextKeyListenerDomain) throws CSErrorException {
        return contextKeyListenerDomain;
    }
}

