/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.highavailable.ha.impl;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.utils.CSHighAvailableUtils;
import org.apache.linkis.cs.highavailable.conf.ContextHighAvailableConf;
import org.apache.linkis.cs.highavailable.exception.CSErrorCode;
import org.apache.linkis.cs.highavailable.ha.ContextHAChecker;
import org.apache.linkis.cs.highavailable.ha.instancealias.impl.InstanceAliasManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextHACheckerImpl
implements ContextHAChecker {
    private static final Logger logger = LoggerFactory.getLogger(ContextHACheckerImpl.class);
    @Autowired
    private InstanceAliasManagerImpl instanceAliasManager;

    @Override
    public boolean isHAIDValid(String haIDKey) {
        if (CSHighAvailableUtils.checkHAIDBasicFormat((String)haIDKey)) {
            try {
                return this.checkHAIDInstance(CSHighAvailableUtils.decodeHAID((String)haIDKey));
            }
            catch (CSErrorException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isHAContextIDValid(HAContextID haContextID) throws CSErrorException {
        boolean valid = false;
        valid = null != haContextID && StringUtils.isNotBlank((CharSequence)haContextID.getInstance()) && StringUtils.isNotBlank((CharSequence)haContextID.getBackupInstance()) ? (StringUtils.isNotBlank((CharSequence)haContextID.getContextId()) ? (StringUtils.isNumeric((CharSequence)haContextID.getContextId()) ? this.checkHAIDInstance(haContextID) : this.isHAIDValid(haContextID.getContextId())) : false) : false;
        return valid;
    }

    @Override
    public String convertHAIDToHAKey(HAContextID haContextID) throws CSErrorException {
        if (null == haContextID || StringUtils.isBlank((CharSequence)haContextID.getInstance()) || StringUtils.isBlank((CharSequence)haContextID.getBackupInstance()) || StringUtils.isBlank((CharSequence)haContextID.getContextId())) {
            throw new CSErrorException(CSErrorCode.INVALID_HAID, "Incomplete HAID Object cannot be encoded. mainInstance : " + haContextID.getInstance() + ", backupInstance : " + haContextID.getBackupInstance() + ", contextID : " + haContextID.getContextId());
        }
        if (StringUtils.isNumeric((CharSequence)haContextID.getContextId())) {
            return this.encode(haContextID);
        }
        if (this.isHAIDValid(haContextID.getContextId())) {
            return haContextID.getContextId();
        }
        logger.error("ConvertHAIDToHAKey error, invald HAID : " + haContextID.getContextId());
        throw new CSErrorException(CSErrorCode.INVALID_HAID, "ConvertHAIDToHAKey error, invald HAID : " + haContextID.getContextId());
    }

    private String encode(HAContextID haContextID) throws CSErrorException {
        ArrayList<String> backupInstanceList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)haContextID.getBackupInstance())) {
            backupInstanceList.add(haContextID.getBackupInstance());
        } else {
            backupInstanceList.add(haContextID.getInstance());
        }
        return CSHighAvailableUtils.encodeHAIDKey((String)haContextID.getContextId(), (String)haContextID.getInstance(), backupInstanceList);
    }

    private boolean checkHAIDInstance(HAContextID haContextID) {
        if (!((Boolean)ContextHighAvailableConf.ENABLE_STRICT_HAID_CHECK.getValue()).booleanValue()) {
            return true;
        }
        ServiceInstance serverMainInstance = DataWorkCloudApplication.getServiceInstance();
        String mainInstanceAlias = haContextID.getInstance();
        String backupInstanceAlias = haContextID.getBackupInstance();
        if (!this.instanceAliasManager.isInstanceAliasValid(mainInstanceAlias) && !this.instanceAliasManager.isInstanceAliasValid(backupInstanceAlias)) {
            return false;
        }
        ServiceInstance mainInstance = this.instanceAliasManager.getInstanceByAlias(mainInstanceAlias);
        ServiceInstance backupInstance = this.instanceAliasManager.getInstanceByAlias(backupInstanceAlias);
        return serverMainInstance.equals((Object)mainInstance) || serverMainInstance.equals((Object)backupInstance);
    }

    @Override
    public HAContextID parseHAIDFromKey(String haIDKey) throws CSErrorException {
        Object haContextID = null;
        if (StringUtils.isBlank((CharSequence)haIDKey) || !CSHighAvailableUtils.checkHAIDBasicFormat((String)haIDKey)) {
            logger.error("Invalid haIDKey : " + haIDKey);
            throw new CSErrorException(CSErrorCode.INVALID_HAID, "Invalid haIDKey : " + haIDKey);
        }
        return CSHighAvailableUtils.decodeHAID((String)haIDKey);
    }
}

