/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.linkis.cs.contextcache.index.ContextInvertedIndex;

public class DefaultContextInvertedIndex
implements ContextInvertedIndex {
    Multimap<String, String> indexMultimap = HashMultimap.create();

    @Override
    public List<String> getContextKeys(String keyword) {
        Collection keywords = this.indexMultimap.get((Object)keyword);
        return new ArrayList<String>(keywords);
    }

    @Override
    public boolean addValue(String keyword, String contextKey) {
        return this.indexMultimap.put((Object)keyword, (Object)contextKey);
    }

    @Override
    public List<String> getContextKeys(List<String> keywords) {
        if (CollectionUtils.isEmpty(keywords)) {
            return null;
        }
        ArrayList<String> contextKeys = new ArrayList<String>();
        for (String keyword : keywords) {
            contextKeys.addAll(this.getContextKeys(keyword));
        }
        return contextKeys;
    }

    @Override
    public boolean remove(String keyword, String contextKey) {
        return this.indexMultimap.remove((Object)keyword, (Object)contextKey);
    }
}

