/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.cache.cskey.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.exception.CSWarnException;
import org.apache.linkis.cs.contextcache.cache.cskey.ContextKeyValueContext;
import org.apache.linkis.cs.contextcache.cache.cskey.ContextValueMapSet;
import org.apache.linkis.cs.contextcache.cache.cskey.impl.ContextValueMapSetImpl;
import org.apache.linkis.cs.contextcache.index.ContextInvertedIndexSet;
import org.apache.linkis.cs.contextcache.index.ContextInvertedIndexSetImpl;
import org.apache.linkis.cs.contextcache.parser.ContextKeyValueParser;
import org.apache.linkis.cs.listener.ListenerBus.ContextAsyncListenerBus;
import org.apache.linkis.cs.listener.event.enumeration.OperateType;
import org.apache.linkis.cs.listener.event.impl.DefaultContextKeyEvent;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DefaultContextKeyValueContext
implements ContextKeyValueContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextKeyValueContext.class);
    ContextInvertedIndexSet contextInvertedIndexSet = new ContextInvertedIndexSetImpl();
    ContextValueMapSet contextValueMapSet = new ContextValueMapSetImpl();
    ContextAsyncListenerBus listenerBus = DefaultContextListenerManager.getInstance().getContextAsyncListenerBus();
    private ContextID contextID;
    @Autowired
    ContextKeyValueParser contextKeyValueParser;

    @Override
    public ContextID getContextID() {
        return this.contextID;
    }

    @Override
    public void setContextID(ContextID contextID) throws CSWarnException {
        if (this.contextID != null) {
            logger.error("Do not set contextID repeatedly.The current context is {}", (Object)this.contextID.getContextId());
            throw new CSWarnException(97001, "Do not set contextID repeatedly");
        }
        this.contextID = contextID;
    }

    @Override
    public ContextInvertedIndexSet getContextInvertedIndexSet() {
        return this.contextInvertedIndexSet;
    }

    @Override
    public ContextValueMapSet getContextValueMapSet() {
        return this.contextValueMapSet;
    }

    @Override
    public ContextKeyValueParser getContextKeyValueParser() {
        return this.contextKeyValueParser;
    }

    @Override
    public ContextKeyValue put(ContextKeyValue contextKeyValue) {
        ContextKey contextKey = contextKeyValue.getContextKey();
        if (contextKey == null || StringUtils.isBlank((CharSequence)contextKey.getKey())) {
            return null;
        }
        ContextKeyValue oldValue = this.getContextValueMapSet().put(contextKeyValue);
        Set<String> keyWords = this.getContextKeyValueParser().parse(contextKeyValue);
        this.getContextInvertedIndexSet().addKeywords(keyWords, contextKey.getKey(), contextKey.getContextType());
        DefaultContextKeyEvent defaultContextKeyEvent = new DefaultContextKeyEvent();
        defaultContextKeyEvent.setContextID(this.contextID);
        defaultContextKeyEvent.setContextKeyValue(contextKeyValue);
        defaultContextKeyEvent.setOldValue(oldValue);
        if (null != oldValue) {
            defaultContextKeyEvent.setOperateType(OperateType.UPDATE);
        } else {
            defaultContextKeyEvent.setOperateType(OperateType.ADD);
        }
        this.listenerBus.post((Event)defaultContextKeyEvent);
        return oldValue;
    }

    @Override
    public ContextKeyValue remove(ContextKey contextKey) {
        if (contextKey == null || StringUtils.isBlank((CharSequence)contextKey.getKey())) {
            return null;
        }
        ContextKeyValue contextKeyValue = this.getContextValueMapSet().remove(contextKey.getKey(), contextKey.getContextType());
        if (null == contextKeyValue) {
            return null;
        }
        Set<String> keyWords = this.getContextKeyValueParser().parse(contextKeyValue);
        Iterator<String> iterator = keyWords.iterator();
        ContextInvertedIndexSet contextInvertedIndexSet = this.getContextInvertedIndexSet();
        while (iterator.hasNext()) {
            contextInvertedIndexSet.remove(iterator.next(), contextKey.getKey(), contextKey.getContextType());
        }
        logger.info("Succeed to remove contextKey of {}", (Object)contextKey.getKey());
        DefaultContextKeyEvent defaultContextKeyEvent = new DefaultContextKeyEvent();
        defaultContextKeyEvent.setContextID(this.contextID);
        defaultContextKeyEvent.setContextKeyValue(contextKeyValue);
        defaultContextKeyEvent.setOperateType(OperateType.DELETE);
        this.listenerBus.post((Event)defaultContextKeyEvent);
        return contextKeyValue;
    }

    @Override
    public ContextKeyValue getContextKeyValue(ContextKey contextKey, ContextType contextType) {
        return this.getContextValueMapSet().getByContextKey(contextKey, contextType);
    }

    @Override
    public List<ContextKeyValue> getValues(String keyword, ContextType contextType) {
        List<String> contextKeys = this.getContextInvertedIndexSet().getContextKeys(keyword, contextType);
        return this.getValues(contextKeys, contextType);
    }

    @Override
    public List<ContextKeyValue> getValues(List<String> contextKeys, ContextType contextType) {
        return this.getContextValueMapSet().getByContextKeys(contextKeys, contextType);
    }

    @Override
    public List<ContextKeyValue> getAllValues(ContextType contextType) {
        return this.getContextValueMapSet().getAllValuesByType(contextType);
    }

    @Override
    public List<ContextKeyValue> getAllLikes(String regex, ContextType contextType) {
        return this.getContextValueMapSet().getAllLikes(regex, contextType);
    }

    @Override
    public List<ContextKeyValue> getAll() {
        return this.contextValueMapSet.getAll();
    }

    @Override
    public Map<String, ContextKeyValue> removeAll(ContextType contextType) {
        DefaultContextKeyEvent defaultContextKeyEvent = new DefaultContextKeyEvent();
        defaultContextKeyEvent.setContextID(this.contextID);
        defaultContextKeyEvent.setOperateType(OperateType.REMOVEALL);
        this.listenerBus.post((Event)defaultContextKeyEvent);
        this.getContextInvertedIndexSet().removeAll(contextType);
        logger.warn("ContextID({}) removeAll contextKey of  contextType({})", (Object)this.contextID.getContextId(), (Object)contextType.name());
        return this.getContextValueMapSet().removeAll(contextType);
    }

    @Override
    public Boolean putAll(List<ContextKeyValue> contextKeyValueList) {
        for (ContextKeyValue contextKeyValue : contextKeyValueList) {
            this.put(contextKeyValue);
        }
        return true;
    }

    @Override
    public void removeByKeyPrefix(String preFix) {
        List<ContextKey> removeKeys = this.getContextValueMapSet().findByKeyPrefix(preFix);
        if (CollectionUtils.isNotEmpty(removeKeys)) {
            for (ContextKey key : removeKeys) {
                this.remove(key);
            }
            logger.warn("Remove keyValue by key preFix: " + preFix);
        }
    }

    @Override
    public void removeByKeyPrefix(String preFix, ContextType csType) {
        List<ContextKey> removeKeys = this.getContextValueMapSet().findByKeyPrefix(preFix, csType);
        if (CollectionUtils.isNotEmpty(removeKeys)) {
            for (ContextKey key : removeKeys) {
                this.remove(key);
            }
            logger.warn("Remove keyValue by key preFix{} and csType{} ", (Object)preFix, (Object)csType);
        }
    }

    @Override
    public void removeByKey(String keyStr, ContextType csType) {
        List<ContextKey> removeKeys = this.getContextValueMapSet().findByKey(keyStr, csType);
        if (CollectionUtils.isNotEmpty(removeKeys)) {
            for (ContextKey key : removeKeys) {
                this.remove(key);
            }
            logger.warn("Remove keyValue by keyStr {} and csType{} ", (Object)keyStr, (Object)csType);
        }
    }
}

