/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.contextcache.cache.ContextCache;
import org.apache.linkis.cs.contextcache.cache.csid.ContextIDValue;
import org.apache.linkis.cs.contextcache.cache.csid.ContextIDValueGenerator;
import org.apache.linkis.cs.contextcache.conf.ContextCacheConf;
import org.apache.linkis.cs.contextcache.metric.ContextCacheMetric;
import org.apache.linkis.cs.contextcache.metric.DefaultContextCacheMetric;
import org.apache.linkis.cs.listener.CSIDListener;
import org.apache.linkis.cs.listener.ListenerBus.ContextAsyncListenerBus;
import org.apache.linkis.cs.listener.event.ContextIDEvent;
import org.apache.linkis.cs.listener.event.enumeration.OperateType;
import org.apache.linkis.cs.listener.event.impl.DefaultContextIDEvent;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultContextCache
implements ContextCache,
CSIDListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextCache.class);
    private ContextAsyncListenerBus listenerBus = DefaultContextListenerManager.getInstance().getContextAsyncListenerBus();
    @Autowired
    private RemovalListener<String, ContextIDValue> contextIDRemoveListener;
    @Autowired
    private ContextIDValueGenerator contextIDValueGenerator;
    private Cache<String, ContextIDValue> cache = null;
    private ContextCacheMetric contextCacheMetric = new DefaultContextCacheMetric();

    @PostConstruct
    private void init() {
        this.listenerBus.addListener((EventListener)this);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)ContextCacheConf.MAX_CACHE_SIZE).expireAfterWrite(Duration.ofMillis(ContextCacheConf.MAX_CACHE_READ_EXPIRE_MILLS)).removalListener(this.contextIDRemoveListener).recordStats().build();
    }

    @Override
    public ContextIDValue getContextIDValue(ContextID contextID) throws CSErrorException {
        if (null == contextID || StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            return null;
        }
        try {
            DefaultContextIDEvent defaultContextIDEvent;
            ContextIDValue contextIDValue = (ContextIDValue)this.cache.getIfPresent((Object)contextID.getContextId());
            if (contextIDValue == null) {
                contextIDValue = this.contextIDValueGenerator.createContextIDValue(contextID);
                this.put(contextIDValue);
                defaultContextIDEvent = new DefaultContextIDEvent();
                defaultContextIDEvent.setContextID(contextID);
                defaultContextIDEvent.setOperateType(OperateType.ADD);
                this.listenerBus.post((Event)defaultContextIDEvent);
            }
            defaultContextIDEvent = new DefaultContextIDEvent();
            defaultContextIDEvent.setContextID(contextID);
            defaultContextIDEvent.setOperateType(OperateType.ACCESS);
            this.listenerBus.post((Event)defaultContextIDEvent);
            return contextIDValue;
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to get contextIDValue of ContextID(%s)", contextID.getContextId());
            logger.error(errorMsg);
            throw new CSErrorException(97001, errorMsg, (Throwable)e);
        }
    }

    @Override
    public void remove(ContextID contextID) {
        if (null != contextID && StringUtils.isNotBlank((CharSequence)contextID.getContextId())) {
            logger.info("From cache to remove contextID:{}", (Object)contextID.getContextId());
            this.cache.invalidate((Object)contextID.getContextId());
        }
    }

    @Override
    public void put(ContextIDValue contextIDValue) throws CSErrorException {
        if (contextIDValue != null && StringUtils.isNotBlank((CharSequence)contextIDValue.getContextID())) {
            logger.info("update contextID:{}", (Object)contextIDValue.getContextID());
            this.cache.put((Object)contextIDValue.getContextID(), (Object)contextIDValue);
        }
    }

    @Override
    public Map<String, ContextIDValue> getAllPresent(List<ContextID> contextIDList) {
        List contextIDKeys = contextIDList.stream().map(contextID -> {
            if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
                return null;
            }
            return contextID.getContextId();
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return this.cache.getAllPresent(contextIDKeys);
    }

    @Override
    public void refreshAll() throws CSErrorException {
    }

    @Override
    public void putAll(List<ContextIDValue> contextIDValueList) throws CSErrorException {
        for (ContextIDValue contextIDValue : contextIDValueList) {
            this.put(contextIDValue);
        }
    }

    @Override
    public ContextIDValue loadContextIDValue(ContextID contextID) {
        return null;
    }

    @Override
    public ContextCacheMetric getContextCacheMetric() {
        return this.contextCacheMetric;
    }

    public void onCSIDAccess(ContextIDEvent contextIDEvent) {
        this.getContextCacheMetric().addCount();
    }

    public void onCSIDADD(ContextIDEvent contextIDEvent) {
        logger.info("deal contextID ADD event of {}", (Object)contextIDEvent.getContextID());
        this.getContextCacheMetric().addCount();
        this.getContextCacheMetric().setCachedCount(this.getContextCacheMetric().getCachedCount() + 1);
        logger.info("Now, The cachedCount is ({})", (Object)this.getContextCacheMetric().getCachedCount());
    }

    public void onCSIDRemoved(ContextIDEvent contextIDEvent) {
        logger.info("deal contextID remove event of {}", (Object)contextIDEvent.getContextID());
        this.getContextCacheMetric().setCachedCount(this.getContextCacheMetric().getCachedCount() - 1);
        logger.info("Now, The cachedCount is ({})", (Object)this.getContextCacheMetric().getCachedCount());
    }

    public void onEventError(Event event, Throwable t) {
        logger.error("Failed to deal event", t);
    }

    public void onEvent(Event event) {
        DefaultContextIDEvent defaultContextIDEvent = null;
        if (event != null && event instanceof DefaultContextIDEvent) {
            defaultContextIDEvent = (DefaultContextIDEvent)event;
        }
        if (null == defaultContextIDEvent) {
            return;
        }
        if (OperateType.ADD.equals((Object)defaultContextIDEvent.getOperateType())) {
            this.onCSIDADD((ContextIDEvent)defaultContextIDEvent);
        } else if (OperateType.DELETE.equals((Object)defaultContextIDEvent.getOperateType())) {
            this.onCSIDRemoved((ContextIDEvent)defaultContextIDEvent);
        } else {
            this.onCSIDAccess((ContextIDEvent)defaultContextIDEvent);
        }
    }
}

