/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.StringWriter;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenderStrategy {
    RenderStrategy() {
    }

    static class InPlaceUpdateFunction
    extends BaseUpdateFunction {
        private final InPlaceUpdate inPlaceUpdate = new InPlaceUpdate(SessionState.LogHelper.getInfoStream());

        InPlaceUpdateFunction(TezJobMonitor monitor) {
            super(monitor);
        }

        @Override
        public void renderProgress(ProgressMonitor progressMonitor) {
            this.inPlaceUpdate.render(progressMonitor);
        }

        @Override
        public void renderReport(String report) {
            this.monitor.console.logInfo(report);
        }
    }

    static class LogToFileFunction
    extends BaseUpdateFunction {
        private static final Logger LOGGER = LoggerFactory.getLogger(LogToFileFunction.class);
        private boolean hiveServer2InPlaceProgressEnabled = SessionState.get().getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_INPLACE_PROGRESS);

        LogToFileFunction(TezJobMonitor monitor) {
            super(monitor);
        }

        @Override
        public void renderProgress(ProgressMonitor progressMonitor) {
            SessionState.get().updateProgressMonitor(progressMonitor);
        }

        @Override
        public void renderReport(String report) {
            if (this.hiveServer2InPlaceProgressEnabled) {
                LOGGER.info(report);
            } else {
                this.monitor.console.printInfo(report);
            }
        }
    }

    private static abstract class BaseUpdateFunction
    implements UpdateFunction {
        private static final int PRINT_INTERVAL = 3000;
        final TezJobMonitor monitor;
        private final PerfLogger perfLogger;
        private long lastPrintTime = 0L;
        private String lastReport = null;

        BaseUpdateFunction(TezJobMonitor monitor) {
            this.monitor = monitor;
            this.perfLogger = SessionState.getPerfLogger();
        }

        @Override
        public void update(DAGStatus status, Map<String, Progress> vertexProgressMap) {
            this.renderProgress(this.monitor.progressMonitor(status, vertexProgressMap));
            String report = this.getReport(vertexProgressMap);
            if (this.showReport(report)) {
                this.renderReport(report);
                this.lastReport = report;
                this.lastPrintTime = System.currentTimeMillis();
            }
        }

        private boolean showReport(String report) {
            return !report.equals(this.lastReport) || System.currentTimeMillis() >= this.lastPrintTime + 3000L;
        }

        private String getReport(Map<String, Progress> progressMap) {
            StringWriter reportBuffer = new StringWriter();
            TreeSet<String> keys = new TreeSet<String>(progressMap.keySet());
            for (String s : keys) {
                Progress progress = progressMap.get(s);
                int complete = progress.getSucceededTaskCount();
                int total = progress.getTotalTaskCount();
                int running = progress.getRunningTaskCount();
                int failed = progress.getFailedTaskAttemptCount();
                if (total <= 0) {
                    reportBuffer.append(String.format("%s: -/-\t", s));
                    continue;
                }
                if (complete == total) {
                    if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                        this.perfLogger.PerfLogBegin(TezJobMonitor.CLASS_NAME, "TezRunVertex." + s);
                    }
                    if (!this.perfLogger.endTimeHasMethod("TezRunVertex." + s)) {
                        this.perfLogger.PerfLogEnd(TezJobMonitor.CLASS_NAME, "TezRunVertex." + s);
                    }
                }
                if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                    if (!this.perfLogger.startTimeHasMethod("TezRunVertex." + s)) {
                        this.perfLogger.PerfLogBegin(TezJobMonitor.CLASS_NAME, "TezRunVertex." + s);
                    }
                    if (failed > 0) {
                        reportBuffer.append(String.format("%s: %d(+%d,-%d)/%d\t", s, complete, running, failed, total));
                        continue;
                    }
                    reportBuffer.append(String.format("%s: %d(+%d)/%d\t", s, complete, running, total));
                    continue;
                }
                if (failed > 0) {
                    reportBuffer.append(String.format("%s: %d(-%d)/%d\t", s, complete, failed, total));
                    continue;
                }
                reportBuffer.append(String.format("%s: %d/%d\t", s, complete, total));
            }
            return reportBuffer.toString();
        }

        abstract void renderProgress(ProgressMonitor var1);

        abstract void renderReport(String var1);
    }

    static interface UpdateFunction {
        public void update(DAGStatus var1, Map<String, Progress> var2);
    }
}

