/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.fm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javolution.util.FastBitSet;
import org.apache.hadoop.hive.common.ndv.fm.FMSketch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMSketchUtils {
    static final Logger LOG = LoggerFactory.getLogger((String)FMSketch.class.getName());
    public static final byte[] MAGIC = new byte[]{70, 77};

    public static void serializeFM(OutputStream out, FMSketch fm) throws IOException {
        out.write(MAGIC);
        byte[] nbv = new byte[]{(byte)fm.getNumBitVectors(), (byte)(fm.getNumBitVectors() >>> 8)};
        out.write(nbv);
        for (int i = 0; i < fm.getNumBitVectors(); ++i) {
            FMSketchUtils.writeBitVector(out, fm.getBitVector(i));
        }
    }

    private static void writeBitVector(OutputStream out, FastBitSet bit) throws IOException {
        int num = 0;
        for (int pos = 0; pos < 31; ++pos) {
            if (!bit.get(pos)) continue;
            num |= 1 << pos;
        }
        byte[] i = new byte[4];
        for (int j = 0; j < 4; ++j) {
            i[j] = (byte)(num >>> 8 * j & 0xFF);
        }
        out.write(i);
    }

    public static FMSketch deserializeFM(byte[] buf) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            FMSketch sketch = FMSketchUtils.deserializeFM(is);
            ((InputStream)is).close();
            return sketch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FMSketch deserializeFM(InputStream in) throws IOException {
        FMSketchUtils.checkMagicString(in);
        byte[] nbv = new byte[]{(byte)in.read(), (byte)in.read()};
        int numBitVectors = 0;
        numBitVectors |= nbv[0] & 0xFF;
        FMSketch sketch = new FMSketch(numBitVectors |= (nbv[1] & 0xFF) << 8);
        for (int n = 0; n < numBitVectors; ++n) {
            sketch.setBitVector(FMSketchUtils.readBitVector(in), n);
        }
        return sketch;
    }

    private static FastBitSet readBitVector(InputStream in) throws IOException {
        FastBitSet fastBitSet = new FastBitSet();
        fastBitSet.clear();
        for (int i = 0; i < 4; ++i) {
            byte b = (byte)in.read();
            for (int j = 0; j < 8; ++j) {
                if ((b & 1 << j) == 0) continue;
                fastBitSet.set(j + 8 * i);
            }
        }
        return fastBitSet;
    }

    private static void checkMagicString(InputStream in) throws IOException {
        byte[] magic = new byte[]{(byte)in.read(), (byte)in.read()};
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IllegalArgumentException("The input stream is not a FMSketch stream.");
        }
    }
}

