/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service.oracle;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.service.AbstractSqlConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConnection
extends AbstractSqlConnection {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnection.class);
    private static final CommonVars<String> SQL_DRIVER_CLASS = CommonVars.apply((String)"wds.linkis.server.mdm.service.oracle.driver", (Object)"oracle.jdbc.driver.OracleDriver");
    private static final CommonVars<String> SQL_CONNECT_URL = CommonVars.apply((String)"wds.linkis.server.mdm.service.oracle.sid.url", (Object)"jdbc:oracle:thin:@%s:%s:%s");
    private static final CommonVars<String> SQL_CONNECT_SERVICE_URL = CommonVars.apply((String)"wds.linkis.server.mdm.service.oracle.service.url", (Object)"jdbc:oracle:thin:@//%s:%s/%s");
    private String serviceName;

    public SqlConnection(String host, Integer port, String username, String password, String database, String serviceName, Map<String, Object> extraParams) throws ClassNotFoundException, SQLException {
        super(host, port, username, password, database, extraParams);
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllDatabases() throws SQLException {
        ArrayList<String> dataBaseName = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("select username from sys.dba_users WHERE default_tablespace not in ('SYSTEM','SYSAUX') and ACCOUNT_STATUS = 'OPEN'\n");
            while (rs.next()) {
                dataBaseName.add(rs.getString("username"));
            }
        }
        catch (Throwable throwable) {
            this.closeResource(null, stmt, rs);
            throw throwable;
        }
        this.closeResource(null, stmt, rs);
        return dataBaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllTables(String schemaname) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> tableNames = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT table_name FROM sys.dba_tables WHERE owner = '" + schemaname + "'");
            while (rs.next()) {
                tableNames.add(rs.getString("TABLE_NAME"));
            }
            arrayList = tableNames;
        }
        catch (Throwable throwable) {
            this.closeResource(null, stmt, rs);
            throw throwable;
        }
        this.closeResource(null, stmt, rs);
        return arrayList;
    }

    @Override
    public Connection getDBConnection(AbstractSqlConnection.ConnectMessage connectMessage, String database) throws ClassNotFoundException, SQLException {
        return this.getDBConnection(connectMessage, database, this.serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetaColumnInfo> getColumns(String schemaname, String table) throws SQLException, ClassNotFoundException {
        ArrayList<MetaColumnInfo> columns = new ArrayList<MetaColumnInfo>();
        String columnSql = "SELECT * FROM " + schemaname + "." + table + " WHERE 1 = 2";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List<String> primaryKeys = this.getPrimaryKeys(table);
            Map<String, String> columnCommentMap = this.getColumnComment(schemaname, table);
            ps = this.conn.prepareStatement(columnSql);
            rs = ps.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                String colComment;
                MetaColumnInfo info = new MetaColumnInfo();
                info.setIndex(i);
                info.setLength(meta.getColumnDisplaySize(i));
                info.setNullable(meta.isNullable(i) == 1);
                info.setName(meta.getColumnName(i));
                info.setType(meta.getColumnTypeName(i));
                if (primaryKeys.contains(meta.getColumnName(i))) {
                    info.setPrimaryKey(true);
                }
                if (StringUtils.isNotBlank((CharSequence)(colComment = columnCommentMap.get(meta.getColumnName(i))))) {
                    info.setColComment(colComment);
                } else {
                    info.setColComment("");
                }
                columns.add(info);
            }
        }
        catch (Throwable throwable) {
            this.closeResource(null, ps, rs);
            throw throwable;
        }
        this.closeResource(null, ps, rs);
        return columns;
    }

    private Map<String, String> getColumnComment(String schema, String table) throws SQLException {
        ResultSet rs = null;
        HashMap<String, String> columnComment = new HashMap<String, String>();
        DatabaseMetaData dbMeta = this.conn.getMetaData();
        rs = dbMeta.getColumns(null, schema, table, "%");
        while (rs.next()) {
            columnComment.put(rs.getString("COlUMN_NAME"), rs.getString("REMARKS"));
        }
        return columnComment;
    }

    private Connection getDBConnection(AbstractSqlConnection.ConnectMessage connectMessage, String database, String serviceName) throws ClassNotFoundException, SQLException {
        Class.forName((String)SQL_DRIVER_CLASS.getValue());
        String url = "";
        if (StringUtils.isNotBlank((CharSequence)database)) {
            url = String.format((String)SQL_CONNECT_URL.getValue(), connectMessage.host, connectMessage.port, database);
        } else if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            url = String.format((String)SQL_CONNECT_SERVICE_URL.getValue(), connectMessage.host, connectMessage.port, serviceName);
        }
        if (MapUtils.isNotEmpty(connectMessage.extraParams)) {
            String extraParamString = connectMessage.extraParams.entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
            url = url + "?" + extraParamString;
        }
        Properties prop = new Properties();
        prop.put("user", connectMessage.username);
        prop.put("password", connectMessage.password);
        prop.put("remarksReporting", "true");
        return DriverManager.getConnection(url, prop);
    }

    public String getSqlConnectUrl() {
        return (String)SQL_CONNECT_URL.getValue();
    }

    @Override
    public String generateJdbcDdlSql(String database, String table) {
        String columnSql = String.format("SELECT DBMS_METADATA.GET_DDL('TABLE', '%s', '%s') AS DDL  FROM DUAL ", table, database);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String ddl = "";
        try {
            ps = this.conn.prepareStatement(columnSql);
            rs = ps.executeQuery();
            if (rs.next()) {
                ddl = rs.getString("DDL");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeResource(null, ps, rs);
                throw throwable;
            }
        }
        this.closeResource(null, ps, rs);
        return ddl;
    }
}

