/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.ecm.server.conf.ECMConfiguration;
import org.apache.linkis.ecm.server.service.EngineConnKillService;
import org.apache.linkis.ecm.utils.ECMCacheUtils;
import org.apache.linkis.engineconn.common.conf.EngineConnConf;
import org.apache.linkis.governance.common.utils.GovernanceUtils;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineSuicideRequest;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEngineConnKillService
implements EngineConnKillService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineConnKillService.class);
    private static final ThreadPoolExecutor ecYarnAppKillService = Utils.newCachedThreadPool((int)10, (String)"ECM-Kill-EC-Yarn-App", (boolean)true);

    @Override
    @Receiver
    public EngineStopResponse dealEngineConnStop(EngineStopRequest engineStopRequest) {
        logger.info("received EngineStopRequest " + engineStopRequest);
        String pid = null;
        if ("process".equals(engineStopRequest.getIdentifierType()) && StringUtils.isNotBlank((CharSequence)engineStopRequest.getIdentifier())) {
            ECMCacheUtils.putStopECToCache(engineStopRequest.getServiceInstance(), engineStopRequest);
            pid = engineStopRequest.getIdentifier();
        }
        logger.info("dealEngineConnStop return pid: {}", pid);
        EngineStopResponse response = new EngineStopResponse();
        if (StringUtils.isNotBlank(pid)) {
            if (!this.killEngineConnByPid(pid, engineStopRequest.getServiceInstance())) {
                response.setStopStatus(false);
                response.setMsg("Kill engine " + engineStopRequest.getServiceInstance().toString() + " failed.");
            } else {
                response.setStopStatus(true);
                response.setMsg("Kill engine " + engineStopRequest.getServiceInstance().toString() + " succeed.");
            }
        } else {
            String processPort = engineStopRequest.getServiceInstance().getInstance().split(":")[1];
            logger.warn("Kill EC {} by port {}", (Object)engineStopRequest.getServiceInstance(), (Object)processPort);
            if (!this.killEngineConnByPort(processPort, engineStopRequest.getServiceInstance())) {
                response.setStopStatus(false);
                response.setMsg("Kill engine " + engineStopRequest.getServiceInstance().toString() + " failed.");
            } else {
                response.setStopStatus(true);
                response.setMsg("Kill engine " + engineStopRequest.getServiceInstance().toString() + " succeed.");
            }
        }
        if ("process".equals(engineStopRequest.getIdentifierType())) {
            this.killYarnAppIdOfOneEc(engineStopRequest);
        }
        if ("cluster_process".equals(engineStopRequest.getIdentifierType()) && engineStopRequest.getIdentifier() != null) {
            ArrayList<String> appIds = new ArrayList<String>();
            appIds.add(engineStopRequest.getIdentifier());
            GovernanceUtils.killYarnJobApp(appIds);
        }
        if (!response.getStopStatus()) {
            EngineSuicideRequest request = new EngineSuicideRequest(engineStopRequest.getServiceInstance(), engineStopRequest.getUser());
            try {
                Sender.getSender((ServiceInstance)engineStopRequest.getServiceInstance()).send((Object)request);
                response.setStopStatus(true);
                response.setMsg(response.getMsg() + " Now send suicide request to engine.");
            }
            catch (Exception e) {
                response.setMsg(response.getMsg() + " Sended suicide request to engine error, " + e.getMessage());
            }
        }
        return response;
    }

    public void killYarnAppIdOfOneEc(EngineStopRequest engineStopRequest) {
        String logDirSuffix = engineStopRequest.getLogDirSuffix();
        ServiceInstance serviceInstance = engineStopRequest.getServiceInstance();
        String engineType = engineStopRequest.getEngineType();
        String engineConnInstance = serviceInstance.toString();
        String engineLogDir = logDirSuffix.startsWith(ECMConfiguration.ENGINECONN_ROOT_DIR()) ? logDirSuffix : ECMConfiguration.ENGINECONN_ROOT_DIR() + File.separator + logDirSuffix;
        logger.info("try to kill yarn app ids in the engine of: [{}] engineLogDir: [{}]", (Object)engineConnInstance, (Object)engineLogDir);
        String errEngineLogPath = engineLogDir.concat(File.separator).concat("yarnApp");
        logger.info("try to parse the yarn app id from the engine err log file path: [{}]", (Object)errEngineLogPath);
        File file = new File(errEngineLogPath);
        if (file.exists()) {
            ecYarnAppKillService.execute(() -> {
                String regex;
                BufferedReader in;
                block7: {
                    in = null;
                    in = new BufferedReader(new FileReader(errEngineLogPath));
                    regex = this.getYarnAppRegexByEngineType(engineType);
                    if (!StringUtils.isBlank((CharSequence)regex)) break block7;
                    IOUtils.closeQuietly((Reader)in);
                    return;
                }
                try {
                    String line;
                    Pattern pattern = Pattern.compile(regex);
                    ArrayList<String> appIds = new ArrayList<String>();
                    while ((line = in.readLine()) != null) {
                        String candidate1;
                        Matcher mApp;
                        if (!StringUtils.isNotBlank((CharSequence)line) || !(mApp = pattern.matcher(line)).find() || appIds.contains(candidate1 = mApp.group(mApp.groupCount()))) continue;
                        appIds.add(candidate1);
                    }
                    GovernanceUtils.killYarnJobApp(appIds);
                    logger.info("finished kill yarn app ids in the engine of ({}).", (Object)engineConnInstance);
                }
                catch (IOException ioEx) {
                    block8: {
                        try {
                            if (ioEx instanceof FileNotFoundException) {
                                logger.error("the engine log file {} not found.", (Object)errEngineLogPath);
                                break block8;
                            }
                            logger.error("the engine log file parse failed. the reason is {}", (Object)ioEx.getMessage());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Reader)in);
                }
                IOUtils.closeQuietly((Reader)in);
            });
        }
    }

    private String getYarnAppRegexByEngineType(String engineType) {
        String regex;
        if (StringUtils.isBlank((CharSequence)engineType)) {
            return "";
        }
        switch (engineType) {
            case "spark": 
            case "shell": {
                regex = (String)EngineConnConf.SPARK_ENGINE_CONN_YARN_APP_ID_PARSE_REGEX().getValue();
                break;
            }
            case "sqoop": {
                regex = (String)EngineConnConf.SQOOP_ENGINE_CONN_YARN_APP_ID_PARSE_REGEX().getValue();
                break;
            }
            case "seatunnel": 
            case "flink": 
            case "hive": {
                regex = (String)EngineConnConf.HIVE_ENGINE_CONN_YARN_APP_ID_PARSE_REGEX().getValue();
                break;
            }
            default: {
                regex = "";
            }
        }
        return regex;
    }

    private boolean killEngineConnByPid(String processId, ServiceInstance serviceInstance) {
        logger.info("try to kill {} toString with pid({}).", (Object)serviceInstance.toString(), (Object)processId);
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            if (ECMConfiguration.ECM_PROCESS_SCRIPT_KILL()) {
                GovernanceUtils.killProcess((String)processId, (String)serviceInstance.toString(), (boolean)true);
            } else {
                this.killProcessByKillCmd(processId, serviceInstance.toString());
            }
            return !this.isProcessAlive(processId);
        }
        logger.warn("cannot kill {} with empty pid.", (Object)serviceInstance);
        return false;
    }

    private boolean killEngineConnByPort(String port, ServiceInstance serviceInstance) {
        logger.info("try to kill {} toString with port({}).", (Object)serviceInstance.toString(), (Object)port);
        if (StringUtils.isNotBlank((CharSequence)port)) {
            GovernanceUtils.killECProcessByPort((String)port, (String)serviceInstance.toString(), (boolean)true);
            return !this.isProcessAliveByPort(port);
        }
        logger.warn("cannot kill {} with empty port.", (Object)serviceInstance);
        return false;
    }

    private boolean isProcessAlive(String pid) {
        String findCmd = "ps -ef | grep " + pid + " | grep EngineConnServer | awk '{print \"exists_\"$2}' | grep " + pid + "|| true";
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("bash");
        cmdList.add("-c");
        cmdList.add(findCmd);
        try {
            String rs = Utils.exec((String[])cmdList.toArray(new String[0]), (long)5000L);
            return null != rs && rs.contains("exists_" + pid);
        }
        catch (Exception e) {
            logger.warn("Method isProcessAlive failed", (Throwable)e);
            return false;
        }
    }

    private boolean isProcessAliveByPort(String port) {
        String findCmd = "ps -ef | grep server.port= " + port + " | grep EngineConnServer | awk -F \"server.port=\" '{print \"exists_\"$2}'";
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("bash");
        cmdList.add("-c");
        cmdList.add(findCmd);
        try {
            String rs = Utils.exec((String[])cmdList.toArray(new String[0]), (long)5000L);
            return null != rs && rs.contains("exists_" + port);
        }
        catch (Exception e) {
            logger.warn("Method isProcessAlive failed", (Throwable)e);
            return false;
        }
    }

    private void killProcessByKillCmd(String pid, String desc) {
        String k15cmd = "sudo kill " + pid;
        String k9cmd = "sudo kill -9 " + pid;
        int tryNum = 0;
        try {
            while (this.isProcessAlive(pid) && tryNum <= 3) {
                logger.info("{} still alive with pid({}), use shell command to kill it. try {}++", new Object[]{desc, pid, tryNum++});
                if (tryNum <= 3) {
                    Utils.exec((String[])k15cmd.split(" "), (long)3000L);
                } else {
                    logger.info("{} still alive with pid({}). try {}, use shell command to kill -9 it", new Object[]{desc, pid, tryNum});
                    Utils.exec((String[])k9cmd.split(" "), (long)3000L);
                }
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while killing engine {} with pid({})." + desc, (Object)pid);
        }
    }
}

