/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.service.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.HardwareUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.OverloadUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.ecm.core.listener.ECMEvent;
import org.apache.linkis.ecm.core.listener.ECMEventListener;
import org.apache.linkis.ecm.core.report.ECMHealthReport;
import org.apache.linkis.ecm.server.LinkisECMApplication;
import org.apache.linkis.ecm.server.conf.ECMConfiguration$;
import org.apache.linkis.ecm.server.listener.ECMClosedEvent;
import org.apache.linkis.ecm.server.listener.ECMReadyEvent;
import org.apache.linkis.ecm.server.report.DefaultECMHealthReport;
import org.apache.linkis.ecm.server.service.ECMHealthService;
import org.apache.linkis.ecm.server.util.ECMUtils$;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeHealthyInfo;
import org.apache.linkis.manager.common.entity.metrics.NodeOverLoadInfo;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.protocol.node.NodeHealthyRequest;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatMsg;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatRequest;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001\u0002\u0017.\u0001qBQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013%A\u000b\u0003\u0004b\u0001\u0001\u0006I!\u0016\u0005\bE\u0002\u0011\r\u0011\"\u0003U\u0011\u0019\u0019\u0007\u0001)A\u0005+\"9A\r\u0001a\u0001\n\u0013)\u0007b\u00027\u0001\u0001\u0004%I!\u001c\u0005\u0007g\u0002\u0001\u000b\u0015\u00024\t\u000fQ\u0004\u0001\u0019!C\u0005k\"9\u0011\u0010\u0001a\u0001\n\u0013Q\bB\u0002?\u0001A\u0003&a\u000fC\u0004~\u0001\u0001\u0007I\u0011\u0002@\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0001bBA\u0006\u0001\u0001\u0006Ka \u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0001\u0004%I!!\u0007\t\u0011\u0005u\u0001\u0001)Q\u0005\u0003#A\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0002\u0002CA\u0018\u0001\u0001\u0006K!a\t\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA#\u0001\u0001\u0006I!!\u000e\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005M\u0002\u0002CA%\u0001\u0001\u0006I!!\u000e\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0003\u0002CA5\u0001\u0001\u0006I!a\u0014\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a0\u0001\t\u0013\t\t\rC\u0004\u0002L\u0002!\t%!4\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAr\u0001\u0011\u0005\u0013Q\u001d\u0005\u0007\u0005\u000f\u0001A\u0011I3\t\r\t%\u0001\u0001\"\u0011v\u0011\u0019\u0011Y\u0001\u0001C!}\"9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u000b\u0001\u0011\u0005#q\u0003\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_\u0011q\u0003R3gCVdG/R\"N\u0011\u0016\fG\u000e\u001e5TKJ4\u0018nY3\u000b\u00059z\u0013\u0001B5na2T!\u0001M\u0019\u0002\u000fM,'O^5dK*\u0011!gM\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Q*\u0014aA3d[*\u0011agN\u0001\u0007Y&t7.[:\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0002\u0001'\u0011\u0001QhQ$\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g!\t!U)D\u00010\u0013\t1uF\u0001\tF\u00076CU-\u00197uQN+'O^5dKB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\tY&\u001cH/\u001a8fe*\u0011AjM\u0001\u0005G>\u0014X-\u0003\u0002O\u0013\n\u0001RiQ'Fm\u0016tG\u000fT5ti\u0016tWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0003\"A\u0015\u0001\u000e\u00035\n1\"\\1y%\u0016\u001cx.\u001e:dKV\tQ\u000b\u0005\u0002W?6\tqK\u0003\u0002Y3\u0006A!/Z:pkJ\u001cWM\u0003\u0002[7\u00061QM\u001c;jifT!\u0001X/\u0002\r\r|W.\\8o\u0015\tqV'A\u0004nC:\fw-\u001a:\n\u0005\u0001<&\u0001\u0006'pC\u0012Len\u001d;b]\u000e,'+Z:pkJ\u001cW-\u0001\u0007nCb\u0014Vm]8ve\u000e,\u0007%A\u0006nS:\u0014Vm]8ve\u000e,\u0017\u0001D7j]J+7o\\;sG\u0016\u0004\u0013AB:uCR,8/F\u0001g!\t9'.D\u0001i\u0015\tI\u0017,A\u0006f]VlWM]1uS>t\u0017BA6i\u0005)qu\u000eZ3Ti\u0006$Xo]\u0001\u000bgR\fG/^:`I\u0015\fHC\u00018r!\tqt.\u0003\u0002q\u007f\t!QK\\5u\u0011\u001d\u0011x!!AA\u0002\u0019\f1\u0001\u001f\u00132\u0003\u001d\u0019H/\u0019;vg\u0002\nq\u0001[3bYRD\u00170F\u0001w!\t9w/\u0003\u0002yQ\nYaj\u001c3f\u0011\u0016\fG\u000e\u001e5z\u0003-AW-\u00197uQf|F%Z9\u0015\u00059\\\bb\u0002:\u000b\u0003\u0003\u0005\rA^\u0001\tQ\u0016\fG\u000e\u001e5zA\u0005a1/\u001a;Cs6\u000bg.Y4feV\tq\u0010E\u0002?\u0003\u0003I1!a\u0001@\u0005\u001d\u0011un\u001c7fC:\f\u0001c]3u\u0005fl\u0015M\\1hKJ|F%Z9\u0015\u00079\fI\u0001C\u0004s\u001b\u0005\u0005\t\u0019A@\u0002\u001bM,GOQ=NC:\fw-\u001a:!\u0003-a\u0017m\u001d;DaVdu.\u00193\u0016\u0005\u0005E\u0001c\u0001 \u0002\u0014%\u0019\u0011QC \u0003\r\u0011{WO\u00197f\u0003=a\u0017m\u001d;DaVdu.\u00193`I\u0015\fHc\u00018\u0002\u001c!A!\u000fEA\u0001\u0002\u0004\t\t\"\u0001\u0007mCN$8\t];M_\u0006$\u0007%\u0001\bmCN$hI]3f\u001b\u0016lwN]=\u0016\u0005\u0005\r\u0002c\u0001 \u0002&%\u0019\u0011qE \u0003\t1{gnZ\u0001\u0013Y\u0006\u001cHO\u0012:fK6+Wn\u001c:z?\u0012*\u0017\u000fF\u0002o\u0003[A\u0001B]\n\u0002\u0002\u0003\u0007\u00111E\u0001\u0010Y\u0006\u001cHO\u0012:fK6+Wn\u001c:zA\u0005a1\u000f^1ukNdunY6feV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006LA!a\u0011\u0002:\t1qJ\u00196fGR\fQb\u001d;biV\u001cHj\\2lKJ\u0004\u0013!\u00045fC2$\b.\u001f'pG.,'/\u0001\biK\u0006dG\u000f[=M_\u000e\\WM\u001d\u0011\u0002\r\u0019,H/\u001e:f+\t\ty\u0005\r\u0003\u0002R\u0005\u0015\u0004CBA*\u0003;\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u00037\ni$\u0001\u0003vi&d\u0017\u0002BA0\u0003+\u0012qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0005\u0003G\n)\u0007\u0004\u0001\u0005\u0017\u0005\u001d$$!A\u0001\u0002\u000b\u0005\u00111\u000e\u0002\u0003\u007fA\nqAZ;ukJ,\u0007%\u0005\u0003\u0002n\u0005M\u0004c\u0001 \u0002p%\u0019\u0011\u0011O \u0003\u000f9{G\u000f[5oOB\u0019a(!\u001e\n\u0007\u0005]tHA\u0002B]f\fQcZ3u\u0019\u0006\u001cH/R'IK\u0006dG\u000f\u001b*fa>\u0014H/\u0006\u0002\u0002~A!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004.\u000baA]3q_J$\u0018\u0002BAD\u0003\u0003\u0013q\"R\"N\u0011\u0016\fG\u000e\u001e5SKB|'\u000f^\u0001\re\u0016\u0004xN\u001d;IK\u0006dG\u000f\u001b\u000b\u0004]\u00065\u0005bBAB9\u0001\u0007\u0011QP\u0001*iJ\fgn\u001d4fe\u0016\u001bU\nS3bYRD'+\u001a9peR$vNT8eK\"+\u0017M\u001d;cK\u0006$Xj]4\u0015\t\u0005M\u00151\u0015\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011qw\u000eZ3\u000b\u0007\u0005u5,\u0001\u0005qe>$xnY8m\u0013\u0011\t\t+a&\u0003!9{G-\u001a%fCJ$(-Z1u\u001bN<\u0007bBAB;\u0001\u0007\u0011QP\u0001\u0015O\u0016tWM]1uK\"+\u0017\r\u001c;i%\u0016\u0004xN\u001d;\u0015\t\u0005u\u0014\u0011\u0016\u0005\b\u0003Ws\u0002\u0019AA\u0012\u0003)\u0011X\r]8siRKW.Z\u0001\u0017K6\u001c\u0006.\u001e;e_^t\u0007*Z1mi\"\u0014V\r]8siR\u0019a.!-\t\u000f\u0005Mv\u00041\u0001\u00026\u0006)QM^3oiB!\u0011qWA^\u001b\t\tIL\u0003\u0002Kc%!\u0011QXA]\u00059)5)T\"m_N,G-\u0012<f]R\f1#Z7SK\u0006$\u0017\u0010S3bYRD'+\u001a9peR$2A\\Ab\u0011\u001d\t\u0019\f\ta\u0001\u0003\u000b\u0004B!a.\u0002H&!\u0011\u0011ZA]\u00055)5)\u0014*fC\u0012LXI^3oi\u00069qN\\#wK:$Hc\u00018\u0002P\"9\u00111W\u0011A\u0002\u0005E\u0007c\u0001%\u0002T&\u0019\u0011Q[%\u0003\u0011\u0015\u001bU*\u0012<f]R\f\u0001dY1oG\u0016d\u0007*Z1mi\"\u0014V\r]8siRC'/Z1e)\rq\u00171\u001c\u0005\b\u0003g\u0013\u0003\u0019AA[\u0003Y\u0001(/Z:jgR,gnY3MK\u001a$(+\u001a9peR\u001cHc\u00018\u0002b\"9\u00111W\u0012A\u0002\u0005U\u0016\u0001\u00073fC2tu\u000eZ3IK\u0006\u0014HOY3biJ+\u0017/^3tiR!\u00111SAt\u0011\u001d\tI\u000f\na\u0001\u0003W\fAC\\8eK\"+\u0017M\u001d;cK\u0006$(+Z9vKN$\b\u0003BAK\u0003[LA!a<\u0002\u0018\n!bj\u001c3f\u0011\u0016\f'\u000f\u001e2fCR\u0014V-];fgRD3\u0001JAz!\u0011\t)Pa\u0001\u000e\u0005\u0005](\u0002BA}\u0003w\f!\"\u00198o_R\fG/[8o\u0015\u0011\ti0a@\u0002\u000f5,7o]1hK*\u0019!\u0011A\u001b\u0002\u0007I\u00048-\u0003\u0003\u0003\u0006\u0005](\u0001\u0003*fG\u0016Lg/\u001a:\u0002\u001b\u001d,GOT8eKN#\u0018\r^;t\u000399W\r\u001e(pI\u0016DU-\u00197uQf\fa\"[:TKR\u0014\u00150T1oC\u001e,'/\u0001\tue\u0006t7/\u001b;j_:\u001cF/\u0019;vgR\u0019aN!\u0005\t\r\tM\u0001\u00061\u0001g\u0003!!xn\u0015;biV\u001c\u0018!\u0005;sC:\u001c\u0018\u000e^5p]\"+\u0017\r\u001c;isR\u0019aN!\u0007\t\r\tm\u0011\u00061\u0001w\u0003%!x\u000eS3bYRD\u00170\u0001\feK\u0006dgj\u001c3f\u0011\u0016\fG\u000e\u001e5z%\u0016\fX/Z:u)\rq'\u0011\u0005\u0005\b\u0005GQ\u0003\u0019\u0001B\u0013\u0003Iqw\u000eZ3IK\u0006dG\u000f[=SKF,Xm\u001d;\u0011\t\u0005U%qE\u0005\u0005\u0005S\t9J\u0001\nO_\u0012,\u0007*Z1mi\"L(+Z9vKN$\bf\u0001\u0016\u0002t\u000692\r[3dW6\u000b7\r[5oKB+'OZ8s[\u0006t7-\u001a\u000b\u0002]\u0002")
public class DefaultECMHealthService
implements ECMHealthService,
ECMEventListener {
    private final LoadInstanceResource maxResource;
    private final LoadInstanceResource minResource;
    private NodeStatus status;
    private NodeHealthy healthy;
    private boolean setByManager;
    private double lastCpuLoad;
    private long lastFreeMemory;
    private final Object statusLocker;
    private final Object healthyLocker;
    private final ScheduledFuture<?> future;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void onEventError(Event event, Throwable t) {
        ECMEventListener.onEventError$((ECMEventListener)this, (Event)event, (Throwable)t);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultECMHealthService defaultECMHealthService = this;
        synchronized (defaultECMHealthService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LoadInstanceResource maxResource() {
        return this.maxResource;
    }

    private LoadInstanceResource minResource() {
        return this.minResource;
    }

    private NodeStatus status() {
        return this.status;
    }

    private void status_$eq(NodeStatus x$1) {
        this.status = x$1;
    }

    private NodeHealthy healthy() {
        return this.healthy;
    }

    private void healthy_$eq(NodeHealthy x$1) {
        this.healthy = x$1;
    }

    private boolean setByManager() {
        return this.setByManager;
    }

    private void setByManager_$eq(boolean x$1) {
        this.setByManager = x$1;
    }

    private double lastCpuLoad() {
        return this.lastCpuLoad;
    }

    private void lastCpuLoad_$eq(double x$1) {
        this.lastCpuLoad = x$1;
    }

    private long lastFreeMemory() {
        return this.lastFreeMemory;
    }

    private void lastFreeMemory_$eq(long x$1) {
        this.lastFreeMemory = x$1;
    }

    private Object statusLocker() {
        return this.statusLocker;
    }

    private Object healthyLocker() {
        return this.healthyLocker;
    }

    private ScheduledFuture<?> future() {
        return this.future;
    }

    @Override
    public ECMHealthReport getLastEMHealthReport() {
        DefaultECMHealthReport report = new DefaultECMHealthReport();
        report.setNodeId(LinkisECMApplication.getECMServiceInstance().toString());
        report.setNodeStatus(this.getNodeStatus());
        report.setTotalResource((Resource)this.maxResource());
        report.setProtectedResource((Resource)this.minResource());
        report.setReportTime(new Date().getTime());
        report.setRunningEngineConns(LinkisECMApplication.getContext().getECMMetrics().getRunningEngineConns());
        NodeOverLoadInfo info = new NodeOverLoadInfo();
        Tuple2 tuple2 = HardwareUtils$.MODULE$.getTotalAndAvailableMemory();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long max = tuple2._1$mcJ$sp();
        long free = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(max, free);
        long max2 = sp2._1$mcJ$sp();
        long free2 = sp2._2$mcJ$sp();
        info.setMaxMemory(Predef$.MODULE$.long2Long(max2));
        info.setSystemLeftMemory(Predef$.MODULE$.long2Long(free2));
        info.setUsedMemory(Predef$.MODULE$.long2Long(max2 - free2));
        report.setOverload(info);
        return report;
    }

    @Override
    public void reportHealth(ECMHealthReport report) {
        NodeHeartbeatMsg heartbeat = this.transferECMHealthReportToNodeHeartbeatMsg(report);
        Sender$.MODULE$.getSender(ECMConfiguration$.MODULE$.MANAGER_SERVICE_NAME()).send((Object)heartbeat);
    }

    private NodeHeartbeatMsg transferECMHealthReportToNodeHeartbeatMsg(ECMHealthReport report) {
        NodeHeartbeatMsg heartbeat = new NodeHeartbeatMsg();
        heartbeat.setOverLoadInfo(report.getOverload());
        heartbeat.setStatus(report.getNodeStatus());
        heartbeat.setServiceInstance(LinkisECMApplication.getECMServiceInstance());
        CommonNodeResource resource = new CommonNodeResource();
        resource.setMaxResource((Resource)this.maxResource());
        resource.setMinResource((Resource)this.minResource());
        heartbeat.setNodeResource((NodeResource)resource);
        heartbeat.setHeartBeatMsg("");
        NodeHealthyInfo nodeHealthyInfo = new NodeHealthyInfo();
        nodeHealthyInfo.setMsg("");
        nodeHealthyInfo.setNodeHealthy(this.getNodeHealthy());
        heartbeat.setHealthyInfo(nodeHealthyInfo);
        return heartbeat;
    }

    @Override
    public ECMHealthReport generateHealthReport(long reportTime) {
        return null;
    }

    private void emShutdownHealthReport(ECMClosedEvent event) {
        this.transitionStatus(NodeStatus.ShuttingDown);
        ECMHealthReport report = this.getLastEMHealthReport();
        this.reportHealth(report);
    }

    private void emReadyHealthReport(ECMReadyEvent event) {
        this.transitionStatus(NodeStatus.Running);
        this.reportHealth(this.getLastEMHealthReport());
    }

    public void onEvent(ECMEvent event) {
        ECMEvent eCMEvent = event;
        if (eCMEvent instanceof ECMReadyEvent) {
            ECMReadyEvent eCMReadyEvent = (ECMReadyEvent)eCMEvent;
            this.emReadyHealthReport(eCMReadyEvent);
            return;
        }
        if (eCMEvent instanceof ECMClosedEvent) {
            ECMClosedEvent eCMClosedEvent = (ECMClosedEvent)eCMEvent;
            this.emShutdownHealthReport(eCMClosedEvent);
            this.presistenceLeftReports(eCMClosedEvent);
            this.cancelHealthReportThread(eCMClosedEvent);
            return;
        }
    }

    private void cancelHealthReportThread(ECMClosedEvent event) {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.future().cancel(true), this.logger());
    }

    private void presistenceLeftReports(ECMClosedEvent event) {
    }

    @Override
    @Receiver
    public NodeHeartbeatMsg dealNodeHeartbeatRequest(NodeHeartbeatRequest nodeHeartbeatRequest) {
        ECMHealthReport healthReport = this.getLastEMHealthReport();
        return this.transferECMHealthReportToNodeHeartbeatMsg(healthReport);
    }

    @Override
    public NodeStatus getNodeStatus() {
        return this.status();
    }

    @Override
    public NodeHealthy getNodeHealthy() {
        return this.healthy();
    }

    @Override
    public boolean isSetByManager() {
        return this.setByManager();
    }

    @Override
    public void transitionStatus(NodeStatus toStatus) {
        block7: {
            Object object = this.statusLocker();
            synchronized (object) {
                block6: {
                    NodeStatus nodeStatus = this.status();
                    if (NodeStatus.Failed.equals(nodeStatus) ? true : NodeStatus.Success.equals(nodeStatus)) {
                        this.logger().warn(new StringBuilder(43).append(this.toString()).append(" attempt to change status ").append(this.status()).append(" => ").append(toStatus).append(", ignore it .").toString());
                        break block6;
                    }
                    if (NodeStatus.ShuttingDown.equals(nodeStatus)) {
                        NodeStatus nodeStatus2 = toStatus;
                        if (!(NodeStatus.Failed.equals(nodeStatus2) ? true : NodeStatus.Success.equals(nodeStatus2))) {
                            this.logger().warn(new StringBuilder(63).append(this.toString()).append(" attempt to change a Executor from ShuttingDown to ").append(toStatus).append(", ignore it.").toString());
                            break block6;
                        }
                    }
                    this.logger().info(new StringBuilder(21).append(this.toString()).append(" changed status ").append(this.status()).append(" => ").append(toStatus).append(".").toString());
                    this.status_$eq(toStatus);
                    break block7;
                }
                return;
            }
        }
    }

    @Override
    public void transitionHealthy(NodeHealthy toHealthy) {
        Object object = this.healthyLocker();
        synchronized (object) {
            this.logger().info(new StringBuilder(21).append("nodeHealthy from ").append(this.healthy()).append(" to ").append(toHealthy).toString());
            this.healthy_$eq(toHealthy);
        }
    }

    @Override
    @Receiver
    public void dealNodeHealthyRequest(NodeHealthyRequest nodeHealthyRequest) {
        if (Predef$.MODULE$.Boolean2boolean(NodeHealthy.isAvailable((NodeHealthy)nodeHealthyRequest.getNodeHealthy()))) {
            this.setByManager_$eq(false);
            this.transitionHealthy(nodeHealthyRequest.getNodeHealthy());
            return;
        }
        this.setByManager_$eq(true);
        this.transitionHealthy(nodeHealthyRequest.getNodeHealthy());
    }

    public void org$apache$linkis$ecm$server$service$impl$DefaultECMHealthService$$checkMachinePerformance() {
        if (!ECMConfiguration$.MODULE$.ECM_PROTECTED_LOAD_ENABLED()) {
            return;
        }
        double cpuLoad = OverloadUtils$.MODULE$.getOSBean().getSystemCpuLoad();
        long freeMemory = HardwareUtils$.MODULE$.getAvailableMemory();
        if (cpuLoad > ECMConfiguration$.MODULE$.ECM_PROTECTED_CPU_LOAD() && this.lastCpuLoad() > ECMConfiguration$.MODULE$.ECM_PROTECTED_CPU_LOAD() || freeMemory < ECMConfiguration$.MODULE$.ECM_PROTECTED_MEMORY() && this.lastFreeMemory() < ECMConfiguration$.MODULE$.ECM_PROTECTED_MEMORY()) {
            this.logger().warn(new StringBuilder(73).append("cpuLoad(").append(cpuLoad).append(") and freeMemory(").append(ByteTimeUtils.bytesToString((long)freeMemory)).append(") overload prepare to mark ecm to StockAvailable").toString());
            if (Predef$.MODULE$.Boolean2boolean(NodeHealthy.isAvailable((NodeHealthy)this.getNodeHealthy()))) {
                this.transitionHealthy(NodeHealthy.StockAvailable);
            }
        } else if (!Predef$.MODULE$.Boolean2boolean(NodeHealthy.isAvailable((NodeHealthy)this.getNodeHealthy())) && !this.isSetByManager()) {
            this.logger().warn(new StringBuilder(65).append("cpuLoad(").append(cpuLoad).append(") and freeMemory(").append(ByteTimeUtils.bytesToString((long)freeMemory)).append(") recover prepare to mark ecm to Healthy").toString());
            this.transitionHealthy(NodeHealthy.Healthy);
        }
        this.lastCpuLoad_$eq(cpuLoad);
        this.lastFreeMemory_$eq(freeMemory);
    }

    public DefaultECMHealthService() {
        Logging.$init$((Logging)this);
        ECMEventListener.$init$((ECMEventListener)this);
        this.maxResource = ECMUtils$.MODULE$.initMaxResource();
        this.minResource = ECMUtils$.MODULE$.initMinResource();
        this.status = NodeStatus.Starting;
        this.healthy = NodeHealthy.Healthy;
        this.setByManager = false;
        this.lastCpuLoad = 0.0;
        this.lastFreeMemory = ECMUtils$.MODULE$.inferDefaultMemory();
        this.statusLocker = new Object();
        this.healthyLocker = new Object();
        this.future = Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ DefaultECMHealthService $outer;

            public void run() {
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (LinkisECMApplication.isReady()) {
                        $this.$outer.org$apache$linkis$ecm$server$service$impl$DefaultECMHealthService$$checkMachinePerformance();
                        $this.$outer.reportHealth($this.$outer.getLastEMHealthReport());
                        return;
                    }
                }, this.$outer.logger());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.ecm.server.service.impl.DefaultECMHealthService$$anon$1 )}, serializedLambda);
            }
        }, ECMConfiguration$.MODULE$.ECM_HEALTH_REPORT_DELAY(), ECMConfiguration$.MODULE$.ECM_HEALTH_REPORT_PERIOD(), TimeUnit.SECONDS);
    }
}

