/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.service.impl;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.List;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.common.utils.ZipUtils$;
import org.apache.linkis.ecm.core.engineconn.EngineConn;
import org.apache.linkis.ecm.core.launch.EngineConnManagerEnv;
import org.apache.linkis.ecm.errorcode.EngineconnServerErrorCodeSummary;
import org.apache.linkis.ecm.server.exception.ECMErrorException;
import org.apache.linkis.ecm.server.service.LocalDirsHandleService;
import org.apache.linkis.ecm.server.service.ResourceLocalizationService;
import org.apache.linkis.ecm.server.util.ECMUtils$;
import org.apache.linkis.manager.common.protocol.bml.BmlResource;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnLaunchRequest;
import org.apache.linkis.manager.engineplugin.common.launch.process.ProcessEngineConnLaunchRequest;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u000b\u0017\u0001\u0015BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013-Q\b\u0003\u0004F\u0001\u0001\u0006IA\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u00139\u0005B\u0002*\u0001A\u0003%\u0001\nC\u0005T\u0001\u0001\u0007\t\u0019!C\u0005)\"I\u0001\f\u0001a\u0001\u0002\u0004%I!\u0017\u0005\n?\u0002\u0001\r\u0011!Q!\nUC\u0011\u0002\u0019\u0001A\u0002\u0003\u0007I\u0011B1\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"C8\u0001\u0001\u0004\u0005\t\u0015)\u0003c\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u00151\b\u0001\"\u0011x\u0011!\t\t\u0003\u0001b\u0001\n\u00139\u0005bBA\u0012\u0001\u0001\u0006I\u0001\u0013\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007\u0012aDQ7m%\u0016\u001cx.\u001e:dK2{7-\u00197ju\u0006$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005]A\u0012\u0001B5na2T!!\u0007\u000e\u0002\u000fM,'O^5dK*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005uq\u0012aA3d[*\u0011q\u0004I\u0001\u0007Y&t7.[:\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0005\f\u0019\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u0019\u0013\ty\u0003DA\u000eSKN|WO]2f\u0019>\u001c\u0017\r\\5{CRLwN\\*feZL7-\u001a\t\u0003cYj\u0011A\r\u0006\u0003gQ\nQ!\u001e;jYNT!!\u000e\u0010\u0002\r\r|W.\\8o\u0013\t9$GA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Q\u0004CA\u001e\u0001\u001b\u00051\u0012A\u00014t+\u0005q\u0004CA D\u001b\u0005\u0001%B\u0001\u001fB\u0015\t\u0011e$A\u0004ti>\u0014\u0018mZ3\n\u0005\u0011\u0003%A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006\u0019am\u001d\u0011\u0002\u0013M,\u0007/\u001a:bi>\u0014X#\u0001%\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001\u00027b]\u001eT\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n11\u000b\u001e:j]\u001e\f!b]3qKJ\fGo\u001c:!\u0003\u0019\u00198\r[3nC\u000691o\u00195f[\u0006\u0004\u0013A\u00067pG\u0006dG)\u001b:t\u0011\u0006tG\r\\3TKJ4\u0018nY3\u0016\u0003U\u0003\"!\f,\n\u0005]C\"A\u0006'pG\u0006dG)\u001b:t\u0011\u0006tG\r\\3TKJ4\u0018nY3\u000251|7-\u00197ESJ\u001c\b*\u00198eY\u0016\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005ik\u0006CA\u0014\\\u0013\ta\u0006F\u0001\u0003V]&$\bb\u00020\n\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0014a\u00067pG\u0006dG)\u001b:t\u0011\u0006tG\r\\3TKJ4\u0018nY3!\u0003%\u0019\bO]5oO\u0016sg/F\u0001c!\t\u0019'.D\u0001e\u0015\t)g-A\u0002f]ZT!a\u001a5\u0002\t\r|'/\u001a\u0006\u0003S\n\nqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003W\u0012\u00141\"\u00128wSJ|g.\\3oi\u0006i1\u000f\u001d:j]\u001e,eN^0%KF$\"A\u00178\t\u000fyc\u0011\u0011!a\u0001E\u0006Q1\u000f\u001d:j]\u001e,eN\u001e\u0011\u00023M,G\u000fT8dC2$\u0015N]:IC:$G.Z*feZL7-\u001a\u000b\u00035JDQa\u0015\bA\u0002U\u000bAb]3u'B\u0014\u0018N\\4F]Z$\"AW;\t\u000b\u0001|\u0001\u0019\u00012\u0002;!\fg\u000e\u001a7f\u0013:LG/\u00128hS:,7i\u001c8o%\u0016\u001cx.\u001e:dKN$BA\u0017=\u0002\u0010!)\u0011\u0010\u0005a\u0001u\u00069!/Z9vKN$\bcA>\u0002\f5\tAP\u0003\u0002~}\u00061QM\u001c;jifT1a`A\u0001\u0003\u0019a\u0017-\u001e8dQ*\u0019Q'a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0004\u0003\u0013q\u0012aB7b]\u0006<WM]\u0005\u0004\u0003\u001ba(aF#oO&tWmQ8o]2\u000bWO\\2i%\u0016\fX/Z:u\u0011\u001d\t\t\u0002\u0005a\u0001\u0003'\t!\"\u001a8hS:,7i\u001c8o!\u0011\t)\"!\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t!\"\u001a8hS:,7m\u001c8o\u0015\t9G$\u0003\u0003\u0002 \u0005]!AC#oO&tWmQ8o]\u0006\t\"-\u001c7SKN|WO]2f'V4g-\u001b=\u0002%\tlGNU3t_V\u00148-Z*vM\u001aL\u0007\u0010I\u0001\u0013GJ,\u0017\r^3ESJLeMT8u\u000bbLG\u000f\u0006\u0003\u0002*\u0005u\u0002\u0003BA\u0016\u0003sqA!!\f\u00026A\u0019\u0011q\u0006\u0015\u000e\u0005\u0005E\"bAA\u001aI\u00051AH]8pizJ1!a\u000e)\u0003\u0019\u0001&/\u001a3fM&\u0019q*a\u000f\u000b\u0007\u0005]\u0002\u0006C\u0004\u0002@M\u0001\r!!\u000b\u0002\u00199|7k\u00195f[\u0006\u0004\u0016\r\u001e5\u0002'\u0011|wO\u001c7pC\u0012\u0014U\u000e\u001c*fg>,(oY3\u0015\u0013i\u000b)%a\u0015\u0002h\u0005u\u0004BB=\u0015\u0001\u0004\t9\u0005\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tiE`\u0001\baJ|7-Z:t\u0013\u0011\t\t&a\u0013\u0003=A\u0013xnY3tg\u0016sw-\u001b8f\u0007>tg\u000eT1v]\u000eD'+Z9vKN$\bbBA+)\u0001\u0007\u0011qK\u0001\tY&t7\u000eR5sgBA\u0011\u0011LA2\u0003S\tI#\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u001diW\u000f^1cY\u0016T1!!\u0019)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\nYFA\u0004ICNDW*\u00199\t\u000f\u0005%D\u00031\u0001\u0002l\u0005A!/Z:pkJ\u001cW\r\u0005\u0003\u0002n\u0005eTBAA8\u0015\u0011\t\t(a\u001d\u0002\u0007\tlGN\u0003\u0003\u0002v\u0005]\u0014\u0001\u00039s_R|7m\u001c7\u000b\u0007U\n9!\u0003\u0003\u0002|\u0005=$a\u0003\"nYJ+7o\\;sG\u0016Dq!a \u0015\u0001\u0004\tI#A\u0004x_J\\G)\u001b:")
public class BmlResourceLocalizationService
implements ResourceLocalizationService,
Logging {
    private final FileSystem fs;
    private final String seperator;
    private final String schema;
    private LocalDirsHandleService localDirsHandleService;
    private Environment org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv;
    private final String bmlResourceSuffix;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        BmlResourceLocalizationService bmlResourceLocalizationService = this;
        synchronized (bmlResourceLocalizationService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private String seperator() {
        return this.seperator;
    }

    private String schema() {
        return this.schema;
    }

    private LocalDirsHandleService localDirsHandleService() {
        return this.localDirsHandleService;
    }

    private void localDirsHandleService_$eq(LocalDirsHandleService x$1) {
        this.localDirsHandleService = x$1;
    }

    public Environment org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv() {
        return this.org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv;
    }

    private void org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv_$eq(Environment x$1) {
        this.org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv = x$1;
    }

    public void setLocalDirsHandleService(LocalDirsHandleService localDirsHandleService) {
        this.localDirsHandleService_$eq(localDirsHandleService);
    }

    public void setSpringEnv(Environment springEnv) {
        this.org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv_$eq(springEnv);
    }

    @Override
    public void handleInitEngineConnResources(EngineConnLaunchRequest request, EngineConn engineConn) {
        EngineConnLaunchRequest engineConnLaunchRequest = request;
        if (engineConnLaunchRequest instanceof ProcessEngineConnLaunchRequest) {
            ProcessEngineConnLaunchRequest processEngineConnLaunchRequest = (ProcessEngineConnLaunchRequest)engineConnLaunchRequest;
            List files = processEngineConnLaunchRequest.bmlResources();
            HashMap linkDirsP = new HashMap();
            String user = processEngineConnLaunchRequest.user();
            String ticketId = processEngineConnLaunchRequest.ticketId();
            String engineType = LabelUtil$.MODULE$.getEngineType(processEngineConnLaunchRequest.labels());
            String workDir = this.createDirIfNotExit(this.localDirsHandleService().getEngineConnWorkDir(user, ticketId, engineType));
            String emHomeDir = this.createDirIfNotExit(this.localDirsHandleService().getEngineConnManagerHomeDir());
            String logDirs = this.createDirIfNotExit(this.localDirsHandleService().getEngineConnLogDir(user, ticketId, engineType));
            String tmpDirs = this.createDirIfNotExit(this.localDirsHandleService().getEngineConnTmpDir(user, ticketId, engineType));
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(files).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                this.downloadBmlResource(processEngineConnLaunchRequest, (HashMap<String, String>)linkDirsP, x$1, workDir);
                return BoxedUnit.UNIT;
            });
            engineConn.getEngineConnLaunchRunner().getEngineConnLaunch().setEngineConnManagerEnv(new EngineConnManagerEnv(this, emHomeDir, workDir, logDirs, tmpDirs, linkDirsP){
                private final String engineConnManagerHomeDir;
                private final String engineConnWorkDir;
                private final String engineConnLogDirs;
                private final String engineConnTempDirs;
                private final String engineConnManagerHost;
                private final String engineConnManagerPort;
                private final HashMap<String, String> linkDirs;
                private final Map<String, String> properties;

                public String engineConnManagerHomeDir() {
                    return this.engineConnManagerHomeDir;
                }

                public String engineConnWorkDir() {
                    return this.engineConnWorkDir;
                }

                public String engineConnLogDirs() {
                    return this.engineConnLogDirs;
                }

                public String engineConnTempDirs() {
                    return this.engineConnTempDirs;
                }

                public String engineConnManagerHost() {
                    return this.engineConnManagerHost;
                }

                public String engineConnManagerPort() {
                    return this.engineConnManagerPort;
                }

                public HashMap<String, String> linkDirs() {
                    return this.linkDirs;
                }

                public Map<String, String> properties() {
                    return this.properties;
                }
                {
                    this.engineConnManagerHomeDir = emHomeDir$1;
                    this.engineConnWorkDir = workDir$1;
                    this.engineConnLogDirs = logDirs$1;
                    this.engineConnTempDirs = tmpDirs$1;
                    String hostName = Utils$.MODULE$.getComputerName();
                    boolean preferIpAddress = Configuration$.MODULE$.PREFER_IP_ADDRESS();
                    $outer.logger().info(new StringBuilder(16).append("preferIpAddress:").append(preferIpAddress).toString());
                    if (preferIpAddress) {
                        hostName = $outer.org$apache$linkis$ecm$server$service$impl$BmlResourceLocalizationService$$springEnv().getProperty("spring.cloud.client.ip-address");
                        $outer.logger().info(new StringBuilder(9).append("hostName:").append(hostName).toString());
                        $outer.logger().info("using ip address replace hostname, because linkis.discovery.prefer-ip-address: true");
                    }
                    this.engineConnManagerHost = hostName;
                    this.engineConnManagerPort = DataWorkCloudApplication.getApplicationContext().getEnvironment().getProperty("server.port");
                    this.linkDirs = linkDirsP$1;
                    this.properties = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                }
            });
            return;
        }
    }

    private String bmlResourceSuffix() {
        return this.bmlResourceSuffix;
    }

    private String createDirIfNotExit(String noSchemaPath) {
        Object object;
        FsPath fsPath = new FsPath(new StringBuilder(0).append(this.schema()).append(noSchemaPath).toString());
        if (!this.fs().exists(fsPath)) {
            FileSystemUtils$.MODULE$.mkdirs(this.fs(), fsPath, Utils$.MODULE$.getJvmUser());
            object = BoxesRunTime.boxToBoolean((boolean)this.fs().setPermission(fsPath, "rwxrwxrwx"));
        } else {
            object = BoxedUnit.UNIT;
        }
        return noSchemaPath;
    }

    public void downloadBmlResource(ProcessEngineConnLaunchRequest request, HashMap<String, String> linkDirs, BmlResource resource, String workDir) {
        String resourceId = resource.getResourceId();
        String version = resource.getVersion();
        String user = request.user();
        BmlResource.BmlResourceVisibility bmlResourceVisibility = resource.getVisibility();
        if (BmlResource.BmlResourceVisibility.Public.equals(bmlResourceVisibility)) {
            FsPathListWithError dirAndFileList;
            Buffer paths;
            BoxedUnit boxedUnit;
            String publicDir = this.localDirsHandleService().getEngineConnPublicDir();
            String bmlResourceDir = new StringBuilder(0).append(this.schema()).append(Paths.get(publicDir, resourceId, version).toFile().getPath()).toString();
            FsPath fsPath = new FsPath(bmlResourceDir);
            if (!this.fs().exists(fsPath)) {
                String string = resourceId.intern();
                synchronized (string) {
                    Object object;
                    if (!this.fs().exists(fsPath)) {
                        ECMUtils$.MODULE$.downLoadBmlResourceToLocal(resource, user, fsPath.getPath(), this.fs());
                        String unzipDir = new StringBuilder(0).append(fsPath.getSchemaPath()).append(File.separator).append(resource.getFileName().substring(0, resource.getFileName().lastIndexOf("."))).toString();
                        FileSystemUtils$.MODULE$.mkdirs(this.fs(), new FsPath(unzipDir), Utils$.MODULE$.getJvmUser());
                        String path2 = new StringBuilder(0).append(bmlResourceDir).append(File.separator).append(resource.getFileName()).toString();
                        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ZipUtils$.MODULE$.unzip(path2, unzipDir, (Fs)this.fs()), (Function1 & Serializable & scala.Serializable)t -> {
                            BmlResourceLocalizationService.$anonfun$downloadBmlResource$2(this, fsPath, t);
                            return BoxedUnit.UNIT;
                        });
                        this.logger().info(new StringBuilder(34).append("Finished to download bml resource ").append(fsPath.getPath()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)this.fs().delete(new FsPath(new StringBuilder(0).append(bmlResourceDir).append(File.separator).append(resource.getFileName()).toString())));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = object;
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 13, 15] lbl26 : MonitorExitStatement: MONITOREXIT : var13_12
                    boxedUnit = boxedUnit2;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ((paths = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((dirAndFileList = this.fs().listPathWithError(fsPath)).getFsPaths()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BmlResourceLocalizationService.$anonfun$downloadBmlResource$4(x$2)))) {
                this.logger().info(new StringBuilder(30).append("Start to wait fs path to init ").append(fsPath.getPath()).toString());
                String string = resourceId.intern();
                synchronized (string) {
                    this.logger().info(new StringBuilder(34).append("Finished to wait fs path to init ").append(fsPath.getPath()).append(" ").toString());
                }
                paths = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.fs().listPathWithError(fsPath).getFsPaths()).asScala();
            }
            paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
                String name = new File(path.getPath()).getName();
                return linkDirs.put((Object)path.getPath(), (Object)new StringBuilder(0).append(workDir).append(this.seperator()).append(name).toString());
            });
            return;
        }
        if (BmlResource.BmlResourceVisibility.Private.equals(bmlResourceVisibility)) {
            Object object;
            this.logger().info(new StringBuilder(82).append("Try to download private BmlResource(resourceId: ").append(resourceId).append(", version: ").append(version).append(", fileName: ").append(resource.getFileName()).append(") to path ").append(workDir).append(".").toString());
            FsPath fsPath = new FsPath(new StringBuilder(0).append(this.schema()).append(workDir).toString());
            Object object2 = !this.fs().exists(fsPath) ? BoxesRunTime.boxToBoolean((boolean)FileSystemUtils$.MODULE$.mkdirs(this.fs(), fsPath, Utils$.MODULE$.getJvmUser())) : BoxedUnit.UNIT;
            ECMUtils$.MODULE$.downLoadBmlResourceToLocal(resource, user, fsPath.getPath(), this.fs());
            String filePath = new StringBuilder(0).append(this.schema()).append(workDir).append(File.separator).append(resource.getFileName()).toString();
            if (resource.getFileName() != null && resource.getFileName().endsWith(".zip")) {
                this.logger().info(new StringBuilder(59).append("Try to unzip ").append(filePath).append(", since the private BMLResource is a zip file.").toString());
                ZipUtils$.MODULE$.unzip(filePath, fsPath.getSchemaPath(), (Fs)this.fs());
                object = BoxesRunTime.boxToBoolean((boolean)this.fs().delete(new FsPath(filePath)));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.logger().info(new StringBuilder(87).append("Finished to download private BmlResource(resourceId: ").append(resourceId).append(", version: ").append(version).append(", fileName: ").append(resource.getFileName()).append(") to path ").append(filePath).append(".").toString());
            return;
        }
        if (BmlResource.BmlResourceVisibility.Label.equals(bmlResourceVisibility)) {
            this.logger().error(new StringBuilder(99).append("Not supported BmlResource visibility type: label. BmlResource: resourceId: ").append(resourceId).append(", version: ").append(version).append(", fileName: ").append(resource.getFileName()).append(".").toString());
            throw new ECMErrorException(EngineconnServerErrorCodeSummary.NOT_SUPPORTED_TYPE.getErrorCode(), EngineconnServerErrorCodeSummary.NOT_SUPPORTED_TYPE.getErrorDesc());
        }
        throw new MatchError((Object)bmlResourceVisibility);
    }

    public static final /* synthetic */ void $anonfun$downloadBmlResource$2(BmlResourceLocalizationService $this, FsPath fsPath$1, Throwable t) {
        $this.logger().error("Failed to unzip path", t);
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.fs().delete(fsPath$1), $this.logger());
    }

    public static final /* synthetic */ boolean $anonfun$downloadBmlResource$4(FsPath x$2) {
        return x$2.getPath().endsWith(".zip");
    }

    public BmlResourceLocalizationService() {
        Logging.$init$((Logging)this);
        this.fs = (FileSystem)FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.FILE());
        this.fs().init(null);
        this.seperator = File.separator;
        this.schema = StorageUtils$.MODULE$.FILE_SCHEMA();
        this.bmlResourceSuffix = ".zip";
    }
}

