/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.scheduled;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EcmClearTask {
    private Logger logger = LoggerFactory.getLogger(EcmClearTask.class);
    public static final String shellPath = Configuration.getLinkisHome() + "/admin/";

    @PostConstruct
    public void init() {
        this.logger.info("Schedule Task is init");
        CleanExpiredThread cleanExpiredThread = new CleanExpiredThread();
        Utils.defaultScheduler().scheduleAtFixedRate(cleanExpiredThread, 10L, 86400L, TimeUnit.SECONDS);
    }

    private class CleanExpiredThread
    implements Runnable {
        private CleanExpiredThread() {
        }

        @Override
        public void run() {
            EcmClearTask.this.logger.info("Start to linkis-ec-clear shell");
            ArrayList<String> cmdlist = new ArrayList<String>();
            cmdlist.add("sh");
            cmdlist.add(shellPath + "linkis-ec-clear.sh");
            try {
                Utils.exec((String[])cmdlist.toArray(new String[0]), (long)1800000L);
            }
            catch (Exception e) {
                EcmClearTask.this.logger.warn("Shell linkis-ec-clear.sh execution failed, msg:" + e.getMessage());
            }
            EcmClearTask.this.logger.info("End to linkis-ec-clear shell");
        }
    }
}

