/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.AnyType;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.select.SubSelect;

public class AnyComparisonExpression
extends ASTNodeAccessImpl
implements Expression {
    private final ItemsList itemsList;
    private boolean useBracketsForValues = false;
    private final SubSelect subSelect;
    private final AnyType anyType;

    public AnyComparisonExpression(AnyType anyType, SubSelect subSelect) {
        this.anyType = anyType;
        this.subSelect = subSelect;
        this.itemsList = null;
    }

    public AnyComparisonExpression(AnyType anyType, ItemsList itemsList) {
        this.anyType = anyType;
        this.itemsList = itemsList;
        this.subSelect = null;
    }

    public SubSelect getSubSelect() {
        return this.subSelect;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public boolean isUsingItemsList() {
        return this.itemsList != null;
    }

    public boolean isUsingSubSelect() {
        return this.subSelect != null;
    }

    public boolean isUsingBracketsForValues() {
        return this.useBracketsForValues;
    }

    public void setUseBracketsForValues(boolean useBracketsForValues) {
        this.useBracketsForValues = useBracketsForValues;
    }

    public AnyComparisonExpression withUseBracketsForValues(boolean useBracketsForValues) {
        this.setUseBracketsForValues(useBracketsForValues);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public AnyType getAnyType() {
        return this.anyType;
    }

    public String toString() {
        String s = this.anyType.name() + " (" + (this.subSelect != null ? this.subSelect.toString() : "VALUES " + this.itemsList.toString()) + " )";
        return s;
    }
}

