/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.message.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.errorcode.LinkisRpcErrorCodeSummary;
import org.apache.linkis.rpc.message.exception.MessageErrorException;
import org.apache.linkis.rpc.message.exception.MessageWarnException;
import org.apache.linkis.rpc.message.method.MethodExecuteWrapper;
import org.apache.linkis.rpc.message.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MessageExecutor.class);

    private List<MethodExecuteWrapper> getMinOrderMethodWrapper(Map<String, List<MethodExecuteWrapper>> methodWrappers) {
        ArrayList<MethodExecuteWrapper> minOrderMethodWrapper = new ArrayList<MethodExecuteWrapper>();
        methodWrappers.forEach((k, v) -> minOrderMethodWrapper.addAll(MessageUtils.getMinOrders(v)));
        return minOrderMethodWrapper;
    }

    public Object execute(RequestProtocol requestProtocol, Map<String, List<MethodExecuteWrapper>> methodWrappers, Sender sender) throws InterruptedException, MessageErrorException {
        Integer count = methodWrappers.values().stream().map(List::size).reduce(0, Integer::sum);
        if (count == 1) {
            return this.executeOneMethod(requestProtocol, methodWrappers, sender);
        }
        throw new MessageErrorException(120001, String.format("find %s method for the rpc request:%s", count, requestProtocol.getClass().getName()));
    }

    private Object executeOneMethod(RequestProtocol requestProtocol, Map<String, List<MethodExecuteWrapper>> methodWrappers, Sender sender) {
        List<MethodExecuteWrapper> methodExecuteWrappers = this.getMinOrderMethodWrapper(methodWrappers);
        Object result = null;
        if (methodExecuteWrappers.size() == 1) {
            MethodExecuteWrapper methodWrapper = methodExecuteWrappers.get(0);
            try {
                if (!methodWrapper.isShouldSkip()) {
                    Method method = methodWrapper.getMethod();
                    Object service = methodWrapper.getService();
                    result = methodWrapper.isHasSender() ? (methodWrapper.isSenderOnLeft() ? method.invoke(service, sender, requestProtocol) : method.invoke(service, requestProtocol, sender)) : method.invoke(service, requestProtocol);
                }
            }
            catch (Throwable t) {
                logger.warn(String.format("method %s call failed", methodWrapper.getAlias()), t);
                String errorMsg = t instanceof InvocationTargetException ? "method call failed: " + ((InvocationTargetException)t).getTargetException().getMessage() : "method call failed.";
                throw new MessageWarnException(LinkisRpcErrorCodeSummary.METHOD_CALL_FAILED.getErrorCode(), errorMsg, t);
            }
        }
        return result;
    }
}

