/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.interceptor.common;

import feign.RetryableException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.RetryHandler;
import org.apache.linkis.protocol.Protocol;
import org.apache.linkis.protocol.RetryableProtocol;
import org.apache.linkis.rpc.conf.RPCConfiguration$;
import org.apache.linkis.rpc.exception.DWCRPCRetryException;
import org.apache.linkis.rpc.exception.DWCRPCRetryException$;
import org.apache.linkis.rpc.interceptor.RPCInterceptor;
import org.apache.linkis.rpc.interceptor.RPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.RPCInterceptorExchange;
import org.apache.linkis.rpc.interceptor.ServiceInstanceRPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.common.RetryableRPCInterceptor$;
import org.apache.linkis.rpc.utils.RPCUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\t\u0013\u0001}AQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005s\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\r\u0005\u0006i\u0001!\t%\u000e\u0004\u0005\u0007\u0002\u0001A\tC\u0003+\u000b\u0011\u0005A\nC\u0004P\u000b\u0001\u0007I\u0011\u0002)\t\u000fa+\u0001\u0019!C\u00053\"1q,\u0002Q!\nECQ\u0001Y\u0003\u0005\u0002\u0005DQa[\u0003\u0005\n1DQA`\u0003\u0005B}<q!!\u0006\u0013\u0011\u0003\t9B\u0002\u0004\u0012%!\u0005\u0011\u0011\u0004\u0005\u0007U9!\t!a\u0007\t\u000f\u0005ua\u0002\"\u0001\u0002 \t9\"+\u001a;ss\u0006\u0014G.\u001a*Q\u0007&sG/\u001a:dKB$xN\u001d\u0006\u0003'Q\taaY8n[>t'BA\u000b\u0017\u0003-Ig\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u0005]A\u0012a\u0001:qG*\u0011\u0011DG\u0001\u0007Y&t7.[:\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dBS\"\u0001\u000b\n\u0005%\"\"A\u0004*Q\u0007&sG/\u001a:dKB$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003I\tQa\u001c:eKJ,\u0012\u0001\r\t\u0003CEJ!A\r\u0012\u0003\u0007%sG/\u0001\u0004pe\u0012,'\u000fI\u0001\nS:$XM]2faR$2AN\u001d?!\t\ts'\u0003\u00029E\t\u0019\u0011I\\=\t\u000bi\"\u0001\u0019A\u001e\u0002'%tG/\u001a:dKB$xN]#yG\"\fgnZ3\u0011\u0005\u001db\u0014BA\u001f\u0015\u0005Y\u0011\u0006kQ%oi\u0016\u00148-\u001a9u_J,\u0005p\u00195b]\u001e,\u0007\"B \u0005\u0001\u0004\u0001\u0015!B2iC&t\u0007CA\u0014B\u0013\t\u0011ECA\nS!\u000eKe\u000e^3sG\u0016\u0004Ho\u001c:DQ\u0006LgNA\bS!\u000e\u0013V\r\u001e:z\u0011\u0006tG\r\\3s'\r)\u0001%\u0012\t\u0003\r*k\u0011a\u0012\u0006\u0003\u0011&\u000bQ!\u001e;jYNT!a\u0005\r\n\u0005-;%\u0001\u0004*fiJL\b*\u00198eY\u0016\u0014H#A'\u0011\u00059+Q\"\u0001\u0001\u0002\u001fM,'O^5dK&s7\u000f^1oG\u0016,\u0012!\u0015\t\u0004CI#\u0016BA*#\u0005\u0019y\u0005\u000f^5p]B\u0011QKV\u0007\u0002\u0013&\u0011q+\u0013\u0002\u0010'\u0016\u0014h/[2f\u0013:\u001cH/\u00198dK\u0006\u00192/\u001a:wS\u000e,\u0017J\\:uC:\u001cWm\u0018\u0013fcR\u0011!,\u0018\t\u0003CmK!\u0001\u0018\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b=\"\t\t\u00111\u0001R\u0003\rAH%M\u0001\u0011g\u0016\u0014h/[2f\u0013:\u001cH/\u00198dK\u0002\nAb]3u%\u0016$(/_%oM>$2A\u00172k\u0011\u0015\u0019'\u00021\u0001e\u0003\u0015\u0011X\r\u001e:z!\t)\u0007.D\u0001g\u0015\t9\u0007$\u0001\u0005qe>$xnY8m\u0013\tIgMA\tSKR\u0014\u00180\u00192mKB\u0013x\u000e^8d_2DQa\u0010\u0006A\u0002\u0001\u000bA#[:O_N+'O^5dK\u0016C8-\u001a9uS>tGCA7q!\t\tc.\u0003\u0002pE\t9!i\\8mK\u0006t\u0007\"B9\f\u0001\u0004\u0011\u0018!\u0001;\u0011\u0005M\\hB\u0001;z\u001d\t)\b0D\u0001w\u0015\t9h$\u0001\u0004=e>|GOP\u0005\u0002G%\u0011!PI\u0001\ba\u0006\u001c7.Y4f\u0013\taXPA\u0005UQJ|w/\u00192mK*\u0011!PI\u0001\u0012Kb\u001cW\r\u001d;j_:\u001c\u0015M\u001c*fiJLHcA7\u0002\u0002!)\u0011\u000f\u0004a\u0001e\"\u001a\u0001!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0007\u0005=A$A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\u0011\t\u0019\"!\u0003\u0003\u0013\r{W\u000e]8oK:$\u0018a\u0006*fiJL\u0018M\u00197f%B\u001b\u0015J\u001c;fe\u000e,\u0007\u000f^8s!\ticb\u0005\u0002\u000fAQ\u0011\u0011qC\u0001\u0014SN\u0014V\r\u001e:zC\ndW\r\u0015:pi>\u001cw\u000e\u001c\u000b\u0004[\u0006\u0005\u0002BBA\u0012!\u0001\u0007a'A\u0004nKN\u001c\u0018mZ3")
public class RetryableRPCInterceptor
implements RPCInterceptor {
    private final int order;

    public static boolean isRetryableProtocol(Object object) {
        return RetryableRPCInterceptor$.MODULE$.isRetryableProtocol(object);
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public Object intercept(RPCInterceptorExchange interceptorExchange, RPCInterceptorChain chain) {
        Protocol protocol = interceptorExchange.getProtocol();
        if (protocol instanceof RetryableProtocol) {
            RetryableProtocol retryableProtocol = (RetryableProtocol)protocol;
            String retryName = retryableProtocol.getClass().getSimpleName();
            RPCRetryHandler retryHandler = new RPCRetryHandler();
            retryHandler.setRetryInfo(retryableProtocol, chain);
            return retryHandler.retry((Function0 & Serializable & scala.Serializable)() -> chain.handle(interceptorExchange), retryName);
        }
        return chain.handle(interceptorExchange);
    }

    public RetryableRPCInterceptor() {
        this.order = 20;
    }

    public class RPCRetryHandler
    implements RetryHandler {
        private Option<ServiceInstance> serviceInstance;
        private int org$apache$linkis$common$utils$RetryHandler$$retryNum;
        private long org$apache$linkis$common$utils$RetryHandler$$period;
        private long org$apache$linkis$common$utils$RetryHandler$$maxPeriod;
        private final ArrayBuffer<Class<? extends Throwable>> org$apache$linkis$common$utils$RetryHandler$$retryExceptions;
        private Logger logger;
        private volatile boolean bitmap$0;

        public void setRetryNum(int retryNum) {
            RetryHandler.setRetryNum$((RetryHandler)this, (int)retryNum);
        }

        public int getRetryNum() {
            return RetryHandler.getRetryNum$((RetryHandler)this);
        }

        public void setRetryPeriod(long retryPeriod) {
            RetryHandler.setRetryPeriod$((RetryHandler)this, (long)retryPeriod);
        }

        public long getRetryPeriod() {
            return RetryHandler.getRetryPeriod$((RetryHandler)this);
        }

        public void setRetryMaxPeriod(long retryMaxPeriod) {
            RetryHandler.setRetryMaxPeriod$((RetryHandler)this, (long)retryMaxPeriod);
        }

        public long getRetryMaxPeriod() {
            return RetryHandler.getRetryMaxPeriod$((RetryHandler)this);
        }

        public void addRetryException(Class<? extends Throwable> t) {
            RetryHandler.addRetryException$((RetryHandler)this, t);
        }

        public Class<? extends Throwable>[] getRetryExceptions() {
            return RetryHandler.getRetryExceptions$((RetryHandler)this);
        }

        public long nextInterval(int attempt) {
            return RetryHandler.nextInterval$((RetryHandler)this, (int)attempt);
        }

        public <T> T retry(Function0<T> op, String retryName) {
            return (T)RetryHandler.retry$((RetryHandler)this, op, (String)retryName);
        }

        public void trace(Function0<String> message) {
            Logging.trace$((Logging)this, message);
        }

        public void debug(Function0<String> message) {
            Logging.debug$((Logging)this, message);
        }

        public void info(Function0<String> message) {
            Logging.info$((Logging)this, message);
        }

        public void info(Function0<String> message, Throwable t) {
            Logging.info$((Logging)this, message, (Throwable)t);
        }

        public void warn(Function0<String> message) {
            Logging.warn$((Logging)this, message);
        }

        public void warn(Function0<String> message, Throwable t) {
            Logging.warn$((Logging)this, message, (Throwable)t);
        }

        public void error(Function0<String> message, Throwable t) {
            Logging.error$((Logging)this, message, (Throwable)t);
        }

        public void error(Function0<String> message) {
            Logging.error$((Logging)this, message);
        }

        public int org$apache$linkis$common$utils$RetryHandler$$retryNum() {
            return this.org$apache$linkis$common$utils$RetryHandler$$retryNum;
        }

        public void org$apache$linkis$common$utils$RetryHandler$$retryNum_$eq(int x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$retryNum = x$1;
        }

        public long org$apache$linkis$common$utils$RetryHandler$$period() {
            return this.org$apache$linkis$common$utils$RetryHandler$$period;
        }

        public void org$apache$linkis$common$utils$RetryHandler$$period_$eq(long x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$period = x$1;
        }

        public long org$apache$linkis$common$utils$RetryHandler$$maxPeriod() {
            return this.org$apache$linkis$common$utils$RetryHandler$$maxPeriod;
        }

        public void org$apache$linkis$common$utils$RetryHandler$$maxPeriod_$eq(long x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$maxPeriod = x$1;
        }

        public ArrayBuffer<Class<? extends Throwable>> org$apache$linkis$common$utils$RetryHandler$$retryExceptions() {
            return this.org$apache$linkis$common$utils$RetryHandler$$retryExceptions;
        }

        public final void org$apache$linkis$common$utils$RetryHandler$_setter_$org$apache$linkis$common$utils$RetryHandler$$retryExceptions_$eq(ArrayBuffer<Class<? extends Throwable>> x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$retryExceptions = x$1;
        }

        private Logger logger$lzycompute() {
            RPCRetryHandler rPCRetryHandler = this;
            synchronized (rPCRetryHandler) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$((Logging)this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private Option<ServiceInstance> serviceInstance() {
            return this.serviceInstance;
        }

        private void serviceInstance_$eq(Option<ServiceInstance> x$1) {
            this.serviceInstance = x$1;
        }

        public void setRetryInfo(RetryableProtocol retry, RPCInterceptorChain chain) {
            this.setRetryNum(RPCConfiguration$.MODULE$.RPC_RETRY_NUMBER());
            this.setRetryPeriod(RPCConfiguration$.MODULE$.RPC_RETRY_PERIOD());
            this.setRetryMaxPeriod(RPCConfiguration$.MODULE$.RPC_RETRY_PERIOD() * 2L);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])retry.retryExceptions())).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.addRetryException(t);
                return BoxedUnit.UNIT;
            });
            RPCInterceptorChain rPCInterceptorChain = chain;
            if (rPCInterceptorChain instanceof ServiceInstanceRPCInterceptorChain) {
                ServiceInstanceRPCInterceptorChain serviceInstanceRPCInterceptorChain = (ServiceInstanceRPCInterceptorChain)rPCInterceptorChain;
                this.serviceInstance_$eq((Option<ServiceInstance>)Option$.MODULE$.apply((Object)serviceInstanceRPCInterceptorChain.getServiceInstance()));
                return;
            }
        }

        private boolean isNoServiceException(Throwable t) {
            return RPCUtils$.MODULE$.isReceiverNotExists(t);
        }

        public boolean exceptionCanRetry(Throwable t) {
            Throwable throwable = t;
            if (throwable instanceof DWCRPCRetryException) {
                return true;
            }
            if (throwable instanceof LinkisRetryException) {
                LinkisRetryException linkisRetryException = (LinkisRetryException)throwable;
                return linkisRetryException.getErrCode() == DWCRPCRetryException$.MODULE$.RPC_RETRY_ERROR_CODE();
            }
            return this.serviceInstance().exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)RPCRetryHandler.$anonfun$exceptionCanRetry$1(s))) && this.isNoServiceException(t) || RetryHandler.exceptionCanRetry$((RetryHandler)this, (Throwable)t);
        }

        public /* synthetic */ RetryableRPCInterceptor org$apache$linkis$rpc$interceptor$common$RetryableRPCInterceptor$RPCRetryHandler$$$outer() {
            return RetryableRPCInterceptor.this;
        }

        public static final /* synthetic */ boolean $anonfun$exceptionCanRetry$1(ServiceInstance s) {
            return StringUtils.isBlank((CharSequence)s.getInstance());
        }

        public RPCRetryHandler() {
            if (RetryableRPCInterceptor.this == null) {
                throw null;
            }
            Logging.$init$((Logging)this);
            RetryHandler.$init$((RetryHandler)this);
            this.addRetryException(ConnectException.class);
            this.addRetryException(RetryableException.class);
            this.addRetryException(SocketTimeoutException.class);
            this.serviceInstance = None$.MODULE$;
        }
    }
}

