/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.linkis.storage.excel.ExcelXlsReader;
import org.apache.linkis.storage.excel.FirstRowDeal;
import org.apache.linkis.storage.excel.RowToCsvDeal;
import org.apache.linkis.storage.utils.StorageUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XlsUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<String>> getBasicInfo(InputStream inputStream) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        FirstRowDeal firstRowDeal = new FirstRowDeal();
        try (ExcelXlsReader xlsReader = new ExcelXlsReader();){
            xlsReader.init(firstRowDeal, inputStream);
            xlsReader.process();
        }
        return res;
    }

    public static String excelToCsv(InputStream inputStream, FileSystem fs, Boolean hasHeader, List<String> sheetNames) throws Exception {
        String hdfsPath = "/tmp/" + StorageUtils.getJvmUser() + "/" + System.currentTimeMillis() + ".csv";
        LOG.info("The excel to csv with hdfs path:" + hdfsPath);
        ExcelXlsReader xlsReader = new ExcelXlsReader();
        RowToCsvDeal rowToCsvDeal = new RowToCsvDeal();
        OutputStream out = null;
        try {
            out = fs.create(new Path(hdfsPath));
            rowToCsvDeal.init(hasHeader, sheetNames, out);
            xlsReader.init(rowToCsvDeal, inputStream);
            xlsReader.process();
        }
        catch (IOException e) {
            LOG.error("Failed to excel to csv", (Throwable)e);
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            xlsReader.close();
        }
        return hdfsPath;
    }

    public static Map<String, List<Map<String, String>>> getSheetsInfo(InputStream inputStream, Boolean hasHeader) {
        HSSFWorkbook workbook = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)0.005);
            workbook = new HSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ZipSecureFile.setMinInflateRatio((double)0.01);
        }
        LinkedHashMap<String, List<Map<String, String>>> res = new LinkedHashMap<String, List<Map<String, String>>>(workbook.getNumberOfSheets());
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            ArrayList rowList = new ArrayList();
            Row headerRow = sheet.getRow(0);
            for (int j = 0; j < headerRow.getPhysicalNumberOfCells(); ++j) {
                LinkedHashMap<String, String> sheetMap = new LinkedHashMap<String, String>();
                Cell cell = headerRow.getCell(j);
                if (hasHeader.booleanValue()) {
                    sheetMap.put(cell.getStringCellValue(), "string");
                } else {
                    sheetMap.put("col_" + (j + 1), "string");
                }
                rowList.add(sheetMap);
            }
            res.put(sheet.getSheetName(), rowList);
        }
        return res;
    }
}

