/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.publicservice.common.lock.service.impl;

import java.util.List;
import org.apache.linkis.publicservice.common.lock.dao.CommonLockMapper;
import org.apache.linkis.publicservice.common.lock.entity.CommonLock;
import org.apache.linkis.publicservice.common.lock.service.CommonLockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class DefaultCommonLockService
implements CommonLockService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommonLockService.class);
    private CommonLockMapper commonLockMapper;

    public CommonLockMapper getLockManagerMapper() {
        return this.commonLockMapper;
    }

    public void setLockManagerMapper(CommonLockMapper commonLockMapper) {
        this.commonLockMapper = commonLockMapper;
    }

    @Override
    public Boolean lock(CommonLock commonLock, Long timeOut) {
        long startTime = System.currentTimeMillis();
        Boolean isLocked = this.tryLock(commonLock, timeOut);
        while (!isLocked.booleanValue() && System.currentTimeMillis() - startTime < timeOut) {
            try {
                Thread.sleep(1000L);
                isLocked = this.tryLock(commonLock, timeOut);
            }
            catch (InterruptedException e) {
                logger.warn("lock waiting interrupted", (Throwable)e);
            }
        }
        return isLocked;
    }

    @Override
    public Boolean reentrantLock(CommonLock commonLock, Long timeOut) {
        CommonLock oldLock = this.commonLockMapper.getLockByLocker(commonLock.getLockObject(), commonLock.getLocker());
        if (oldLock != null) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        Boolean isLocked = this.tryLock(commonLock, timeOut);
        while (!isLocked.booleanValue() && System.currentTimeMillis() - startTime < timeOut) {
            try {
                Thread.sleep(1000L);
                isLocked = this.tryLock(commonLock, timeOut);
            }
            catch (InterruptedException e) {
                logger.warn("lock waiting interrupted", (Throwable)e);
            }
        }
        return isLocked;
    }

    private boolean tryLock(CommonLock commonLock, Long timeOut) {
        try {
            this.commonLockMapper.lock(commonLock, timeOut);
            return true;
        }
        catch (DataAccessException e) {
            logger.warn("Failed to obtain lock:" + commonLock.getLockObject());
            return false;
        }
    }

    @Override
    public void unlock(CommonLock commonLock) {
        this.commonLockMapper.unlock(commonLock);
    }

    @Override
    public List<CommonLock> getAll() {
        return this.commonLockMapper.getAll();
    }
}

