/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.utils;

import java.io.Serializable;
import org.apache.linkis.orchestrator.domain.TreeNode;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorException;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.PhysicalContext;
import org.apache.linkis.orchestrator.strategy.ExecTaskStatusInfo;
import org.apache.linkis.orchestrator.strategy.StatusInfoExecTask$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TreeNodeUtil$ {
    public static TreeNodeUtil$ MODULE$;

    static {
        new TreeNodeUtil$();
    }

    private void bloodCheck(ExecTask parentNode, ExecTask childNode) {
        if (parentNode != null && childNode != null) {
            ExecTask[] children = (ExecTask[])parentNode.getChildren();
            if (children == null || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).contains((Object)childNode)) {
                throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.JOB_REQUEST_PARAM_ILLEGAL_ERROR_CODE(), "the parent node does not contain the child node(\u8be5\u7236\u8282\u70b9\u4e0d\u76f4\u63a5\u5305\u542b\u8be5\u5b50\u8282\u70b9)");
            }
            ExecTask[] parents = (ExecTask[])childNode.getParents();
            if (parents == null || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents)).contains((Object)parentNode)) {
                throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.JOB_REQUEST_PARAM_ILLEGAL_ERROR_CODE(), "the child node does not belong the parent node(\u8be5\u5b50\u8282\u70b9\u4e0d\u76f4\u63a5\u5c5e\u4e8e\u8be5\u7236\u8282\u70b9)");
            }
            return;
        }
        throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.JOB_REQUEST_PARAM_ILLEGAL_ERROR_CODE(), "parameter is null, please check again");
    }

    public void insertNode(ExecTask parentNode, ExecTask childNode, ExecTask insertNode) {
        this.bloodCheck(parentNode, childNode);
        this.pruningTreeNode(parentNode, childNode);
        this.relateParentWithChild(parentNode, insertNode);
        this.relateParentWithChild(insertNode, childNode);
    }

    public void pruningTreeNode(ExecTask parentNode, ExecTask childNode) {
        this.bloodCheck(parentNode, childNode);
        ExecTask[] children = (ExecTask[])parentNode.getChildren();
        ExecTask[] newChildren = (ExecTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TreeNodeUtil$.$anonfun$pruningTreeNode$1(childNode, x$1)));
        parentNode.withNewChildren((TreeNode[])newChildren);
        ExecTask[] parents = (ExecTask[])childNode.getParents();
        ExecTask[] newParents = (ExecTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TreeNodeUtil$.$anonfun$pruningTreeNode$2(parentNode, x$2)));
        childNode.withNewParents((TreeNode[])newParents);
    }

    public void relateParentWithChild(ExecTask parentNode, ExecTask childNode) {
        if (parentNode != null && childNode != null) {
            ArrayBuffer buffer = new ArrayBuffer();
            ExecTask[] parents = (ExecTask[])childNode.getParents();
            buffer.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents)));
            buffer.$plus$eq((Object)parentNode);
            childNode.withNewParents((TreeNode[])buffer.toArray(ClassTag$.MODULE$.apply(ExecTask.class)));
            ExecTask[] children = (ExecTask[])parentNode.getChildren();
            buffer.clear();
            buffer.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)));
            buffer.$plus$eq((Object)childNode);
            parentNode.withNewChildren((TreeNode[])buffer.toArray(ClassTag$.MODULE$.apply(ExecTask.class)));
            return;
        }
    }

    public void deleteNode(ExecTask node) {
        if (node.getParents() != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])node.getParents())).foreach((Function1 & Serializable & scala.Serializable)parent -> {
                TreeNodeUtil$.MODULE$.pruningTreeNode(parent, node);
                return BoxedUnit.UNIT;
            });
        }
        if (node.getChildren() != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])node.getChildren())).foreach((Function1 & Serializable & scala.Serializable)child -> {
                TreeNodeUtil$.MODULE$.pruningTreeNode(node, child);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void replaceNode(ExecTask currentNode, ExecTask newNode) {
        if (currentNode != null) {
            ExecTask[] children = (ExecTask[])((ExecTask[])currentNode.getChildren()).clone();
            ExecTask[] parents = (ExecTask[])((ExecTask[])currentNode.getParents()).clone();
            this.deleteNode(currentNode);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).foreach((Function1 & Serializable & scala.Serializable)child -> {
                TreeNodeUtil$.MODULE$.relateParentWithChild(newNode, child);
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents)).foreach((Function1 & Serializable & scala.Serializable)parent -> {
                TreeNodeUtil$.MODULE$.relateParentWithChild(parent, newNode);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void recursionSearch(ExecTask node, Map<String, ExecTaskStatusInfo> statusInfoMap, ArrayBuffer<ExecTask> failedTasks) {
        TaskResponse taskResponse;
        ExecTaskStatusInfo status;
        Object object = node != null ? ((status = (ExecTaskStatusInfo)statusInfoMap.get((Object)node.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null)) != null ? ((taskResponse = status.taskResponse()) instanceof FailedTaskResponse ? failedTasks.$plus$eq((Object)node) : BoxedUnit.UNIT) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        ExecTask[] children = (ExecTask[])node.getChildren();
        if (children != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).foreach((Function1 & Serializable & scala.Serializable)child -> {
                TreeNodeUtil$.MODULE$.recursionSearch(child, (Map<String, ExecTaskStatusInfo>)statusInfoMap, (ArrayBuffer<ExecTask>)failedTasks);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public ExecTask[] getAllFailedTaskNode(ExecTask rootNode) {
        PhysicalContext context = rootNode.getPhysicalContext();
        HashMap statusInfoMap = context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) != null ? (Map)context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) : new HashMap();
        ArrayBuffer failedTasks = new ArrayBuffer();
        this.recursionSearch(rootNode, (Map<String, ExecTaskStatusInfo>)statusInfoMap, (ArrayBuffer<ExecTask>)failedTasks);
        return (ExecTask[])failedTasks.toArray(ClassTag$.MODULE$.apply(ExecTask.class));
    }

    public TaskResponse getTaskResponse(ExecTask task) {
        PhysicalContext context = task.getPhysicalContext();
        if (context != null) {
            Object statusInfoMap = context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) != null ? (Map)context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) : new HashMap();
            ExecTaskStatusInfo taskStatusInfo = (ExecTaskStatusInfo)statusInfoMap.get((Object)task.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
            if (taskStatusInfo != null) {
                return taskStatusInfo.taskResponse();
            }
            return null;
        }
        return null;
    }

    public Option<ExecTaskStatusInfo> removeTaskResponse(ExecTask task) {
        PhysicalContext context = task.getPhysicalContext();
        if (context != null) {
            HashMap statusInfoMap = context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) != null ? (Map)context.get(StatusInfoExecTask$.MODULE$.STATUS_INFO_MAP_KEY()) : new HashMap();
            return statusInfoMap.remove((Object)task.getId());
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$pruningTreeNode$1(ExecTask childNode$1, ExecTask x$1) {
        ExecTask execTask = x$1;
        ExecTask execTask2 = childNode$1;
        return execTask == null ? execTask2 != null : !execTask.equals(execTask2);
    }

    public static final /* synthetic */ boolean $anonfun$pruningTreeNode$2(ExecTask parentNode$1, ExecTask x$2) {
        ExecTask execTask = x$2;
        ExecTask execTask2 = parentNode$1;
        return execTask == null ? execTask2 != null : !execTask.equals(execTask2);
    }

    private TreeNodeUtil$() {
        MODULE$ = this;
    }
}

