/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleStatementImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleCreatePackageStatement
extends OracleStatementImpl
implements SQLCreateStatement {
    private boolean orReplace;
    private SQLName name;
    private boolean body;
    private final List<SQLStatement> statements = new ArrayList<SQLStatement>();

    public OracleCreatePackageStatement() {
        super.setDbType(DbType.oracle);
    }

    @Override
    public void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.name);
            this.acceptChild((SQLASTVisitor)visitor, this.statements);
        }
        visitor.endVisit(this);
    }

    @Override
    public OracleCreatePackageStatement clone() {
        OracleCreatePackageStatement x = new OracleCreatePackageStatement();
        x.orReplace = this.orReplace;
        if (this.name != null) {
            x.setName(this.name.clone());
        }
        x.body = this.body;
        for (SQLStatement stmt : this.statements) {
            SQLStatement s2 = stmt.clone();
            s2.setParent(x);
            x.statements.add(s2);
        }
        return x;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public boolean isBody() {
        return this.body;
    }

    public void setBody(boolean body) {
        this.body = body;
    }

    @Override
    public SQLName getName() {
        return this.name;
    }

    public void setName(SQLName name) {
        if (name != null) {
            name.setParent(this);
        }
        this.name = name;
    }

    public List<SQLStatement> getStatements() {
        return this.statements;
    }
}

