/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.AbstractContextClient;
import org.apache.linkis.cs.client.Context;
import org.apache.linkis.cs.client.LinkisWorkFlowContext;
import org.apache.linkis.cs.client.builder.ContextClientConfig;
import org.apache.linkis.cs.client.builder.HttpContextClientConfig;
import org.apache.linkis.cs.client.errorcode.CsClientErrorCodeSummary;
import org.apache.linkis.cs.client.http.ContextBindIDAction;
import org.apache.linkis.cs.client.http.ContextBindIDResult;
import org.apache.linkis.cs.client.http.ContextBindKeyAction;
import org.apache.linkis.cs.client.http.ContextBindKeyResult;
import org.apache.linkis.cs.client.http.ContextClearByIDResult;
import org.apache.linkis.cs.client.http.ContextClearByTimeResult;
import org.apache.linkis.cs.client.http.ContextCreateAction;
import org.apache.linkis.cs.client.http.ContextCreateResult;
import org.apache.linkis.cs.client.http.ContextGetValueAction;
import org.apache.linkis.cs.client.http.ContextGetValueResult;
import org.apache.linkis.cs.client.http.ContextHistoriesGetResult;
import org.apache.linkis.cs.client.http.ContextHistoryGetResult;
import org.apache.linkis.cs.client.http.ContextPostActionBuilder;
import org.apache.linkis.cs.client.http.ContextRemoveAction;
import org.apache.linkis.cs.client.http.ContextRemoveResult;
import org.apache.linkis.cs.client.http.ContextResetIDAction;
import org.apache.linkis.cs.client.http.ContextResetIDResult;
import org.apache.linkis.cs.client.http.ContextResetResult;
import org.apache.linkis.cs.client.http.ContextResetValueAction;
import org.apache.linkis.cs.client.http.ContextSearchContextAction;
import org.apache.linkis.cs.client.http.ContextSearchIDByTimeAction;
import org.apache.linkis.cs.client.http.ContextSearchIDByTimeResult;
import org.apache.linkis.cs.client.http.ContextSearchResult;
import org.apache.linkis.cs.client.http.ContextSetKeyValueAction;
import org.apache.linkis.cs.client.http.ContextSetKeyValueResult;
import org.apache.linkis.cs.client.http.DefaultContextPostAction;
import org.apache.linkis.cs.client.http.HttpHeartBeater;
import org.apache.linkis.cs.client.listener.ContextIDListener;
import org.apache.linkis.cs.client.listener.ContextKeyListener;
import org.apache.linkis.cs.client.listener.HeartBeater;
import org.apache.linkis.cs.client.utils.ContextClientConf;
import org.apache.linkis.cs.client.utils.ContextServerHttpConf;
import org.apache.linkis.cs.client.utils.ExceptionHelper;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.history.ContextHistory;
import org.apache.linkis.cs.common.entity.source.CommonContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.entity.source.LinkisHAWorkFlowContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.search.ContextSearchConditionMapBuilder;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.dws.DWSHttpClient;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.dws.response.DWSResult;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.response.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextClient
extends AbstractContextClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpContextClient.class);
    private DWSHttpClient dwsHttpClient;
    private ContextClientConfig contextClientConfig;
    private final String linkis_version = (String)Configuration.LINKIS_WEB_VERSION().getValue();
    private final String name = "HttpContextClient";
    private static HttpContextClient httpContextClient;
    private HeartBeater heartBeater;

    private HttpContextClient() {
    }

    private HttpContextClient(ContextClientConfig contextClientConfig) {
        this.contextClientConfig = contextClientConfig;
        if (contextClientConfig instanceof HttpContextClientConfig) {
            HttpContextClientConfig httpContextClientConfig = (HttpContextClientConfig)contextClientConfig;
            ClientConfig clientConfig = httpContextClientConfig.getClientConfig();
            DWSClientConfig dwsClientConfig = new DWSClientConfig(clientConfig);
            dwsClientConfig.setDWSVersion(this.linkis_version);
            this.dwsHttpClient = new DWSHttpClient(dwsClientConfig, "HttpContextClient");
        }
        if ("true".equals(ContextClientConf.HEART_BEAT_ENABLED().getValue())) {
            this.heartBeater = new HttpHeartBeater(contextClientConfig);
            this.heartBeater.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpContextClient getInstance(ContextClientConfig contextClientConfig) {
        if (httpContextClient != null) return httpContextClient;
        Class<HttpContextClient> clazz = HttpContextClient.class;
        synchronized (HttpContextClient.class) {
            if (httpContextClient != null) return httpContextClient;
            httpContextClient = new HttpContextClient(contextClientConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return httpContextClient;
        }
    }

    @Override
    @Deprecated
    public Context createContext(String projectName, String flowName, String user, Map<String, Object> params) throws ErrorException {
        ContextCreateAction contextCreateAction = new ContextCreateAction();
        LinkisHAWorkFlowContextID contextID = new LinkisHAWorkFlowContextID();
        contextID.setProject(projectName);
        contextID.setFlow(flowName);
        String contextIDStr = SerializeHelper.serializeContextID((ContextID)contextID);
        contextCreateAction.addHeader("contextID", contextIDStr);
        contextCreateAction.getRequestPayloads().put("contextID", contextIDStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextCreateAction);
        }
        catch (Exception e) {
            LOGGER.error("create context failed", (Throwable)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.CREATE_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.CREATE_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextCreateResult) {
            ContextCreateResult contextCreateResult = (ContextCreateResult)result;
            int status = contextCreateResult.getStatus();
            if (status != 0) {
                String errMsg = contextCreateResult.getMessage();
                LOGGER.error("create context for project {}, flow {} failed, msg is {}", new Object[]{projectName, flowName, errMsg});
                throw new ErrorException(80014, "create context failed" + errMsg);
            }
            LinkisWorkFlowContext context = new LinkisWorkFlowContext();
            Map<String, Object> map = contextCreateResult.getData();
            contextID.setContextId(map.get("contextId").toString());
            context.setContextID((ContextID)contextID);
            context.setContextClient(this);
            context.setUser(user);
            return context;
        }
        if (result != null) {
            LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
            throw new ErrorException(80015, "result is not a correct type");
        }
        LOGGER.error("result is null");
        throw new ErrorException(80015, "result is null");
    }

    @Override
    public Context createContext(ContextID contextID) throws ErrorException {
        ContextCreateAction contextCreateAction = new ContextCreateAction();
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        LOGGER.info("contextIDStr: {}", (Object)contextIDStr);
        contextCreateAction.addHeader("contextID", contextIDStr);
        contextCreateAction.getRequestPayloads().put("contextID", contextIDStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextCreateAction);
        }
        catch (Exception e) {
            LOGGER.error("create context failed", (Throwable)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.CREATE_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.CREATE_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextCreateResult) {
            ContextCreateResult contextCreateResult = (ContextCreateResult)result;
            int status = contextCreateResult.getStatus();
            if (status != 0) {
                String errMsg = contextCreateResult.getMessage();
                LOGGER.error("create context failed, msg is {}", (Object)errMsg);
                throw new ErrorException(80014, "create context failed" + errMsg);
            }
            LinkisWorkFlowContext context = new LinkisWorkFlowContext();
            Map<String, Object> map = contextCreateResult.getData();
            contextID.setContextId(map.get("contextId").toString());
            context.setContextID(contextID);
            context.setContextClient(this);
            return context;
        }
        if (result != null) {
            LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
            throw new ErrorException(80015, "result is not a correct type");
        }
        LOGGER.error("result is null");
        throw new ErrorException(80015, "result is null");
    }

    @Override
    public Context getContext(ContextID contextId) throws ErrorException {
        LinkisWorkFlowContext context = new LinkisWorkFlowContext();
        context.setContextID(contextId);
        context.setContextClient(this);
        return context;
    }

    @Override
    public Context getContext(String contextIDStr) throws ErrorException {
        ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
        return this.getContext(contextID);
    }

    @Override
    public ContextValue getContextValue(ContextID contextID, ContextKey contextKey) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        String contextKeyStr = SerializeHelper.serializeContextKey(contextKey);
        ContextGetValueAction contextGetValueAction = new ContextGetValueAction();
        contextGetValueAction.addHeader("contextID", contextIDStr);
        contextGetValueAction.getRequestPayloads().put("contextID", contextIDStr);
        contextGetValueAction.getRequestPayloads().put("contextKey", contextKeyStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextGetValueAction);
        }
        catch (Exception e) {
            LOGGER.error("get context value id: {} , key: {} failed", new Object[]{contextIDStr, contextKeyStr, e});
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.GET_CONTEXT_VALUE_FAILED.getErrorCode(), CsClientErrorCodeSummary.GET_CONTEXT_VALUE_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextGetValueResult) {
            ContextGetValueResult contextGetValueResult = (ContextGetValueResult)result;
            int status = contextGetValueResult.getStatus();
            if (status != 0) {
                String errMsg = contextGetValueResult.getMessage();
                LOGGER.error("get context value id: {} , key: {} failed, msg is {}", new Object[]{contextIDStr, contextKeyStr, errMsg});
                throw new ErrorException(80014, "create context failed" + errMsg);
            }
            Map<String, Object> map = contextGetValueResult.getData();
            if (null == map || null == map.get("contextValue")) {
                return null;
            }
            String contextValueStr = map.get("contextValue").toString();
            return SerializeHelper.deserializeContextValue(contextValueStr);
        }
        if (result != null) {
            LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
            throw new ErrorException(80015, "result is not a correct type");
        }
        LOGGER.error("result is null");
        throw new ErrorException(80015, "result is null");
    }

    @Override
    public void update(ContextID contextID, ContextKey contextKey, ContextValue contextValue) throws ErrorException {
        String contextIdStr = SerializeHelper.SERIALIZE_HELPER.serialize((Object)contextID);
        String contextKeyValueStr = SerializeHelper.SERIALIZE_HELPER.serialize((Object)new CommonContextKeyValue(contextKey, contextValue));
        ContextSetKeyValueAction contextSetKeyValueAction = new ContextSetKeyValueAction();
        contextSetKeyValueAction.addHeader("contextID", contextIdStr);
        contextSetKeyValueAction.getRequestPayloads().put("contextID", contextIdStr);
        contextSetKeyValueAction.getRequestPayloads().put("contextKeyValue", contextKeyValueStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextSetKeyValueAction);
        }
        catch (Exception e) {
            LOGGER.error("update context failed", (Throwable)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.UPDATE_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.UPDATE_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextSetKeyValueResult) {
            ContextSetKeyValueResult contextSetKeyValueResult = (ContextSetKeyValueResult)result;
            int status = contextSetKeyValueResult.getStatus();
            if (status != 0) {
                String errMsg = contextSetKeyValueResult.getMessage();
                LOGGER.error("Calling client to update ContextId {} failed with error message {} returned (\u8c03\u7528\u5ba2\u6237\u7aef\u53bb\u66f4\u65b0contextId {} \u5931\u8d25, \u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f {}) ", new Object[]{contextIdStr, errMsg, contextIdStr, errMsg});
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public void reset(ContextID contextID, ContextKey contextKey) throws ErrorException {
        String contextIdStr = SerializeHelper.SERIALIZE_HELPER.serialize((Object)contextID);
        String contextKeyStr = SerializeHelper.SERIALIZE_HELPER.serialize((Object)contextKey);
        ContextResetValueAction contextResetValueAction = new ContextResetValueAction();
        contextResetValueAction.getRequestPayloads().put("contextKey", contextKeyStr);
        contextResetValueAction.getRequestPayloads().put("contextID", contextIdStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextResetValueAction);
        }
        catch (Exception e) {
            LOGGER.error("reset contextID {}, contextKey {}  failed", new Object[]{contextIdStr, contextKeyStr, e});
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.RESET_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.RESET_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextResetResult) {
            ContextResetResult contextResetResult = (ContextResetResult)result;
            int status = contextResetResult.getStatus();
            if (status != 0) {
                String errMsg = contextResetResult.getMessage();
                LOGGER.error("ContextKey {} fails to reset the ContextId {} with error message {} (\u8c03\u7528\u5ba2\u6237\u7aef\u53bbreset contextId {}, contextKey {} \u5931\u8d25, \u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f {} )", new Object[]{contextKeyStr, contextIdStr, errMsg, contextIdStr, contextKeyStr, errMsg});
                throw new ErrorException(80015, "reset contextID failed");
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public void reset(ContextID contextID) throws ErrorException {
        String contextIdStr = SerializeHelper.serializeContextID(contextID);
        ContextResetIDAction contextResetIDAction = new ContextResetIDAction();
        contextResetIDAction.getRequestPayloads().put("contextID", contextIdStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextResetIDAction);
        }
        catch (Exception e) {
            LOGGER.error("reset contextID {} failed", (Object)contextIdStr, (Object)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.RESET_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.RESET_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextResetIDResult) {
            ContextResetIDResult contextResetResult = (ContextResetIDResult)result;
            int status = contextResetResult.getStatus();
            if (status != 0) {
                String errMsg = contextResetResult.getMessage();
                LOGGER.error("The call to the client to reset ContextId {} failed with error message {} returned(\u8c03\u7528\u5ba2\u6237\u7aef\u53bbreset contextId {} \u5931\u8d25, \u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f {} )", new Object[]{contextIdStr, errMsg, contextIdStr, errMsg});
                throw new ErrorException(80015, "reset contextID failed");
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public void remove(ContextID contextID, ContextKey contextKey) throws ErrorException {
        String contextIdStr = SerializeHelper.serializeContextID(contextID);
        String contextKeyStr = SerializeHelper.serializeContextKey(contextKey);
        ContextRemoveAction contextRemoveAction = new ContextRemoveAction(contextIdStr, contextKeyStr);
        contextRemoveAction.addHeader("contextID", contextIdStr);
        contextRemoveAction.getRequestPayloads().put("contextKey", contextKeyStr);
        contextRemoveAction.getRequestPayloads().put("contextID", contextIdStr);
        contextRemoveAction.getRequestPayloads().put("contextId", contextID.getContextId());
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextRemoveAction);
        }
        catch (Exception e) {
            LOGGER.error("remove context id {} context key {} failed", new Object[]{contextIdStr, contextIdStr, e});
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.REMOVE_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.REMOVE_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextRemoveResult) {
            ContextRemoveResult contextRemoveResult = (ContextRemoveResult)result;
            int status = contextRemoveResult.getStatus();
            if (status != 0) {
                String errMsg = contextRemoveResult.getMessage();
                LOGGER.error("remove context failed contextID {}, contextKey {} ", (Object)contextIdStr, (Object)contextKey.getKey());
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public void setContextKeyValue(ContextID contextID, ContextKeyValue contextKeyValue) throws ErrorException {
        String contextIDStr = SerializeHelper.SERIALIZE_HELPER.serialize((Object)contextID);
        String contextKeyValueStr = SerializeHelper.SERIALIZE_HELPER.serialize((Object)contextKeyValue);
        ContextSetKeyValueAction action = new ContextSetKeyValueAction();
        action.addHeader("contextID", contextIDStr);
        action.getRequestPayloads().put("contextID", contextIDStr);
        action.getRequestPayloads().put("contextKeyValue", contextKeyValueStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)action);
        }
        catch (Exception e) {
            LOGGER.error("set value failed", (Throwable)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.UPDATE_CONTEXT_FAILED.getErrorCode(), CsClientErrorCodeSummary.REMOVE_CONTEXT_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextSetKeyValueResult) {
            ContextSetKeyValueResult contextSetKeyValueResult = (ContextSetKeyValueResult)result;
            int status = contextSetKeyValueResult.getStatus();
            if (status != 0) {
                String errMsg = contextSetKeyValueResult.getMessage();
                LOGGER.error("set value failed {} ,err is {}", (Object)contextIDStr, (Object)errMsg);
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public void bindContextIDListener(ContextIDListener contextIDListener) throws ErrorException {
        ContextID contextID = contextIDListener.getContextID();
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        ContextBindIDAction contextBindIDAction = new ContextBindIDAction();
        contextBindIDAction.getRequestPayloads().put("contextID", contextIDStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextBindIDAction);
        }
        catch (Exception e) {
            LOGGER.error("bind context id {} failed", (Object)contextIDStr, (Object)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.BIND_CONTEXTID_FAILED.getErrorCode(), CsClientErrorCodeSummary.BIND_CONTEXTID_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextBindIDResult) {
            ContextBindIDResult contextBindIDResult = (ContextBindIDResult)result;
            int status = contextBindIDResult.getStatus();
            if (status != 0) {
                String errMsg = contextBindIDResult.getMessage();
                LOGGER.error("bind context id failed {} ,err is {}", (Object)contextIDStr, (Object)errMsg);
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public void bindContextKeyListener(ContextKeyListener contextKeyListener) throws ErrorException {
        ContextID contextID = contextKeyListener.getContext().getContextID();
        ContextKey contextKey = contextKeyListener.getContextKey();
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        String contextKeyStr = SerializeHelper.serializeContextKey(contextKey);
        ContextBindKeyAction contextBindKeyAction = new ContextBindKeyAction();
        contextBindKeyAction.addHeader("contextID", contextIDStr);
        contextBindKeyAction.getRequestPayloads().put("contextID", contextIDStr);
        contextBindKeyAction.getRequestPayloads().put("contextKey", contextKeyStr);
        contextBindKeyAction.getRequestPayloads().put("source", "HttpContextClient");
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextBindKeyAction);
        }
        catch (Exception e) {
            LOGGER.error("bind context id {} context key {} failed", new Object[]{contextIDStr, contextKeyStr, e});
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.BIND_CONTEXTID_FAILED.getErrorCode(), CsClientErrorCodeSummary.BIND_CONTEXTID_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextBindKeyResult) {
            ContextBindKeyResult contextBindKeyResult = (ContextBindKeyResult)result;
            int status = contextBindKeyResult.getStatus();
            if (status != 0) {
                String errMsg = contextBindKeyResult.getMessage();
                LOGGER.error("bind context id {} context key {} failed ,err is {}", new Object[]{contextIDStr, contextKeyStr, errMsg});
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
    }

    @Override
    public List<ContextKeyValue> search(ContextID contextID, List<ContextType> contextTypes, List<ContextScope> contextScopes, List<String> contains, List<String> regex) throws ErrorException {
        return this.search(contextID, contextTypes, contextScopes, contains, regex, false, null, Integer.MAX_VALUE, null);
    }

    @Override
    public List<ContextKeyValue> search(ContextID contextID, List<ContextType> contextTypes, List<ContextScope> contextScopes, List<String> contains, List<String> regex, boolean upstream, String nodeName, int num, List<Class> contextValueTypes) throws ErrorException {
        ContextSearchConditionMapBuilder builder = ContextSearchConditionMapBuilder.newBuilder();
        if (contextTypes != null) {
            contextTypes.forEach(xva$0 -> builder.contextTypes(new ContextType[]{xva$0}));
        }
        if (contextScopes != null) {
            contextScopes.forEach(xva$0 -> builder.contextScopes(new ContextScope[]{xva$0}));
        }
        if (contains != null) {
            contains.forEach(arg_0 -> ((ContextSearchConditionMapBuilder)builder).contains(arg_0));
        }
        if (regex != null) {
            regex.forEach(arg_0 -> ((ContextSearchConditionMapBuilder)builder).regex(arg_0));
        }
        builder.nearest(nodeName, Integer.valueOf(num), Boolean.valueOf(upstream));
        if (contextValueTypes != null) {
            contextValueTypes.forEach(xva$0 -> builder.contextValueTypes(new Class[]{xva$0}));
        }
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        ContextSearchContextAction contextSearchContextAction = new ContextSearchContextAction();
        contextSearchContextAction.addHeader("contextID", contextIDStr);
        contextSearchContextAction.getRequestPayloads().put("condition", builder.build());
        contextSearchContextAction.getRequestPayloads().put("contextID", contextIDStr);
        Result result = null;
        try {
            result = this.dwsHttpClient.execute((Action)contextSearchContextAction);
        }
        catch (Exception e) {
            LOGGER.error("search condition failed", (Throwable)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.SEARCH_CONDITION_FAILED.getErrorCode(), CsClientErrorCodeSummary.SEARCH_CONDITION_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextSearchResult) {
            ContextSearchResult contextSearchResult = (ContextSearchResult)result;
            int status = contextSearchResult.getStatus();
            if (status != 0) {
                String errMsg = contextSearchResult.getMessage();
                LOGGER.error("search condition failed, err is  {}", (Object)errMsg);
            } else {
                Map<String, Object> data = contextSearchResult.getData();
                if (data.get("contextKeyValue") != null) {
                    ArrayList<ContextKeyValue> retKvs = new ArrayList<ContextKeyValue>();
                    Object o = data.get("contextKeyValue");
                    List list = (List)o;
                    list.stream().map(s -> {
                        try {
                            return SerializeHelper.deserializeContextKeyValue(s);
                        }
                        catch (ErrorException e) {
                            LOGGER.error("failed to deserialize {} to a contextKeyValue", s, (Object)e);
                            return null;
                        }
                    }).filter(Objects::nonNull).forEach(retKvs::add);
                    return retKvs;
                }
            }
        } else {
            if (result != null) {
                LOGGER.error("result is not a correct type, result type is {}", (Object)result.getClass().getSimpleName());
                throw new ErrorException(80015, "result is not a correct type");
            }
            LOGGER.error("result is null");
            throw new ErrorException(80015, "result is null");
        }
        return null;
    }

    @Override
    public void createHistory(ContextID contextID, ContextHistory history) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.createContextHistory()).with("contextID", contextIDStr).with(history).addHeader("contextID", contextIDStr).build();
        this.checkDWSResult(this.execute((Action)action));
    }

    @Override
    public void removeHistory(ContextID contextID, ContextHistory history) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.removeContextHistory()).with("contextID", contextIDStr).with(history).addHeader("contextID", contextIDStr).build();
        this.checkDWSResult(this.execute((Action)action));
    }

    @Override
    public List<ContextHistory> getHistories(ContextID contextID) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.getContextHistories()).with("contextID", contextIDStr).addHeader("contextID", contextIDStr).build();
        DWSResult dwsResult = this.checkDWSResult(this.execute((Action)action));
        ContextHistoriesGetResult result = (ContextHistoriesGetResult)dwsResult;
        ArrayList<ContextHistory> histories = new ArrayList<ContextHistory>();
        for (String s : result.getContextHistory()) {
            histories.add(SerializeHelper.deserializeContextHistory(s));
        }
        return histories;
    }

    @Override
    public ContextHistory getHistory(ContextID contextID, String source) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.getContextHistory()).with("contextID", contextIDStr).with("source", source).addHeader("contextID", contextIDStr).build();
        DWSResult dwsResult = this.checkDWSResult(this.execute((Action)action));
        ContextHistoryGetResult result = (ContextHistoryGetResult)dwsResult;
        return result.getContextHistory() == null ? null : SerializeHelper.deserializeContextHistory(result.getContextHistory());
    }

    @Override
    public List<ContextHistory> searchHistory(ContextID contextID, String ... keyword) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.searchContextHistory()).with("contextID", contextIDStr).with("keywords", keyword).addHeader("contextID", contextIDStr).build();
        DWSResult dwsResult = this.checkDWSResult(this.execute((Action)action));
        ContextHistoriesGetResult result = (ContextHistoriesGetResult)dwsResult;
        ArrayList<ContextHistory> histories = new ArrayList<ContextHistory>();
        for (String s : result.getContextHistory()) {
            histories.add(SerializeHelper.deserializeContextHistory(s));
        }
        return histories;
    }

    @Override
    public void removeAllValueByKeyPrefixAndContextType(ContextID contextID, ContextType contextType, String keyPrefix) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.removeAllValueByKeyPrefixAndContextTypeURL()).with("contextID", contextIDStr).with("contextKeyType", contextType.toString()).with("keyPrefix", keyPrefix).addHeader("contextID", contextIDStr).build();
        this.checkDWSResult(this.execute((Action)action));
    }

    @Override
    public void removeAllValueByKeyAndContextType(ContextID contextID, ContextType contextType, String key) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.removeAllValueByKeyAndContextTypeURL()).with("contextID", contextIDStr).with("contextKeyType", contextType.toString()).with("contextKey", key).addHeader("contextID", contextIDStr).build();
        this.checkDWSResult(this.execute((Action)action));
    }

    @Override
    public void removeAllValueByKeyPrefix(ContextID contextID, String keyPrefix) throws ErrorException {
        String contextIDStr = SerializeHelper.serializeContextID(contextID);
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.removeAllValueByKeyPrefixURL()).with("contextID", contextIDStr).with("keyPrefix", keyPrefix).addHeader("contextID", contextIDStr).build();
        this.checkDWSResult(this.execute((Action)action));
    }

    @Override
    public List<String> searchHAIDByTime(String createTimeStart, String createTimeEnd, String updateTimeStart, String updateTimeEnd, String accessTimeStart, String accessTimeEnd, Integer pageNow, Integer pageSize) throws ErrorException {
        if (StringUtils.isBlank((CharSequence)createTimeStart) && StringUtils.isBlank((CharSequence)createTimeEnd) && StringUtils.isBlank((CharSequence)updateTimeStart) && StringUtils.isBlank((CharSequence)updateTimeEnd) && StringUtils.isBlank((CharSequence)accessTimeStart) && StringUtils.isBlank((CharSequence)accessTimeEnd)) {
            throw new CSErrorException(97000, " createTimeStart,  createTimeEnd,  updateTimeStart,  updateTimeEnd,  accessTimeStart,  accessTimeEnd cannot all be blank.");
        }
        ContextSearchIDByTimeAction action = new ContextSearchIDByTimeAction();
        action.setParameter("createTimeStart", createTimeStart);
        action.setParameter("createTimeEnd", createTimeEnd);
        action.setParameter("updateTimeStart", updateTimeStart);
        action.setParameter("updateTimeEnd", updateTimeEnd);
        action.setParameter("accessTimeStart", accessTimeStart);
        action.setParameter("accessTimeEnd", accessTimeEnd);
        action.setParameter("pageNow", pageNow);
        action.setParameter("pageSize", pageSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(action.getURL());
        }
        Result result = null;
        try {
            result = this.execute((Action)action);
        }
        catch (Exception e) {
            LOGGER.error("searchHAIDByTime failed, {}", (Object)e.getMessage(), (Object)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.HAIDBYTIME_FAILED.getErrorCode(), CsClientErrorCodeSummary.HAIDBYTIME_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextSearchIDByTimeResult) {
            ContextSearchIDByTimeResult contextSearchIDByTimeResult = (ContextSearchIDByTimeResult)result;
            if (null != contextSearchIDByTimeResult && null != contextSearchIDByTimeResult.getContextIDs()) {
                return contextSearchIDByTimeResult.getContextIDs();
            }
            return new ArrayList<String>();
        }
        if (null == result) {
            throw new CSErrorException(80017, "Invalid null result ");
        }
        throw new CSErrorException(80017, "Invalid result type : " + result.getClass().getName());
    }

    @Override
    public int batchClearContextByHAID(List<String> idList) throws ErrorException {
        if (null == idList) {
            return 0;
        }
        if (idList.size() > 5000) {
            throw new CSErrorException(97000, "idList size : " + idList.size() + " is over max page size : " + 5000);
        }
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.clearAllContextByID()).with("idList", idList).build();
        Result result = null;
        try {
            result = this.execute((Action)action);
        }
        catch (Exception e) {
            LOGGER.error("batchClearContextByHAID failed, {}", (Object)e.getMessage(), (Object)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.CLEAR_CONTEXT_HAID_FAILED.getErrorCode(), CsClientErrorCodeSummary.CLEAR_CONTEXT_HAID_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextClearByIDResult) {
            ContextClearByIDResult contextClearByIDResult = (ContextClearByIDResult)result;
            if (null != contextClearByIDResult) {
                return contextClearByIDResult.num();
            }
            return 0;
        }
        if (null == result) {
            throw new CSErrorException(80017, "Invalid null result ");
        }
        throw new CSErrorException(80017, "Invalid result type : " + result.getClass().getName());
    }

    @Override
    public int batchClearContextByTime(String createTimeStart, String createTimeEnd, String updateTimeStart, String updateTimeEnd, String accessTimeStart, String accessTimeEnd) throws ErrorException {
        if (StringUtils.isBlank((CharSequence)createTimeStart) && StringUtils.isBlank((CharSequence)createTimeEnd) && StringUtils.isBlank((CharSequence)updateTimeStart) && StringUtils.isBlank((CharSequence)updateTimeEnd) && StringUtils.isBlank((CharSequence)accessTimeStart) && StringUtils.isBlank((CharSequence)accessTimeEnd)) {
            throw new CSErrorException(97000, " createTimeStart,  createTimeEnd,  updateTimeStart,  updateTimeEnd,  accessTimeStart,  accessTimeEnd cannot all be blank.");
        }
        DefaultContextPostAction action = ContextPostActionBuilder.of(ContextServerHttpConf.clearAllContextByTime()).with("createTimeStart", createTimeStart).with("createTimeEnd", createTimeEnd).with("updateTimeStart", updateTimeStart).with("updateTimeEnd", updateTimeEnd).with("accessTimeStart", accessTimeStart).with("accessTimeEnd", accessTimeEnd).build();
        Result result = null;
        try {
            result = this.execute((Action)action);
        }
        catch (Exception e) {
            LOGGER.error("batchClearContextByTime failed, {}", (Object)e.getMessage(), (Object)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.CLEAR_CONTEXT_HAID_FAILED.getErrorCode(), CsClientErrorCodeSummary.CLEAR_CONTEXT_HAID_FAILED.getErrorDesc(), e);
        }
        if (result instanceof ContextClearByTimeResult) {
            ContextClearByTimeResult contextClearByTimeResult = (ContextClearByTimeResult)result;
            if (null != contextClearByTimeResult) {
                return contextClearByTimeResult.num();
            }
            return 0;
        }
        if (null == result) {
            throw new CSErrorException(80017, "Invalid null result ");
        }
        throw new CSErrorException(80017, "Invalid result type : " + result.getClass().getName());
    }

    private Result execute(Action action) throws ErrorException {
        try {
            return this.dwsHttpClient.execute(action);
        }
        catch (Exception e) {
            LOGGER.error("execute failed", (Throwable)e);
            ExceptionHelper.throwErrorException(CsClientErrorCodeSummary.EXECUTE_FALIED.getErrorCode(), CsClientErrorCodeSummary.EXECUTE_FALIED.getErrorDesc(), e);
            return null;
        }
    }

    private DWSResult checkDWSResult(Result result) throws CSErrorException {
        if (result instanceof DWSResult) {
            int status = ((DWSResult)result).getStatus();
            if (status != 0) {
                String errMsg = ((DWSResult)result).getMessage();
                LOGGER.error("request failed, err is  {}", (Object)errMsg);
                throw new CSErrorException(80015, errMsg);
            }
            return (DWSResult)result;
        }
        throw new CSErrorException(80015, "resulet is not instance of DWSResult");
    }

    @Override
    public void close() throws IOException {
        try {
            LOGGER.info("client close");
            if (null != this.dwsHttpClient) {
                this.dwsHttpClient.close();
                this.heartBeater.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to close httpContextClient", (Throwable)e);
            throw new IOException(e);
        }
    }
}

